<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class CleanupExportFiles extends Command
{
    protected $signature = 'exports:cleanup';
    protected $description = 'Clean up old temporary export files (older than 1 hour)';

    public function handle()
    {
        $tempDir = storage_path('app/temp/exports');

        if (!File::exists($tempDir)) {
            $this->info('No temp exports directory found.');
            return 0;
        }

        $deleted = 0;
        $oneHourAgo = now()->subHour()->timestamp;

        foreach (File::directories($tempDir) as $directory) {
            // Check if directory is older than 1 hour
            if (File::lastModified($directory) < $oneHourAgo) {
                // Delete all files in directory
                File::deleteDirectory($directory);
                $deleted++;
                $this->line("Deleted: " . basename($directory));
            }
        }

        if ($deleted > 0) {
            $this->info("✓ Cleaned up {$deleted} old export directories");
        } else {
            $this->info('No old export files to clean up');
        }

        return 0;
    }
}
