# 📊 Multistore Forecasting System

AI-powered sales forecasting and marketing ROI analysis platform built with Laravel, Facebook Prophet, and AI strategic insights.

---

## ✨ Key Features

### 🤖 AI-Powered Forecasting
- **Sales Predictions** - Facebook Prophet ML model for 3-24 month forecasts
- **Seasonal Detection** - Automatic trend and seasonality analysis
- **Confidence Intervals** - Upper and lower prediction bounds
- **Historical Analysis** - Learn from 12+ months of sales data

### 📈 Marketing Strategy Dashboard
- **Dual Revenue View** - Toggle between All Sales vs HQ Only
- **ROI Analysis** - Both percentage and ratio formats (e.g., 150% = 2.50x)
- **Channel Performance** - Track Brand Ambassadors, Paid Ads, Social Media, Events
- **Platform Breakdown** - Facebook, Instagram, TikTok, Google, YouTube, etc.
- **AI Strategic Insights** - Context-aware recommendations from Ollama or ChatGPT
- **Monthly/Yearly Analysis** - Detailed performance tracking

### 💼 Business Intelligence
- **Multi-Channel Sales** - Track HQ, Stokis, and Agent sales separately
- **Expense Management** - Net profit calculations and profit margin tracking
- **Seller Targets** - Set and monitor monthly performance goals
- **POS Integration** - Real-time order sync from external systems
- **Advanced Reports** - Sales performance, ROI, forecast accuracy

---

## 🚀 Quick Start

### Prerequisites
- Ubuntu 20.04+ / 22.04+
- OpenLiteSpeed web server
- MariaDB 10.6+ or MySQL 8.0+
- PHP 8.1+
- Python 3.9+ (for forecasting)
- 4GB+ RAM (8GB recommended)

### Installation

```bash
# 1. Clone/upload application files
cd /var/www/multistore

# 2. Install dependencies
composer install --no-dev --optimize-autoloader
npm install && npm run build

# 3. Configure environment
cp .env.example .env
nano .env  # Update database, AI provider, etc.

# 4. Generate key and migrate database
php artisan key:generate
php artisan migrate --force

# 5. Set permissions
sudo chown -R nobody:nogroup /var/www/multistore
sudo chmod -R 755 /var/www/multistore
sudo chmod -R 775 /var/www/multistore/storage
sudo chmod -R 775 /var/www/multistore/bootstrap/cache

# 6. Optimize for production
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

### Create Admin User

```bash
php artisan tinker

# In tinker console:
$user = new App\Models\User();
$user->name = 'Admin';
$user->email = 'admin@yourdomain.com';
$user->password = bcrypt('your_secure_password');
$user->save();
exit
```

---

## 📚 Documentation

All documentation has been reorganized for easier navigation.

**Start here:** [📖 Documentation Index](docs/index.md)

### Quick Links

**Getting Started:**
- [Installation Guide](docs/getting-started/installation.md) - Set up from scratch
- [System Requirements](docs/getting-started/requirements.md) - Check compatibility
- [Database Setup](docs/getting-started/database.md) - Configure database

**Deployment:**
- [Production Deployment](docs/deployment/production.md) - Go live
- [OpenLiteSpeed Setup](docs/deployment/openlitespeed.md) - Web server configuration
- [Queue Workers](docs/deployment/queue-workers.md) - Background job processing
- [Deployment Checklist](docs/deployment/checklist.md) - Pre-launch verification

**Features:**
- [Google Sheets Integration](docs/features/google-sheets/setup.md) - Auto-sync orders
- [PWA Push Notifications](docs/features/pwa-push-notifications/setup.md) - Real-time alerts
- [Sales Forecasting](docs/features/forecasting/installation.md) - AI predictions
- [Custom Domains](docs/features/custom-domains/setup.md) - Seller domains

**Administration:**
- [Admin Guide](docs/admin/setup-guide.md) - Admin panel usage
- [Backup & Recovery](docs/admin/backup-recovery.md) - Data protection
- [Features Reference](docs/admin/features.md) - Complete feature list

**Troubleshooting:**
- [General Debugging](docs/troubleshooting/debugging.md) - Common issues
- [Google Sheets Issues](docs/features/google-sheets/troubleshooting.md) - Sync problems
- [PWA Issues](docs/features/pwa-push-notifications/troubleshooting.md) - Notification problems

### Version History

See [CHANGELOG.md](CHANGELOG.md) for all updates and changes.

---

## 🎯 Key Concepts

### Revenue Modes (Toggle Feature)
- **All Sales Mode** - Shows HQ + Stokis + Agent total revenue
- **HQ Only Mode** - Shows HQ sales only (direct marketing impact)

**Why it matters:** Marketing spend primarily affects HQ sales, not agent/stokis sales. Use HQ Only mode for accurate marketing ROI analysis.

### ROI Display Formats
- **Percentage Format:** `150%` = ((Revenue - Spend) / Spend) × 100
- **Ratio Format:** `2.50x` = Revenue / Spend (RM 2.50 return per RM 1 spent)

Both formats displayed throughout the system.

### AI Providers
- **Ollama** - Free, self-hosted, private, no API costs (RECOMMENDED)
- **ChatGPT** - Paid, cloud-based, advanced capabilities (OPTIONAL)

---

## 🛠️ Common Commands

```bash
# Clear all caches
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# Rebuild caches (production)
php artisan config:cache
php artisan route:cache
php artisan view:cache

# View logs
tail -f storage/logs/laravel.log

# Test Python/Prophet connection
php artisan tinker
$controller = new App\Http\Controllers\ForecastingController();
$result = $controller->testProphetConnection();
exit

# Check Ollama status (if using)
sudo systemctl status ollama
curl http://localhost:11434/api/tags

# Queue worker management
sudo supervisorctl status
sudo supervisorctl restart multistore-worker:*
```

---

## 🔧 Environment Configuration

### Required Variables

```env
# Application
APP_NAME="Multistore Forecasting"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

# Database
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=multistore_production
DB_USERNAME=your_db_user
DB_PASSWORD=your_secure_password

# AI Provider (Ollama - Recommended)
AI_PROVIDER=ollama
OLLAMA_URL=http://localhost:11434
OLLAMA_MODEL=mistral

# OR ChatGPT (Alternative)
# AI_PROVIDER=chatgpt
# OPENAI_API_KEY=sk-your-api-key-here

# Prophet Python Path
PYTHON_PATH=/var/www/multistore/venv/bin/python3.9
PROPHET_SCRIPT=/var/www/multistore/forecast_prophet.py

# Queue & Session
QUEUE_CONNECTION=database
SESSION_DRIVER=database
CACHE_DRIVER=file
```

---

## 📋 System Requirements

| Component | Minimum | Recommended |
|-----------|---------|-------------|
| **OS** | Ubuntu 20.04 | Ubuntu 22.04+ |
| **Web Server** | OpenLiteSpeed 1.7+ | Latest stable |
| **Database** | MariaDB 10.6+ | MariaDB 10.11+ |
| **PHP** | 8.1 | 8.3+ |
| **Python** | 3.9 | 3.11+ |
| **CPU** | 2 cores | 4+ cores |
| **RAM** | 4GB | 8GB+ |
| **Storage** | 50GB SSD | 100GB+ SSD |

### Required PHP Extensions
- BCMath, Ctype, cURL, DOM, Fileinfo, Filter, Hash
- Mbstring, OpenSSL, PCRE, PDO, Session, Tokenizer
- XML, GD, ZIP

---

## 🔐 Security Features

- Laravel Breeze authentication
- CSRF protection
- SQL injection protection (Eloquent ORM)
- XSS protection (Blade templating)
- API token authentication
- Role-based access control
- Encrypted sensitive data

---

## ✅ Production Checklist

Before going live, verify:

- [ ] Application loads at your domain
- [ ] SSL certificate valid and active
- [ ] Database connection working
- [ ] Python 3.9+ installed
- [ ] Prophet library installed
- [ ] Ollama or ChatGPT configured
- [ ] Forecasting feature works
- [ ] AI recommendations generating
- [ ] Queue worker running (Supervisor)
- [ ] Laravel Scheduler active (cron)
- [ ] File permissions correct
- [ ] All caches optimized
- [ ] APP_DEBUG=false in .env
- [ ] Backups configured
- [ ] Admin user created

---

## 🐛 Troubleshooting

### Forecasting not working?
```bash
# Check Python installation
python3.9 --version

# Test Prophet import
source /var/www/multistore/venv/bin/activate
python -c "import prophet; print(prophet.__version__)"

# Check permissions
ls -la /var/www/multistore/forecast_prophet.py
chmod +x /var/www/multistore/forecast_prophet.py
```

### AI suggestions not generating?
```bash
# For Ollama
sudo systemctl status ollama
curl http://localhost:11434/api/tags
ollama list

# Check Laravel logs
tail -100 /var/www/multistore/storage/logs/laravel.log
```

### Database issues?
```bash
# Test connection
php artisan tinker
DB::connection()->getPdo();

# Verify credentials
cat .env | grep DB_
mysql -u your_user -p -e "SHOW DATABASES;"
```

**For detailed troubleshooting:** See documentation files above.

---

## 📞 Support & Resources

- **Business Strategy:** [BUSINESS_STRATEGY.md](BUSINESS_STRATEGY.md) ⭐ **NEW**
- **Deployment Guide:** [DEPLOYMENT.md](DEPLOYMENT.md)
- **Setup Guide:** [SETUP_GUIDE.md](SETUP_GUIDE.md)
- **Features Reference:** [FEATURES_REFERENCE.md](FEATURES_REFERENCE.md)
- **Changelog:** [CHANGELOG.md](CHANGELOG.md) ⭐ **NEW**
- **Laravel Docs:** https://laravel.com/docs/10.x
- **Prophet Docs:** https://facebook.github.io/prophet/
- **Ollama Docs:** https://ollama.com/

---

## 🎨 Technology Stack

- **Backend:** Laravel 10.x (PHP 8.1+)
- **Frontend:** TailwindCSS, Alpine.js, Livewire
- **Charts:** Chart.js
- **Forecasting:** Facebook Prophet (Python)
- **AI:** Ollama (Mistral) or OpenAI (ChatGPT)
- **Database:** MariaDB 10.6+
- **Web Server:** OpenLiteSpeed
- **Queue:** Laravel Queue (Database driver)
- **Scheduler:** Laravel Scheduler (Cron)

---

## 📈 Version Information

**Version:** 1.3.1
**Laravel:** 10.x
**PHP:** 8.1+
**Python:** 3.9+
**Prophet:** 1.1.5
**Last Updated:** 2025-11-14

---

## 🚀 Ready to Deploy?

1. **Understand business:** [BUSINESS_STRATEGY.md](BUSINESS_STRATEGY.md) ⭐ **NEW**
2. **Deploy application:** [DEPLOYMENT.md](DEPLOYMENT.md)
3. **Setup AI & Prophet:** [SETUP_GUIDE.md](SETUP_GUIDE.md) ⚠️ **CRITICAL**
4. **Learn features:** [FEATURES_REFERENCE.md](FEATURES_REFERENCE.md)
5. **Track changes:** [CHANGELOG.md](CHANGELOG.md) ⭐ **NEW**

---

**Built with Laravel, TailwindCSS, Facebook Prophet, and AI**

🤖 **AI-Powered Sales Intelligence for Modern Businesses**
