#!/bin/bash
# Fix "Can not perform a '--user' install" error
# Run: bash FIX_USER_INSTALL_ERROR.sh

echo "=========================================="
echo "Fix pip --user Install Error"
echo "=========================================="
echo ""

echo "Step 1: Removing pip config files..."

# Remove all possible pip config locations
rm -f ~/.pip/pip.conf
rm -f ~/.config/pip/pip.conf
rm -f $HOME/.pip/pip.conf
rm -f $HOME/.config/pip/pip.conf

echo "✓ Config files removed"

echo ""
echo "Step 2: Verifying pip config..."
pip config list 2>/dev/null || echo "No pip config found (good!)"

echo ""
echo "Step 3: Unsetting any global user config..."
pip config unset global.user 2>/dev/null || true
pip config unset user.user 2>/dev/null || true

echo ""
echo "=========================================="
echo "✓ Fix Complete!"
echo "=========================================="
echo ""
echo "Now you can run:"
echo "  source /var/www/mamadil.team/venv/bin/activate"
echo "  pip install prophet"
echo ""
echo "No more '--user install' error!"
echo ""
