# 📝 Changelog

All notable changes, updates, and fixes to the Multistore Forecasting System.

---

## [2025-11-14] - Latest Updates

### ✅ Seller KPI Manual Data Entry Feature
**Feature:** Edit past data for AI forecasting

**What Changed:**
- Added "Edit Past Data" button in Seller KPI monthly breakdown
- Editable "Actual Sales" and "Orders" columns
- Auto-calculation of Achievement %, Grade, AOV, and Trend
- Frontend: JavaScript edit mode with save/cancel functionality
- Backend: New route `POST /forecasting/seller-kpi/update-manual`
- New method: `SellerKpiController::updateManualData()`

**Why:** Need to input historical manual records so AI Forecast works (requires 3+ months minimum data)

**Files Changed:**
- `resources/views/forecasting/seller-kpi/show.blade.php`
- `routes/web.php`
- `app/Http/Controllers/SellerKpiController.php`

---

### 🎨 UI Design Improvements
**Changes:**
- Removed TikTok icon (📱) from /users page, kept text only
- Added `text-xs` class to TikTok button for space saving
- Removed TikTok icon from Management dropdown navigation (Admin & Manager views)

**Why:** Icons taking too much space, delete button touching edge, cleaner design

**Files Changed:**
- `resources/views/users/index.blade.php`
- `resources/views/layouts/app.blade.php`

---

## [2025-11-12] - Major Updates

### 🔄 Strategic Pivot: Export → Product Diversification
**Major Strategy Change**

**Removed:**
- ❌ Export expansion strategy
- ❌ MATRADE, MITI, JAKIM references
- ❌ International market suggestions (ASEAN, Middle East, China, Australia)
- ❌ Trade show recommendations
- ❌ Halal certification for export

**Added:**
- ✅ Product diversification as PRIMARY HQ growth strategy
- ✅ Coffee product success story as proof of concept
- ✅ 6 product category recommendations (Functional Beverages, Nutritional Foods, Men's Wellness, Family Health, Daily Wellness, Personal Care)
- ✅ 4-phase market research roadmap
- ✅ ROI projections for product launches

**Why:** User decision to focus on LOCAL Malaysian market through product variety instead of international expansion

**Files Changed:**
- `app/Http/Controllers/ForecastingController.php` (Lines 1080-1188)

**Documentation:**
- Created: `PRODUCT_DIVERSIFICATION_STRATEGY.md`
- Archived: `EXPORT_STRATEGY_DIRECTIVE.md`
- Created: `STRATEGY_UPDATE_2025-11-12.md`

---

### 📊 Accurate Business Metrics Update
**Critical Fix:** AI now has ACCURATE network size and revenue data

**Corrected Metrics:**
- **Stokis:** 11-12 total (NOT 120!), only 4-5 active, RM 7M/year
- **Agents:** 5,000 registered, only 10-20 active (99.6% dormant!), RM 400k/year
- **Dormant Agent Opportunity:** 4,980 dormant agents = potential RM 1.8M-7.2M/year

**Added:**
- 6 agent reactivation strategies with ROI calculations
- Realistic benchmarks (RM 3k/month per agent, RM 64k/month per stokis)
- Accurate risk assessment (losing 1 top stokis = RM 200k/month loss)

**Why:** AI was making wrong assumptions (thought there were 120 stokis!), giving generic advice without understanding 99.6% agent dormancy issue

**Files Changed:**
- `app/Http/Controllers/ForecastingController.php`

**Documentation:**
- Created: `ACCURATE_METRICS_UPDATE.md`

---

### 💰 Pricing Psychology Strategy
**Feature:** Help customers feel products are worth the money

**Added:**
- Box price context: RM 70-80 per box
- Per serving cost: RM 4-5 per day
- Savings comparison: vs eating meals outside (RM 10-20/day)
- Monthly savings calculations: RM 150-450/month
- Agent positioning scripts

**Why:** Make customers feel they're SAVING MONEY despite RM 80 upfront cost

**Files Changed:**
- `app/Http/Controllers/ForecastingController.php` (Lines 1150-1218)

**Documentation:**
- Updated: `PRICING_STRATEGY_GUIDE.md`

---

### 🔧 AWB Push Special Characters Fix
**Bug Fix:** Pos Laju AWB generation failing with special characters

**Problem:**
Push AWB button failed on live server when customer names/addresses contained:
- Apostrophes: `O'Brien`, `Ahmad's Shop`
- Backticks, quotes, backslashes
- Smart quotes, control characters

**Solution:**
- Created `PoslajuValidator::sanitizeText()` method
- Applied sanitization to all text fields sent to Pos Laju API
- Handles customer names, addresses, product descriptions, sender info

**Why:** Pos Laju API rejects requests with special characters, causing "Invalid character" errors

**Files Changed:**
- `app/Helpers/PoslajuValidator.php` (NEW method: Lines 9-48)
- `app/Services/PoslajuService.php` (Applied sanitization throughout)

**Documentation:**
- Created: `AWB_SPECIAL_CHARACTERS_FIX.md`

---

### 📄 Invoice Printing Margins Fix
**Bug Fix:** Text cut off at edges when printing invoices

**Change:**
- Increased padding from `p-6 print:p-4` to `p-8 print:p-6`

**Why:** Default padding too small for some printers, text being cut off

**Files Changed:**
- `resources/views/orders/invoice.blade.php` (Line 83)

---

### 📊 Multi-Year Chart Collapsible
**UI Improvement:** Hide Multi-Year chart by default

**Change:**
- Made Multi-Year Quarterly Trend chart collapsible
- Hidden by default when opening /forecasting
- Click to expand during board meetings
- Added chevron icon with rotation animation

**Why:** Chart takes up space, only needed during board meetings

**Files Changed:**
- `resources/views/forecasting/index.blade.php` (Lines 99-203, JavaScript: 1262-1276)

---

### 🤖 AI Business Context Update
**Improvement:** AI now understands business model

**Added Context:**
- Industry: Health, Beauty, Supplements
- Niche: Women's health & wellness
- Sales model: Stokis/Agent network
- E-commerce reality: Expensive, not successful
- Agent benchmarks: RM 3k/month average
- Stokis benchmarks: RM 40-100k/month

**Why:** AI was giving generic advice without knowing the business

**Files Changed:**
- `app/Http/Controllers/ForecastingController.php`

**Documentation:**
- Created: `AI_CONTEXT_UPDATE.md`

---

### 📈 Auto Sales Calculation for Current Month
**Feature:** Automatic sales calculation for current and future months

**What Changed:**
- Forecasting dashboard now shows current month (November 2025) sales
- Auto-calculates from Orders table + TikTok Shop transactions
- Real-time updates as new orders come in
- No need to manually upload data for current/future months

**Why:** Dashboard only showed data up to October 2025, missing current month sales

**Files Changed:**
- `app/Http/Controllers/ForecastingController.php` (Method: `getCurrentYearSales()`, Lines 252-329)

**Documentation:**
- Created: `AUTO_SALES_CALCULATION_UPDATE.md`

---

## [2025-01-15] - Export Strategy (ARCHIVED)

### 🌍 Export Expansion Strategy (REPLACED)
**Status:** ARCHIVED - Replaced by Product Diversification

**What it was:**
- Export to ASEAN, Middle East, China, Australia
- MATRADE, MITI, JAKIM partnerships
- Halal certification for export
- Trade show participation
- 4-phase export readiness roadmap

**Why replaced:** User decision to focus on local Malaysian market instead of international expansion

**Documentation:**
- Archived: `EXPORT_STRATEGY_DIRECTIVE.md`
- Replaced by: `PRODUCT_DIVERSIFICATION_STRATEGY.md`

---

## [2025-01-10] - Initial Release

### 🎉 Multistore Forecasting System v1.0.0
**Initial Production Release**

**Features:**
- AI-powered sales forecasting (Facebook Prophet)
- Marketing strategy dashboard with ROI analysis
- Multi-channel sales tracking (HQ, Stokis, Agents)
- Expense management and net profit calculations
- Seller KPI performance tracking
- TikTok Shop integration
- Pos Laju AWB generation
- Sales Pages system
- Order management
- Product catalog
- WhatsApp notifications

**Technology Stack:**
- Laravel 10.x (PHP 8.1+)
- TailwindCSS, Alpine.js
- Chart.js for visualizations
- Facebook Prophet (Python) for forecasting
- Ollama/ChatGPT for AI insights
- MariaDB database

---

## 📋 Documentation Structure (Reorganized 2025-11-14)

### Current Documentation Files:
- **README.md** - Project overview and quick start
- **BUSINESS_STRATEGY.md** - Complete business model and growth strategies (NEW - Consolidated)
- **SETUP_GUIDE.md** - Installation and setup instructions
- **DEPLOYMENT.md** - Production deployment guide
- **FEATURES_REFERENCE.md** - User features guide
- **DOCUMENTATION.md** - Technical documentation
- **CHANGELOG.md** - This file (NEW)

### Archived/Removed Documentation:
- ~~EXPORT_STRATEGY_DIRECTIVE.md~~ (Archived - strategy replaced)
- ~~STRATEGY_UPDATE_2025-11-12.md~~ (Merged into CHANGELOG.md)
- ~~AI_CONTEXT_UPDATE.md~~ (Merged into BUSINESS_STRATEGY.md)
- ~~AUTO_SALES_CALCULATION_UPDATE.md~~ (Merged into CHANGELOG.md)
- ~~AWB_SPECIAL_CHARACTERS_FIX.md~~ (Merged into CHANGELOG.md)
- ~~ACCURATE_METRICS_UPDATE.md~~ (Merged into BUSINESS_STRATEGY.md)
- ~~PRICING_STRATEGY_GUIDE.md~~ (Merged into BUSINESS_STRATEGY.md)
- ~~PRODUCT_DIVERSIFICATION_STRATEGY.md~~ (Merged into BUSINESS_STRATEGY.md)
- ~~STOKIS_AGENT_DIRECTIVES.md~~ (Merged into BUSINESS_STRATEGY.md)
- ~~FILE_GUIDE.md~~ (Redundant after reorganization)

---

## 🚀 Deployment Notes

### Files to Upload for Latest Version (2025-11-14):

**Required PHP Files:**
1. `app/Http/Controllers/ForecastingController.php`
2. `app/Http/Controllers/SellerKpiController.php`
3. `app/Helpers/PoslajuValidator.php`
4. `app/Services/PoslajuService.php`
5. `routes/web.php`

**Required View Files:**
6. `resources/views/forecasting/index.blade.php`
7. `resources/views/forecasting/seller-kpi/show.blade.php`
8. `resources/views/orders/invoice.blade.php`
9. `resources/views/users/index.blade.php`
10. `resources/views/layouts/app.blade.php`

**After Upload:**
```bash
php artisan view:clear
php artisan route:clear
php artisan config:clear
php artisan cache:clear
```

---

## 📊 Version Summary

| Version | Date | Key Changes |
|---------|------|-------------|
| 1.0.0 | 2025-01-10 | Initial production release |
| 1.1.0 | 2025-01-15 | Added export strategy (later archived) |
| 1.2.0 | 2025-11-12 | Strategic pivot to product diversification |
| 1.2.1 | 2025-11-12 | Accurate metrics & pricing psychology |
| 1.2.2 | 2025-11-12 | AWB special characters fix |
| 1.2.3 | 2025-11-12 | Invoice margins & multi-year chart fixes |
| 1.3.0 | 2025-11-14 | Seller KPI manual data entry & UI improvements |
| 1.3.1 | 2025-11-14 | Documentation consolidation & cleanup |

---

**Current Version:** 1.3.1
**Last Updated:** 2025-11-14
**Status:** ✅ Production Ready
