<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <!-- SEO Meta Tags -->
        <?php echo \App\Helpers\SeoHelper::generateMetaTags(
            $metaTitle ?? null,
            $metaDescription ?? null,
            $metaImage ?? null,
            $additionalMeta ?? []
        ); ?>


        <!-- Favicon -->
        <?php if(\App\Helpers\SeoHelper::favicon()): ?>
            <link rel="icon" type="image/x-icon" href="<?php echo e(\App\Helpers\SeoHelper::favicon()); ?>">
        <?php endif; ?>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Structured Data -->
        <?php echo \App\Helpers\SeoHelper::organizationSchema(); ?>


        <!-- Custom Theme CSS -->
        <?php if(\App\Helpers\SeoHelper::themeMode() === 'custom'): ?>
        <style>
            <?php echo \App\Helpers\SeoHelper::generateCustomThemeCSS(); ?>

        </style>
        <?php endif; ?>

        <!-- Theme Mode Script (must run before body renders to prevent flash) -->
        <script>
            const themeMode = '<?php echo e(\App\Helpers\SeoHelper::themeMode()); ?>';

            if (themeMode === 'dark') {
                document.documentElement.classList.add('dark');
                document.documentElement.classList.remove('custom');
            } else if (themeMode === 'custom') {
                document.documentElement.classList.add('custom');
                document.documentElement.classList.remove('dark');
            } else {
                // System default
                if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                    document.documentElement.classList.add('dark');
                    document.documentElement.classList.remove('custom');
                } else {
                    document.documentElement.classList.remove('dark');
                    document.documentElement.classList.remove('custom');
                }
            }
        </script>

        <!-- Google Analytics -->
        <?php if(\App\Helpers\SeoHelper::googleAnalyticsId()): ?>
            <?php echo \App\Helpers\SeoHelper::googleAnalyticsScript(); ?>

        <?php endif; ?>

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
            <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- Page Heading -->
            <?php if(isset($header)): ?>
                <header class="bg-white dark:bg-gray-800 shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        <?php echo e($header); ?>

                    </div>
                </header>
            <?php endif; ?>

            <!-- Page Content -->
            <main>
                <?php echo e($slot); ?>

            </main>

            <!-- Footer -->
            <?php if (isset($component)) { $__componentOriginal8a8716efb3c62a45938aca52e78e0322 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8a8716efb3c62a45938aca52e78e0322 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.footer','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8a8716efb3c62a45938aca52e78e0322)): ?>
<?php $attributes = $__attributesOriginal8a8716efb3c62a45938aca52e78e0322; ?>
<?php unset($__attributesOriginal8a8716efb3c62a45938aca52e78e0322); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8a8716efb3c62a45938aca52e78e0322)): ?>
<?php $component = $__componentOriginal8a8716efb3c62a45938aca52e78e0322; ?>
<?php unset($__componentOriginal8a8716efb3c62a45938aca52e78e0322); ?>
<?php endif; ?>
        </div>
    </body>
</html>
<?php /**PATH C:\laragon\www\gengsewa\resources\views/layouts/app.blade.php ENDPATH**/ ?>