<div>
    {{-- Availability Info Banner --}}
    @php
        $bookedDates = $calendarData['booked'] ?? [];
        $bufferDates = $calendarData['buffer'] ?? [];
    @endphp

    @if($listing->buffer_hours > 0 || count($bookedDates) > 0 || count($bufferDates) > 0)
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-3">
            <div class="flex items-start gap-2">
                <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div class="text-sm text-gray-700 dark:text-gray-300">
                    <p class="font-semibold mb-1">Booking Availability Information</p>
                    <ul class="text-xs space-y-1 text-gray-600 dark:text-gray-400">
                        @if($listing->buffer_hours > 0)
                            <li><strong>{{ $listing->buffer_hours }} hour</strong> preparation buffer after each checkout</li>
                        @endif
                        <li>Select a date to see available time slots</li>
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form wire:submit="book">
        <div class="space-y-6">
            {{-- Slot Calendar Picker --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                    Select Check-in Date & Time
                </label>

                <div id="slot-calendar-container" class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
                    {{-- Calendar will be rendered here by JavaScript --}}
                </div>

                @error('check_in') <span class="text-red-500 dark:text-red-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                @error('check_in_hour') <span class="text-red-500 dark:text-red-400 text-xs mt-1 block">{{ $message }}</span> @enderror
            </div>

            {{-- Selected Slot Display --}}
            @if($check_in && $check_in_hour !== '')
                <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-3">
                    <p class="text-sm font-semibold text-green-800 dark:text-green-200">Check-in Selected:</p>
                    <p class="text-lg font-bold text-green-900 dark:text-green-100">
                        {{ \Carbon\Carbon::parse($check_in)->format('F d, Y') }} at {{ \Carbon\Carbon::parse($check_in_hour . ':00')->format('g:i A') }}
                    </p>
                </div>
            @endif

            {{-- Checkout Slot Picker --}}
            @if($check_in && $check_in_hour !== '')
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                        Select Check-out Date & Time
                    </label>

                    <div id="checkout-calendar-container" class="bg-white dark:bg-gray-800 rounded-lg p-4 border border-gray-200 dark:border-gray-700">
                        {{-- Checkout calendar will be rendered here --}}
                    </div>

                    @error('check_out') <span class="text-red-500 dark:text-red-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                    @error('check_out_hour') <span class="text-red-500 dark:text-red-400 text-xs mt-1 block">{{ $message }}</span> @enderror
                </div>
            @endif

            {{-- Selected Checkout Display --}}
            @if($check_out && $check_out_hour !== '')
                <div class="bg-purple-50 dark:bg-purple-900/20 border border-purple-200 dark:border-purple-800 rounded-lg p-3">
                    <p class="text-sm font-semibold text-purple-800 dark:text-purple-200">Check-out Selected:</p>
                    <p class="text-lg font-bold text-purple-900 dark:text-purple-100">
                        {{ \Carbon\Carbon::parse($check_out)->format('F d, Y') }} at {{ \Carbon\Carbon::parse($check_out_hour . ':00')->format('g:i A') }}
                    </p>
                </div>
            @endif

            {{-- Rest of the form (guests, locations, add-ons, payment) --}}
            @if($check_in && $check_out && $check_in_hour !== '' && $check_out_hour !== '')
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Guests (Max: {{ $listing->capacity }})</label>
                    <input type="number" wire:model.live="guests" min="1" max="{{ $listing->capacity }}" value="1" required
                           class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    @error('guests') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
                </div>

                {{-- Pickup/Dropoff Locations --}}
                @if($listing->pickupLocations && $listing->pickupLocations->count() > 0)
                    <div class="border-t border-gray-200 dark:border-gray-700 pt-4">
                        <h3 class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-3 flex items-center">
                            <svg class="w-5 h-5 inline-block mr-2 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            Pickup & Dropoff Locations
                        </h3>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Pickup Location <span class="text-red-500">*</span>
                                </label>
                                <select wire:model="pickup_location_id" required
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="">Select pickup location</option>
                                    @foreach($listing->pickupLocations as $location)
                                        <option value="{{ $location->id }}">
                                            {{ $location->name }}
                                            @if($location->type !== 'general')
                                                ({{ ucfirst(str_replace('_', ' ', $location->type)) }})
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('pickup_location_id') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Dropoff Location <span class="text-red-500">*</span>
                                </label>
                                <select wire:model="dropoff_location_id" required
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="">Select dropoff location</option>
                                    @foreach($listing->pickupLocations as $location)
                                        <option value="{{ $location->id }}">
                                            {{ $location->name }}
                                            @if($location->type !== 'general')
                                                ({{ ucfirst(str_replace('_', ' ', $location->type)) }})
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('dropoff_location_id') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Add-ons --}}
                @if($listing->addOns && $listing->addOns->count() > 0)
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                            <svg class="w-4 h-4 inline-block mr-1 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                            Optional Add-ons
                        </label>
                        <div class="space-y-2 max-h-48 overflow-y-auto">
                            @foreach($listing->addOns as $addOn)
                                <label class="flex items-start p-3 bg-gray-50 dark:bg-gray-700/50 rounded border border-gray-200 dark:border-gray-600 cursor-pointer hover:border-blue-500 dark:hover:border-blue-400 transition">
                                    <input type="checkbox" wire:model.live="selectedAddOns" value="{{ $addOn->id }}" class="rounded border-gray-300 dark:border-gray-600 text-blue-600 focus:ring-blue-500 mt-1">
                                    <div class="ml-2 flex-1">
                                        <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $addOn->name }}</div>
                                        <div class="text-xs text-gray-600 dark:text-gray-400">{{ Str::limit($addOn->description, 50) }}</div>
                                        <div class="flex items-center gap-2 mt-1">
                                            <span class="text-xs text-blue-600 dark:text-blue-400 font-semibold">RM {{ number_format($addOn->pivot->custom_price ?? $addOn->price, 2) }}</span>
                                            <span class="text-xs px-2 py-0.5 bg-blue-600 dark:bg-blue-500 text-white rounded-full font-semibold">{{ $addOn->getPricingTypeLabel() }}</span>
                                        </div>
                                    </div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                @endif

                {{-- Payment Method --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payment Method</label>
                    <select wire:model="payment_channel" required
                            class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="fpx">FPX (Online Banking)</option>
                        <option value="tng">DuitNow QR</option>
                    </select>
                    @error('payment_channel') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
                </div>

                {{-- Price Breakdown --}}
                @if($days > 0)
                    <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4">
                        <div class="flex justify-between text-sm text-gray-700 dark:text-gray-300 mb-2">
                            <span>RM {{ number_format($listing->price_per_day, 2) }} x {{ $days }} days</span>
                            <span>RM {{ number_format($subtotal, 2) }}</span>
                        </div>

                        @if($discount_amount > 0)
                            <div class="flex justify-between text-sm text-green-600 dark:text-green-400 mb-2">
                                <span class="flex items-center">
                                    <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                    Discount ({{ number_format($discount_percentage, 0) }}% OFF)
                                </span>
                                <span>-RM {{ number_format($discount_amount, 2) }}</span>
                            </div>
                        @endif

                        @if($addOnsTotal > 0)
                            <div class="flex justify-between text-sm text-blue-600 dark:text-blue-400 mb-2">
                                <span class="flex items-center">
                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                    </svg>
                                    Add-ons ({{ count($selectedAddOns) }})
                                </span>
                                <span>+RM {{ number_format($addOnsTotal, 2) }}</span>
                            </div>
                        @endif

                        <div class="flex justify-between text-sm text-gray-700 dark:text-gray-300 mb-2 pt-2 border-t border-gray-200 dark:border-gray-600">
                            <span class="font-medium">Subtotal</span>
                            <span class="font-medium">RM {{ number_format($booking_amount, 2) }}</span>
                        </div>

                        @if($gateway_fee > 0)
                            <div class="flex justify-between text-sm text-gray-700 dark:text-gray-300 mb-2">
                                <span class="flex items-center">
                                    <svg class="w-4 h-4 mr-1 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                    </svg>
                                    Gateway Fee
                                </span>
                                <span>RM {{ number_format($gateway_fee, 2) }}</span>
                            </div>
                        @endif

                        <div class="flex justify-between font-bold text-lg text-gray-900 dark:text-gray-100 pt-2 border-t-2 border-gray-300 dark:border-gray-600">
                            <span>Total</span>
                            <span>RM {{ number_format($total_price, 2) }}</span>
                        </div>
                    </div>
                @endif

                <button type="submit"
                        class="w-full bg-blue-600 hover:bg-blue-700 dark:bg-blue-500 dark:hover:bg-blue-600 text-white font-semibold py-3 px-6 rounded-md transition"
                        @if($days <= 0) disabled @endif>
                    Book Now & Pay
                </button>
            @endif
        </div>
    </form>

    {{-- Inline Slot Calendar JavaScript --}}
    <script>
        window.bookingCalendarData = {
            bookedDates: @json($calendarData['booked'] ?? []),
            bufferDates: @json($calendarData['buffer'] ?? []),
            unavailableDates: @json($calendarData['unavailable'] ?? []),
            bufferPeriods: @json($calendarData['buffer_periods'] ?? []),
            bookedPeriods: @json($calendarData['booked_periods'] ?? [])
        };

        window.bufferHours = {{ $listing->buffer_hours ?? 0 }};
    </script>

    @script
    <script>
        // Slot calendar implementation will be added here
        console.log('Slot calendar ready', window.bookingCalendarData);
    </script>
    @endscript
</div>
