<div class="max-w-7xl mx-auto px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <!-- Hero Image with Masonry Gallery -->
    <div x-data="{
        showGallery: false,
        currentImage: 0,
        images: {{ json_encode($listing->images ?? []) }},
        openGallery(index) {
            this.currentImage = index;
            this.showGallery = true;
            document.body.style.overflow = 'hidden';
        },
        closeGallery() {
            this.showGallery = false;
            document.body.style.overflow = 'auto';
        },
        nextImage() {
            this.currentImage = (this.currentImage + 1) % this.images.length;
        },
        prevImage() {
            this.currentImage = (this.currentImage - 1 + this.images.length) % this.images.length;
        }
    }">
    @if($listing->images && count($listing->images) > 0)
        <div class="mb-4 sm:mb-6 md:mb-8">
            <!-- Mobile: Single image NO ratio lock -->
            <div class="block md:hidden">
                <div class="rounded-lg overflow-hidden shadow-lg">
                    <img src="{{ $listing->images[0] }}" alt="{{ $listing->title }}" class="w-full h-auto cursor-pointer" @click="openGallery(0)">
                </div>
                <!-- Photo button at bottom right -->
                <div class="flex justify-end" style="margin-top: -40px; position: relative; z-index: 10;">
                    <button @click="openGallery(0)" class="text-white px-3 py-2 rounded-lg shadow-lg text-sm font-semibold transition flex items-center gap-2" style="margin-right: 10px; background: #000;">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                        <span>View All {{ count($listing->images) }} Photos</span>
                    </button>
                </div>
            </div>

            <!-- Desktop: Hero Image + Thumbnail Row NO ratio lock -->
            <div class="hidden md:block">
                <!-- Main Hero Image - Natural height, no restriction -->
                <div class="rounded-lg overflow-hidden shadow-lg mb-2">
                    <img src="{{ $listing->images[0] }}" alt="{{ $listing->title }}" class="w-full h-auto cursor-pointer" @click="openGallery(0)">
                </div>

                <!-- View All Photos Button - Overlaid with negative margin -->
                <div class="flex justify-end mb-2" style="margin-top: -50px; position: relative; z-index: 10;">
                    <button @click="openGallery(0)" class="text-white px-4 py-2 rounded-lg shadow-lg text-sm font-bold transition-all flex items-center gap-2" style="margin-right: 20px; background: #000;">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                        <span>View All {{ count($listing->images) }} Photos</span>
                    </button>
                </div>

                <!-- Thumbnail Row (smaller images) -->
                @if(count($listing->images) > 1)
                <div class="grid grid-cols-6 md:grid-cols-7 lg:grid-cols-8 xl:grid-cols-10 gap-2" style="display:none;">
                    @foreach(array_slice($listing->images, 1, 10) as $index => $image)
                        <div class="relative rounded-md overflow-hidden shadow cursor-pointer hover:ring-2 hover:ring-blue-500 hover:scale-105 transition-all group" @click="openGallery({{ $index + 1 }})">
                            <img src="{{ $image }}" alt="{{ $listing->title }}" class="w-full object-cover" style="height: 70px;">
                            <div class="absolute inset-0 bg-black opacity-0 group-hover:opacity-20 transition-opacity"></div>
                            @if($loop->last && count($listing->images) > 11)
                                <div class="absolute inset-0 bg-black/70 flex items-center justify-center">
                                    <span class="text-white text-xs font-bold">+{{ count($listing->images) - 11 }}</span>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
                @endif
            </div>
        </div>
    @else
        <!-- Placeholder if no images -->
        <div class="mb-8 w-full h-[500px] rounded-lg overflow-hidden shadow-lg">
            <img src="https://placehold.co/1200x500" alt="{{ $listing->title }}" class="w-full h-full object-cover">
        </div>
    @endif

    <!-- Image Gallery Modal -->
    <div x-show="showGallery"
         x-cloak
         @keydown.escape.window="closeGallery()"
         @keydown.arrow-right.window="nextImage()"
         @keydown.arrow-left.window="prevImage()"
         class="fixed inset-0 z-50 bg-black bg-opacity-95 flex items-center justify-center"
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0">

        <!-- Close Button -->
        <button @click="closeGallery()" class="absolute top-4 right-4 text-white hover:text-gray-300 z-50">
            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
        </button>

        <!-- Image Counter -->
        <div class="absolute top-4 left-1/2 transform -translate-x-1/2 text-white bg-black bg-opacity-50 px-4 py-2 rounded-lg">
            <span x-text="currentImage + 1"></span> / <span x-text="images.length"></span>
        </div>

        <!-- Previous Button -->
        <button @click="prevImage()" class="absolute left-4 text-white hover:text-gray-300 bg-black bg-opacity-50 hover:bg-opacity-75 rounded-full p-2">
            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
        </button>

        <!-- Image Container -->
        <div class="max-w-7xl max-h-[90vh] mx-auto px-16">
            <img :src="images[currentImage]"
                 alt="{{ $listing->title }}"
                 class="max-w-full max-h-[90vh] object-contain mx-auto">
        </div>

        <!-- Next Button -->
        <button @click="nextImage()" class="absolute right-4 text-white hover:text-gray-300 bg-black bg-opacity-50 hover:bg-opacity-75 rounded-full p-2">
            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
            </svg>
        </button>

        <!-- Thumbnail Strip -->
        <div class="absolute bottom-4 left-0 right-0 overflow-x-auto">
            <div class="flex gap-2 justify-center px-4">
                <template x-for="(image, index) in images" :key="index">
                    <img :src="image"
                         @click="currentImage = index"
                         :class="{ 'ring-4 ring-blue-500': currentImage === index }"
                         class="w-20 h-20 object-cover rounded cursor-pointer hover:opacity-75 transition">
                </template>
            </div>
        </div>
    </div>
    </div>
    <!-- End of image gallery Alpine.js scope -->

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6 lg:gap-8">
        <div class="lg:col-span-2">

            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 sm:p-5 md:p-6 mb-4 sm:mb-6">
                <div class="flex items-center justify-between mb-3 sm:mb-4">
                    <div class="flex items-center flex-wrap gap-1.5 sm:gap-2">
                        <span class="bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200 px-3 sm:px-4 py-1 sm:py-1.5 rounded-full text-xs sm:text-sm font-semibold inline-flex items-center gap-1.5">
                            <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                            </svg>
                            {{ $listing->rentalType->name }}
                        </span>
                        <span class="bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200 px-3 sm:px-4 py-1 sm:py-1.5 rounded-full text-xs sm:text-sm font-semibold inline-flex items-center gap-1.5">
                            <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            {{ $listing->location->name }}
                        </span>
                        @if($listing->host->vacation_mode)
                            <span class="inline-flex items-center px-5 py-1.5 rounded-full text-sm font-bold text-white shadow-sm" style="background-color: #f97316;">
                                <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z"/>
                                </svg>
                                Host on Vacation
                            </span>
                        @endif
                    </div>
                </div>

                <h1 class="text-xl sm:text-2xl md:text-3xl font-bold text-gray-900 dark:text-gray-100 mb-3 sm:mb-4">{{ $listing->title }}</h1>

                @if($listing->reviews_count > 0)
                    <div class="flex items-center mb-3 sm:mb-4">
                        <div class="flex items-center">
                            @for($i = 1; $i <= 5; $i++)
                                @if($i <= round($listing->reviews_avg_rating))
                                    <svg class="w-4 h-4 sm:w-5 sm:h-5 text-yellow-400 fill-current" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                @else
                                    <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-300 dark:text-gray-600 fill-current" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                @endif
                            @endfor
                            <span class="ml-1.5 sm:ml-2 text-base sm:text-lg font-semibold text-gray-900 dark:text-white">{{ number_format($listing->reviews_avg_rating, 1) }}</span>
                            <span class="ml-1.5 sm:ml-2 text-sm sm:text-base text-gray-600 dark:text-gray-400">({{ $listing->reviews_count }} {{ $listing->reviews_count === 1 ? 'review' : 'reviews' }})</span>
                        </div>
                    </div>
                @endif

                <div class="flex items-center text-gray-600 dark:text-gray-400 text-sm sm:text-base mb-4 sm:mb-6">
                    <svg class="w-4 h-4 sm:w-5 sm:h-5 mr-1.5 sm:mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                    <span>Up to {{ $listing->capacity }} guests</span>
                </div>

                <div class="prose max-w-none mb-4 sm:mb-6">
                    <h3 class="text-lg sm:text-xl font-semibold text-gray-900 dark:text-gray-100 mb-2 sm:mb-3">Description</h3>
                    <div class="text-gray-700 dark:text-gray-300 text-sm sm:text-base prose prose-sm max-w-none
                         prose-headings:text-gray-900 dark:prose-headings:text-gray-100
                         prose-p:text-gray-700 dark:prose-p:text-gray-300
                         prose-ul:text-gray-700 dark:prose-ul:text-gray-300
                         prose-ol:text-gray-700 dark:prose-ol:text-gray-300
                         prose-li:text-gray-700 dark:prose-li:text-gray-300
                         prose-strong:text-gray-900 dark:prose-strong:text-white">
                        {!! nl2br(e($listing->description)) !!}
                    </div>
                </div>

                @if($listing->amenities && count($listing->amenities) > 0)
                    <div class="mb-4 sm:mb-6">
                        <h3 class="text-lg sm:text-xl font-semibold text-gray-900 dark:text-gray-100 mb-2 sm:mb-3">Amenities</h3>
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-2 sm:gap-3">
                            @foreach($listing->amenities as $amenity)
                                <div class="flex items-center text-gray-700 dark:text-gray-300 text-sm sm:text-base">
                                    <svg class="w-4 h-4 sm:w-5 sm:h-5 mr-1.5 sm:mr-2 text-green-500 dark:text-green-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                    </svg>
                                    {{ $amenity }}
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                @if($listing->discountTiers && $listing->discountTiers->count() > 0)
                    <div class="mb-6 pt-6 border-t border-gray-200 dark:border-gray-700">
                        <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-2 flex items-center">
                            <svg class="w-6 h-6 mr-2 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Special Discounts
                        </h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mb-3">Save more when you book for multiple days!</p>
                        <div class="space-y-2">
                            @foreach($listing->discountTiers as $tier)
                                <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-3 flex items-center justify-between">
                                    <div class="flex items-center">
                                        <div class="bg-green-100 dark:bg-green-800 rounded-full p-1.5 mr-2">
                                            <svg class="w-4 h-4 text-green-600 dark:text-green-300" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-sm font-semibold text-gray-900 dark:text-gray-100">
                                                Minimum:
                                                @if($tier->max_days)
                                                    {{ $tier->min_days }}-{{ $tier->max_days }} days
                                                @else
                                                    {{ $tier->min_days }}+ days
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-xl font-bold text-green-600 dark:text-green-400">{{ number_format($tier->discount_value, 0) }}% OFF</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                @if($listing->addOns && $listing->addOns->count() > 0)
                    <div class="pt-6 border-t border-gray-200 dark:border-gray-700">
                        <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-3 flex items-center">
                            <svg class="w-6 h-6 mr-2 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                            Available Add-ons
                        </h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Enhance your experience with these optional extras</p>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            @foreach($listing->addOns as $addOn)
                                <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                                    <div class="flex items-start justify-between">
                                        <div class="flex-1">
                                            <h4 class="font-semibold text-gray-900 dark:text-gray-100 mb-1">{{ $addOn->name }}</h4>
                                            <p class="text-sm text-gray-600 dark:text-gray-400 mb-2">{{ $addOn->description }}</p>
                                            <div class="flex items-center gap-2">
                                                <span class="text-lg font-bold text-blue-600 dark:text-blue-400">RM {{ number_format($addOn->pivot->custom_price ?? $addOn->price, 2) }}</span>
                                                <span class="text-xs px-2 py-1 bg-blue-600 dark:bg-blue-500 text-white dark:text-white rounded-full font-semibold">{{ $addOn->getPricingTypeLabel() }}</span>
                                            </div>
                                        </div>
                                        <div class="ml-3">
                                            <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <div class="lg:col-span-1">
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 sm:p-5 md:p-6 lg:sticky lg:top-4">
                <div class="mb-4 sm:mb-6">
                    <div class="text-2xl sm:text-3xl font-bold text-blue-600 dark:text-blue-400 mb-1 sm:mb-2">
                        RM {{ number_format($listing->price_per_day, 2) }}
                    </div>
                    <div class="text-sm sm:text-base text-gray-600 dark:text-gray-400">per day</div>
                </div>

                @if($listing->host->vacation_mode)
                    <!-- Vacation Mode Notice -->
                    <div class="bg-gradient-to-r from-orange-100 to-amber-100 dark:from-gray-700 dark:to-gray-700 border-2 border-orange-400 dark:border-orange-500 rounded-xl p-6 mb-6 shadow-md">
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-12 h-12 bg-orange-500 rounded-full flex items-center justify-center">
                                <svg class="w-7 h-7 text-white" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z"/>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <h4 class="font-bold text-orange-900 dark:text-white text-lg mb-2">Host Currently on Vacation</h4>
                                <p class="text-sm text-orange-800 dark:text-gray-200 font-medium leading-relaxed">This listing is temporarily unavailable for booking. The host will return soon!</p>
                            </div>
                        </div>
                    </div>
                    <button disabled class="block w-full bg-gray-500 dark:bg-gray-600 text-gray-300 dark:text-gray-300 font-bold py-4 px-6 rounded-lg text-center cursor-not-allowed border-2 border-gray-400 dark:border-gray-500">
                        <svg class="w-5 h-5 inline-block mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path>
                        </svg>
                        Booking Unavailable
                    </button>
                @else
                    @auth
                        <livewire:booking-form :listing-id="$listing->id" />
                    @else
                        <a href="{{ route('login') }}" class="block w-full bg-blue-600 hover:bg-blue-700 dark:bg-blue-500 dark:hover:bg-blue-600 text-white font-semibold py-3 px-6 rounded-md text-center transition">
                            Login to Book
                        </a>
                    @endauth
                @endif

                <div class="mt-6 pt-6 border-t border-gray-200 dark:border-gray-700">
                    <div class="flex items-start gap-3 mb-3">
                        <div class="w-12 h-12 bg-indigo-600 rounded-full flex items-center justify-center text-white font-bold text-xl">
                            {{ strtoupper(substr($listing->host->name, 0, 1)) }}
                        </div>
                        <div class="flex-1">
                            <div class="flex items-center gap-2 flex-wrap">
                                <h4 class="font-semibold text-gray-900 dark:text-gray-100">Hosted by {{ $listing->host->name }}</h4>
                                @php
                                    $hostBadge = $listing->host->highest_badge ?? $listing->host->activeBadges()->first();
                                @endphp
                                @if($hostBadge)
                                    @php
                                        $badgeConfig = \App\Models\BadgeConfig::where('badge_type', $hostBadge->badge_type)->first();
                                    @endphp
                                    <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-bold
                                        @if($badgeConfig && $badgeConfig->color === 'gold') bg-yellow-100 dark:bg-yellow-900 text-yellow-800 dark:text-yellow-200
                                        @elseif($badgeConfig && $badgeConfig->color === 'silver') bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-gray-200
                                        @elseif($badgeConfig && $badgeConfig->color === 'bronze') bg-orange-100 dark:bg-orange-900 text-orange-800 dark:text-orange-200
                                        @else bg-purple-100 dark:bg-purple-900 text-purple-800 dark:text-purple-200
                                        @endif">
                                        {{ $badgeConfig->icon ?? '🏅' }} {{ $badgeConfig->name ?? $hostBadge->display_name }}
                                    </span>
                                @endif
                            </div>
                            @php
                                $hostListings = $listing->host->listings;
                                $totalReviews = \App\Models\Review::whereIn('listing_id', $hostListings->pluck('id'))->count();
                                $avgRating = \App\Models\Review::whereIn('listing_id', $hostListings->pluck('id'))->avg('rating');
                            @endphp
                            @if($totalReviews > 0)
                                <div class="flex items-center gap-2 mt-1">
                                    <div class="flex items-center">
                                        <svg class="w-4 h-4 text-yellow-400 fill-current" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                        </svg>
                                        <span class="ml-1 text-sm font-semibold text-gray-900 dark:text-white">{{ number_format($avgRating, 1) }}</span>
                                    </div>
                                    <span class="text-sm text-gray-600 dark:text-gray-400">({{ $totalReviews }} {{ $totalReviews === 1 ? 'review' : 'reviews' }})</span>
                                </div>
                            @endif
                            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Member since {{ $listing->host->created_at->format('Y') }}</p>
                        </div>
                    </div>
                    @if($listing->host->vacation_mode)
                        <div class="mt-2">
                            <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-bold bg-orange-100 dark:bg-orange-900 text-orange-800 dark:text-orange-200">
                                <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                </svg>
                                On Vacation
                            </span>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Reviews Section -->
    @if($listing->reviews_count > 0)
        <div class="mt-12">
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                <h2 class="text-2xl font-bold text-gray-900 dark:text-gray-100 mb-6">
                    Guest Reviews
                    <span class="text-gray-500 dark:text-gray-400 text-lg font-normal ml-2">({{ $listing->reviews_count }})</span>
                </h2>

                <!-- Overall Rating Summary -->
                <div class="flex items-center mb-8 pb-6 border-b border-gray-200 dark:border-gray-700">
                    <div class="flex items-center">
                        @for($i = 1; $i <= 5; $i++)
                            @if($i <= round($listing->reviews_avg_rating))
                                <svg class="w-8 h-8 text-yellow-400 fill-current" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            @else
                                <svg class="w-8 h-8 text-gray-300 dark:text-gray-600 fill-current" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            @endif
                        @endfor
                        <span class="ml-3 text-3xl font-bold text-gray-900 dark:text-white">{{ number_format($listing->reviews_avg_rating, 1) }}</span>
                        <span class="ml-2 text-gray-600 dark:text-gray-400">out of 5</span>
                    </div>
                </div>

                <!-- Filter Options -->
                <div class="flex items-center justify-between mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">
                        Showing {{ $reviews->count() }} of {{ $listing->reviews_count }} reviews
                    </h3>
                    <div class="flex gap-2">
                        <button wire:click="setReviewFilter('recent')"
                            class="px-4 py-2 rounded-lg text-sm font-medium transition
                                {{ $reviewFilter === 'recent' ? 'bg-blue-600 text-white' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-600' }}">
                            Most Recent
                        </button>
                        <button wire:click="setReviewFilter('highest')"
                            class="px-4 py-2 rounded-lg text-sm font-medium transition
                                {{ $reviewFilter === 'highest' ? 'bg-blue-600 text-white' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-600' }}">
                            Highest Rating
                        </button>
                        <button wire:click="setReviewFilter('lowest')"
                            class="px-4 py-2 rounded-lg text-sm font-medium transition
                                {{ $reviewFilter === 'lowest' ? 'bg-blue-600 text-white' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-600' }}">
                            Lowest Rating
                        </button>
                    </div>
                </div>

                <!-- Individual Reviews -->
                <div class="space-y-6">
                    @foreach($reviews as $review)
                        <div class="border-b border-gray-200 dark:border-gray-700 pb-6 last:border-b-0">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex items-center">
                                    <div class="w-10 h-10 bg-indigo-600 rounded-full flex items-center justify-center text-white font-bold text-lg">
                                        {{ strtoupper(substr($review->user->name, 0, 1)) }}
                                    </div>
                                    <div class="ml-3">
                                        <h4 class="font-semibold text-gray-900 dark:text-gray-100">{{ $review->user->name }}</h4>
                                        <p class="text-sm text-gray-500 dark:text-gray-400">{{ $review->created_at->format('M d, Y') }}</p>
                                    </div>
                                </div>
                                <div class="flex items-center">
                                    @for($i = 1; $i <= 5; $i++)
                                        @if($i <= $review->rating)
                                            <svg class="w-5 h-5 text-yellow-400 fill-current" viewBox="0 0 20 20">
                                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                            </svg>
                                        @else
                                            <svg class="w-5 h-5 text-gray-300 dark:text-gray-600 fill-current" viewBox="0 0 20 20">
                                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                            </svg>
                                        @endif
                                    @endfor
                                </div>
                            </div>
                            <p class="text-gray-700 dark:text-gray-300">{{ $review->comment }}</p>

                            @if($review->images && count($review->images) > 0)
                                <div class="mt-4" x-data="{
                                    showReviewGallery: false,
                                    currentReviewImage: 0,
                                    reviewImages: {{ json_encode($review->images) }},
                                    openReviewGallery(index) {
                                        this.currentReviewImage = index;
                                        this.showReviewGallery = true;
                                        document.body.style.overflow = 'hidden';
                                    },
                                    closeReviewGallery() {
                                        this.showReviewGallery = false;
                                        document.body.style.overflow = 'auto';
                                    }
                                }">
                                    <div class="flex gap-2">
                                        @foreach($review->images as $index => $image)
                                            <div class="relative cursor-pointer group" @click="openReviewGallery({{ $index }})">
                                                <img src="{{ $image }}" alt="Review image" class="w-24 h-24 object-cover rounded-lg shadow-md group-hover:ring-2 group-hover:ring-blue-500 transition">
                                                <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-10 transition rounded-lg flex items-center justify-center">
                                                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0zM10 7v3m0 0v3m0-3h3m-3 0H7"></path>
                                                    </svg>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                    <!-- Review Image Gallery Modal -->
                                    <div x-show="showReviewGallery" x-cloak @keydown.escape.window="closeReviewGallery()" class="fixed inset-0 z-50 bg-black bg-opacity-95 flex items-center justify-center" x-transition>
                                        <button @click="closeReviewGallery()" class="absolute top-4 right-4 text-white hover:text-gray-300 z-50">
                                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                            </svg>
                                        </button>
                                        <div class="absolute top-4 left-1/2 transform -translate-x-1/2 text-white bg-black bg-opacity-50 px-4 py-2 rounded-lg">
                                            <span x-text="currentReviewImage + 1"></span> / <span x-text="reviewImages.length"></span>
                                        </div>
                                        @if(count($review->images) > 1)
                                        <button @click="currentReviewImage = (currentReviewImage - 1 + reviewImages.length) % reviewImages.length" class="absolute left-4 text-white hover:text-gray-300 bg-black bg-opacity-50 hover:bg-opacity-75 rounded-full p-2">
                                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                                            </svg>
                                        </button>
                                        @endif
                                        <div class="max-w-4xl max-h-[90vh] mx-auto px-16">
                                            <img :src="reviewImages[currentReviewImage]" alt="Review image" class="max-w-full max-h-[90vh] object-contain mx-auto rounded-lg">
                                        </div>
                                        @if(count($review->images) > 1)
                                        <button @click="currentReviewImage = (currentReviewImage + 1) % reviewImages.length" class="absolute right-4 text-white hover:text-gray-300 bg-black bg-opacity-50 hover:bg-opacity-75 rounded-full p-2">
                                            <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                            </svg>
                                        </button>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>

                <!-- Pagination Links -->
                @if($reviews->hasPages())
                    <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                        {{ $reviews->links() }}
                    </div>
                @endif
            </div>
        </div>
    @endif
</div>
