<div class="py-4 sm:py-8 lg:py-12 bg-gray-50 dark:bg-gray-900 min-h-screen">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Mobile-Optimized Header -->
        <div class="mb-4 sm:mb-6">
            <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center gap-3">
                <div class="flex-1">
                    <div class="flex items-center gap-2 mb-1 flex-wrap">
                        <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white">My Listings</h1>
                        @if(auth()->user()->vacation_mode)
                            <span class="inline-flex items-center px-2 sm:px-3 py-1 sm:py-1.5 rounded-full text-xs sm:text-sm font-bold bg-orange-100 dark:bg-orange-900 text-orange-800 dark:text-orange-200 border-2 border-orange-300 dark:border-orange-700">
                                <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1 sm:mr-1.5" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                </svg>
                                Vacation
                            </span>
                        @endif
                    </div>
                    <p class="text-sm sm:text-base text-gray-600 dark:text-gray-400 mt-1">
                        @if(auth()->user()->vacation_mode)
                            Your listings are visible but cannot be booked
                        @else
                            Manage your rental properties
                        @endif
                    </p>
                </div>

                <!-- Mobile-Friendly Buttons -->
                <div class="flex flex-col sm:flex-row items-stretch sm:items-center gap-2 sm:gap-3">
                    <a href="{{ route('profile.edit') }}" class="inline-flex items-center justify-center px-4 py-3 sm:py-2 bg-white dark:bg-gray-800 border-2 border-gray-300 dark:border-gray-600 rounded-lg text-sm sm:text-base text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition font-semibold touch-manipulation">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        <span class="hidden sm:inline">Vacation Mode</span>
                        <span class="sm:hidden">Vacation</span>
                    </a>
                    <button wire:click="create" class="inline-flex items-center justify-center px-5 py-3 sm:px-6 bg-gradient-to-r from-green-600 to-green-700 text-white text-base sm:text-base font-semibold rounded-lg hover:from-green-700 hover:to-green-800 transition shadow-md touch-manipulation">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                        </svg>
                        Add New Listing
                    </button>
                </div>
            </div>
        </div>

        @if (session()->has('message'))
            <div class="mb-4 sm:mb-6 bg-green-50 dark:bg-green-900/20 border-l-4 border-green-500 text-green-800 dark:text-green-200 px-4 sm:px-6 py-3 sm:py-4 rounded-r-lg shadow-sm">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-2 sm:mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <span class="text-sm sm:text-base">{{ session('message') }}</span>
                </div>
            </div>
        @endif

        @if($showForm)
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-md sm:rounded-xl mb-4 sm:mb-6" x-data x-init="$el.scrollIntoView({ behavior: 'smooth', block: 'start' })">
            <!-- Mobile-Optimized Form Header -->
            <div class="p-4 sm:p-6 border-b border-gray-200 dark:border-gray-700">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-900 dark:text-white">{{ $editMode ? 'Edit Listing' : 'Add New Listing' }}</h2>
                    <button type="button" wire:click="$set('showForm', false)" class="sm:hidden p-2 text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 touch-manipulation">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <div class="p-4 sm:p-6">
                <form wire:submit="save" class="space-y-5 sm:space-y-6">
                <!-- Type & Location - Mobile Optimized -->
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-5">
                    <div>
                        <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            <svg class="w-4 h-4 inline-block mr-1 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                            </svg>
                            Type <span class="text-red-500">*</span>
                        </label>
                        <select wire:model="rental_type_id" required class="w-full px-3 py-3 sm:py-2.5 text-base rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500 touch-manipulation">
                            <option value="">Select Type</option>
                            @foreach($rentalTypes as $type)
                                <option value="{{ $type->id }}">{{ $type->name }}</option>
                            @endforeach
                        </select>
                        @error('rental_type_id') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            <svg class="w-4 h-4 inline-block mr-1 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            Location <span class="text-red-500">*</span>
                        </label>
                        <select wire:model="location_id" required class="w-full px-3 py-3 sm:py-2.5 text-base rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500 touch-manipulation">
                            <option value="">Select Location</option>
                            @foreach($locations as $location)
                                <option value="{{ $location->id }}">{{ $location->name }}</option>
                            @endforeach
                        </select>
                        @error('location_id') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Title Field - Mobile Optimized -->
                <div>
                    <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                        Listing Title <span class="text-red-500">*</span>
                    </label>
                    <input type="text" wire:model="title" required placeholder="e.g., Luxury 3-Bedroom Villa in Penang" class="w-full px-3 py-3 sm:py-2.5 text-base rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500 touch-manipulation">
                    @error('title') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                </div>

                <!-- Description - Mobile Optimized -->
                <div>
                    <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                        Description <span class="text-red-500">*</span>
                    </label>
                    <p class="text-xs sm:text-sm text-gray-600 dark:text-gray-400 mb-2 flex items-start">
                        <svg class="w-4 h-4 mr-1 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                        </svg>
                        Use line breaks for better readability. Describe features, amenities, and what makes your listing special.
                    </p>
                    <textarea
                        wire:model="description"
                        rows="6"
                        required
                        class="w-full px-3 py-3 sm:py-2.5 text-base rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500 touch-manipulation"
                        placeholder="Example:
Beautiful property perfect for families and groups.

Features:
- Spacious living area
- Modern amenities
- Great location near attractions

Book now and enjoy your stay!"></textarea>

                    @error('description') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                </div>

                <!-- Amenities Section - Mobile Optimized -->
                <div class="bg-gray-50 dark:bg-gray-800/50 rounded-lg p-4 sm:p-5 border border-gray-200 dark:border-gray-700">
                    <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                        <svg class="w-5 h-5 inline-block mr-1 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Amenities & Features
                    </label>
                    <p class="text-xs sm:text-sm text-gray-600 dark:text-gray-400 mb-3">Select all amenities that apply to your listing</p>

                    @php
                        $rentalType = $rentalTypes->find($rental_type_id);
                        $amenitiesList = $rentalType ? ($availableAmenities[$rentalType->name] ?? []) : [];
                    @endphp

                    @if($rental_type_id && count($amenitiesList) > 0)
                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3">
                            @foreach($amenitiesList as $amenity)
                                <label class="flex items-start p-3 bg-white dark:bg-gray-700 rounded-lg border border-gray-200 dark:border-gray-600 cursor-pointer hover:border-green-500 dark:hover:border-green-500 transition touch-manipulation">
                                    <input
                                        type="checkbox"
                                        wire:model="amenities"
                                        value="{{ $amenity }}"
                                        class="rounded border-gray-300 dark:border-gray-600 text-green-600 focus:ring-green-500 mt-0.5 w-5 h-5"
                                    >
                                    <span class="ml-3 text-sm sm:text-base text-gray-700 dark:text-gray-300 font-medium">
                                        {{ $amenity }}
                                    </span>
                                </label>
                            @endforeach
                        </div>
                        <p class="text-xs sm:text-sm text-gray-500 dark:text-gray-400 mt-3 font-medium">
                            Selected: <span class="text-green-600 dark:text-green-400 font-bold">{{ count($amenities) }}</span> amenities
                        </p>
                    @else
                        <div class="p-4 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-700 rounded-lg">
                            <p class="text-sm text-yellow-800 dark:text-yellow-200 flex items-center">
                                <svg class="w-5 h-5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                                </svg>
                                Please select a rental type first to see available amenities
                            </p>
                        </div>
                    @endif
                </div>

                <!-- Pricing & Capacity Grid - Mobile Optimized -->
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-5">
                    <div>
                        <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            <svg class="w-4 h-4 inline-block mr-1 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Price Per Day (RM) <span class="text-red-500">*</span>
                        </label>
                        <input type="number" step="0.01" wire:model="price_per_day" required placeholder="150.00" class="w-full px-3 py-3 sm:py-2.5 text-base rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500 touch-manipulation">
                        @error('price_per_day') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            <svg class="w-4 h-4 inline-block mr-1 text-orange-600 dark:text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Buffer Hours <span class="text-red-500">*</span>
                        </label>
                        <input type="number" wire:model="buffer_hours" required min="0" max="72" placeholder="2" class="w-full px-3 py-3 sm:py-2.5 text-base rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500 touch-manipulation">
                        @error('buffer_hours') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                        @php
                            $rentalType = $rentalTypes->find($rental_type_id);
                            $recommendations = [
                                'Car' => '2 hours',
                                'Houseboat' => '4-6 hours',
                                'Guesthouse' => '3-4 hours',
                                'Boat' => '2-3 hours',
                                'Fishing Trip' => '1-2 hours',
                            ];
                            $recommendation = $rentalType && isset($recommendations[$rentalType->name]) ? $recommendations[$rentalType->name] : null;
                        @endphp
                        @if($recommendation)
                            <p class="text-xs text-blue-600 dark:text-blue-400 mt-1 font-medium">Recommended: {{ $recommendation }}</p>
                        @endif
                    </div>

                    <div>
                        <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            <svg class="w-4 h-4 inline-block mr-1 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                            Capacity (Guests) <span class="text-red-500">*</span>
                        </label>
                        <input type="number" wire:model="capacity" required placeholder="4" class="w-full px-3 py-3 sm:py-2.5 text-base rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500 touch-manipulation">
                        @error('capacity') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm sm:text-base font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            <svg class="w-4 h-4 inline-block mr-1 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                            </svg>
                            Available Units <span class="text-red-500">*</span>
                        </label>
                        <input type="number" wire:model="available_units" required min="1" placeholder="1" class="w-full px-3 py-3 sm:py-2.5 text-base rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-2 focus:ring-blue-500 touch-manipulation">
                        @error('available_units') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Total units available for rent</p>
                    </div>
                </div>

                <!-- Pickup Locations (For Car/Mobile Rentals) -->
                @php
                    $rentalType = $rentalTypes->find($rental_type_id);
                    $showPickupLocations = $rentalType && in_array($rentalType->name, ['Car', 'Boat']);
                @endphp

                @if($showPickupLocations)
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6 mt-2">
                    <div class="flex justify-between items-center mb-3">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                            <svg class="w-5 h-5 inline-block mr-1 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            Pickup/Dropoff Locations
                        </label>
                        @if(auth()->user()->can_create_custom_locations)
                            <a href="{{ route('host.pickup-locations') }}" target="_blank" class="inline-flex items-center px-3 py-1.5 bg-indigo-600 hover:bg-indigo-700 text-white text-xs font-semibold rounded-md transition">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                </svg>
                                Manage Custom Locations
                            </a>
                        @else
                            <div class="px-3 py-1.5 bg-gray-100 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md text-xs text-gray-600 dark:text-gray-400">
                                <svg class="w-4 h-4 inline-block mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path>
                                </svg>
                                Custom Locations Disabled
                            </div>
                        @endif
                    </div>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-3">Select locations where guests can pickup and dropoff this {{ strtolower($rentalType->name) }}</p>

                    @if(count($adminPickupLocations) > 0 || count($customPickupLocations) > 0)
                        <!-- Admin (Default) Pickup Locations -->
                        @if(count($adminPickupLocations) > 0)
                        <div class="mb-4">
                            <h4 class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2 flex items-center">
                                <svg class="w-4 h-4 mr-1.5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Admin (Default) Pickup/Dropoff Locations
                            </h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800">
                                @foreach($adminPickupLocations as $location)
                                    <label class="flex items-start cursor-pointer group hover:bg-white dark:hover:bg-blue-800 p-2 rounded transition">
                                        <input
                                            type="checkbox"
                                            wire:model="selectedPickupLocations"
                                            value="{{ $location->id }}"
                                            class="rounded border-gray-300 dark:border-gray-600 text-indigo-600 focus:ring-indigo-500 mt-0.5"
                                        >
                                        <div class="ml-2 flex-1">
                                            <span class="text-sm font-medium text-gray-900 dark:text-white block">
                                                {{ $location->name }}
                                            </span>
                                            <span class="text-xs text-gray-500 dark:text-gray-400 flex items-center mt-0.5">
                                                @if($location->type === 'airport')
                                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        <path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z"></path>
                                                    </svg>
                                                @elseif($location->type === 'hotel')
                                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"></path>
                                                    </svg>
                                                @else
                                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"></path>
                                                    </svg>
                                                @endif
                                                {{ ucfirst(str_replace('_', ' ', $location->type)) }}
                                            </span>
                                        </div>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                        @endif

                        <!-- Custom Pickup Locations -->
                        @if(auth()->user()->can_create_custom_locations && count($customPickupLocations) > 0)
                        <div>
                            <h4 class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2 flex items-center">
                                <svg class="w-4 h-4 mr-1.5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"></path>
                                </svg>
                                My Custom Pickup/Dropoff Locations ({{ $customLocationsCount }}/3)
                            </h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3 p-4 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-800">
                                @foreach($customPickupLocations as $location)
                                    <label class="flex items-start cursor-pointer group hover:bg-white dark:hover:bg-green-800 p-2 rounded transition">
                                        <input
                                            type="checkbox"
                                            wire:model="selectedPickupLocations"
                                            value="{{ $location->id }}"
                                            class="rounded border-gray-300 dark:border-gray-600 text-green-600 focus:ring-green-500 mt-0.5"
                                        >
                                        <div class="ml-2 flex-1">
                                            <span class="text-sm font-medium text-gray-900 dark:text-white block">
                                                {{ $location->name }}
                                            </span>
                                            <span class="text-xs text-gray-500 dark:text-gray-400 flex items-center mt-0.5">
                                                @if($location->type === 'airport')
                                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        <path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z"></path>
                                                    </svg>
                                                @elseif($location->type === 'hotel')
                                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"></path>
                                                    </svg>
                                                @else
                                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"></path>
                                                    </svg>
                                                @endif
                                                {{ ucfirst(str_replace('_', ' ', $location->type)) }}
                                            </span>
                                        </div>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                        @endif

                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-3">
                            Selected: <span class="font-semibold text-indigo-600 dark:text-indigo-400">{{ count($selectedPickupLocations) }}</span> locations
                        </p>
                    @else
                        <div class="p-4 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-700 rounded-lg">
                            <p class="text-sm text-yellow-800 dark:text-yellow-200 flex items-center">
                                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                                </svg>
                                No pickup locations available. Contact admin or create your own custom locations.
                            </p>
                        </div>
                    @endif
                </div>
                @endif

                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Images (Max 15, formats: JPG, JPEG, PNG, WEBP, AVIF)
                    </label>

                    <!-- Existing Images -->
                    @if($existingImages && count($existingImages) > 0)
                        <div class="mb-4">
                            <p class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">Existing Images ({{ count($existingImages) }})</p>
                            <div class="grid grid-cols-3 md:grid-cols-5 gap-3">
                                @foreach($existingImages as $index => $image)
                                    <div class="relative group">
                                        <img src="{{ $image }}" class="w-full h-24 object-cover rounded-lg border-2 border-gray-200 shadow-sm">
                                        <button type="button" wire:click="removeExistingImage({{ $index }})"
                                            class="absolute top-1 right-1 bg-red-500 text-white rounded-full w-7 h-7 flex items-center justify-center hover:bg-red-600 shadow-md transition opacity-90 group-hover:opacity-100">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                            </svg>
                                        </button>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <!-- New Images Upload -->
                    <input type="file" wire:model="images" multiple accept=".jpg,.jpeg,.png,.webp,.avif"
                        class="w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <p class="text-xs text-gray-600 dark:text-gray-400 mt-2 flex items-center">
                        <svg class="w-4 h-4 mr-1 text-gray-500 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Current: {{ count($existingImages) + count($images) }} / 15 images
                    </p>
                    @error('images.*') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror

                    <!-- Image Preview -->
                    @if($images)
                        <div class="mt-4">
                            <p class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">New Images to Upload ({{ count($images) }})</p>
                            <div class="grid grid-cols-3 md:grid-cols-5 gap-3">
                                @foreach($images as $image)
                                    <img src="{{ $image->temporaryUrl() }}" class="w-full h-24 object-cover rounded-lg border-2 border-green-200 shadow-sm">
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>

                <div class="space-y-4">
                    <label class="flex items-center">
                        <input type="checkbox" wire:model="is_available" class="rounded border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-blue-600 focus:ring-blue-500">
                        <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">Available</span>
                    </label>

                    <!-- Featured Listing Info -->
                    <div class="bg-gradient-to-r from-yellow-50 to-orange-50 dark:from-yellow-900/20 dark:to-orange-900/20 border-2 border-yellow-300 dark:border-yellow-700 rounded-lg p-4">
                        <div class="flex items-start gap-3">
                            <svg class="w-6 h-6 text-yellow-600 dark:text-yellow-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                            </svg>
                            <div class="flex-1">
                                <div class="flex items-center gap-2 mb-1">
                                    <h4 class="text-sm font-bold text-gray-900 dark:text-white">Featured Listing</h4>
                                    @if($is_featured)
                                        <span class="px-2 py-0.5 bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200 text-xs font-semibold rounded-full">Active</span>
                                    @else
                                        <span class="px-2 py-0.5 bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-300 text-xs font-semibold rounded-full">Not Featured</span>
                                    @endif
                                </div>
                                <p class="text-xs text-gray-700 dark:text-gray-300 mb-2">
                                    <strong>Subject to admin approval with fee.</strong> Featured listings get premium placement and more visibility.
                                </p>
                                <div class="flex items-center gap-3 text-xs">
                                    <a href="{{ route('advertise') }}" target="_blank" class="inline-flex items-center px-3 py-1.5 bg-yellow-600 hover:bg-yellow-700 dark:bg-yellow-500 dark:hover:bg-yellow-600 text-white font-semibold rounded-md transition">
                                        <svg class="w-3.5 h-3.5 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        Learn More About Featured Listings
                                    </a>
                                    @if(!$is_featured)
                                        <span class="text-gray-600 dark:text-gray-400">Contact admin to feature this listing</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Discount Tiers Section -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                    <div class="flex justify-between items-center mb-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                                <svg class="w-5 h-5 inline-block mr-1 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                Discount Tiers (Optional)
                            </label>
                            <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Offer discounts for longer bookings</p>
                        </div>
                        <button type="button" wire:click="addDiscountTier" class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-semibold rounded-md transition">
                            + Add Tier
                        </button>
                    </div>

                    @if(count($discountTiers) > 0)
                        <div class="space-y-3">
                            @foreach($discountTiers as $index => $tier)
                                <div class="bg-gray-50 dark:bg-gray-700/50 p-4 rounded-lg border border-gray-200 dark:border-gray-600">
                                    <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
                                        <div>
                                            <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Min Days</label>
                                            <input type="number" wire:model="discountTiers.{{ $index }}.min_days" class="w-full px-3 py-2 text-sm rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white" placeholder="3" min="1">
                                        </div>
                                        <div>
                                            <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Max Days (Optional)</label>
                                            <input type="number" wire:model="discountTiers.{{ $index }}.max_days" class="w-full px-3 py-2 text-sm rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white" placeholder="7" min="1">
                                        </div>
                                        <div>
                                            <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-1">Discount %</label>
                                            <input type="number" step="0.01" wire:model="discountTiers.{{ $index }}.discount_percentage" class="w-full px-3 py-2 text-sm rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white" placeholder="10" min="0" max="100">
                                        </div>
                                        <div class="flex items-end">
                                            <button type="button" wire:click="removeDiscountTier({{ $index }})" class="w-full px-3 py-2 bg-red-500 hover:bg-red-600 text-white text-sm font-semibold rounded-md transition">
                                                Remove
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="p-4 bg-gray-50 dark:bg-gray-700/50 border border-gray-200 dark:border-gray-600 rounded-lg text-center">
                            <p class="text-sm text-gray-600 dark:text-gray-400">No discount tiers added yet. Click "Add Tier" to create one.</p>
                        </div>
                    @endif
                </div>

                <!-- Add-ons Section -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                        <svg class="w-5 h-5 inline-block mr-1 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Optional Add-ons
                    </label>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mb-3">Select additional services or extras guests can book</p>

                    @if(count($availableAddOns) > 0)
                        <div class="space-y-3">
                            @foreach($availableAddOns as $addOn)
                                <div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600 p-4">
                                    <div class="flex items-start gap-3">
                                        <input
                                            type="checkbox"
                                            wire:model.live="selectedAddOns"
                                            value="{{ $addOn->id }}"
                                            class="rounded border-gray-300 dark:border-gray-600 text-blue-600 focus:ring-blue-500 mt-1"
                                        >
                                        <div class="flex-1">
                                            <div class="flex items-start justify-between">
                                                <div>
                                                    <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $addOn->name }}</div>
                                                    <div class="text-xs text-gray-600 dark:text-gray-400 mt-1">{{ $addOn->description }}</div>
                                                    <div class="flex items-center gap-2 mt-2">
                                                        <span class="text-sm font-bold text-green-600 dark:text-green-400">Default: RM {{ number_format($addOn->price, 2) }}</span>
                                                        <span class="text-xs text-gray-500 dark:text-gray-400">{{ $addOn->getPricingTypeLabel() }}</span>
                                                    </div>
                                                </div>
                                            </div>

                                            @if(in_array($addOn->id, $selectedAddOns))
                                                <div class="mt-3 pt-3 border-t border-gray-200 dark:border-gray-600">
                                                    <label class="block text-xs font-medium text-gray-700 dark:text-gray-300 mb-2">
                                                        Custom Price (Optional - leave blank to use default)
                                                    </label>
                                                    <div class="flex items-center gap-2">
                                                        <span class="text-sm text-gray-600 dark:text-gray-400">RM</span>
                                                        <input
                                                            type="number"
                                                            step="0.01"
                                                            wire:model="addOnCustomPrices.{{ $addOn->id }}"
                                                            placeholder="{{ number_format($addOn->price, 2) }}"
                                                            class="w-32 px-3 py-1.5 text-sm rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                                        >
                                                        <span class="text-xs text-gray-500 dark:text-gray-400">per {{ strtolower($addOn->getPricingTypeLabel()) }}</span>
                                                    </div>
                                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                                        Set your own price for this add-on
                                                    </p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-3">
                            Selected: <span class="font-semibold text-blue-600 dark:text-blue-400">{{ count($selectedAddOns) }}</span> add-ons
                        </p>
                    @else
                        <div class="p-4 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-700 rounded-lg">
                            <p class="text-sm text-yellow-800 dark:text-yellow-200 flex items-center">
                                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                                </svg>
                                No add-ons available. Contact administrator to create add-ons.
                            </p>
                        </div>
                    @endif
                </div>

                @if (session()->has('error'))
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                    <div class="flex gap-3">
                        <button type="submit" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white font-semibold rounded-lg hover:from-blue-700 hover:to-blue-800 transition shadow-md">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            {{ $editMode ? 'Update' : 'Create' }} Listing
                        </button>
                        <button type="button" wire:click="$set('showForm', false)" class="inline-flex items-center px-6 py-3 bg-gray-500 text-white font-semibold rounded-lg hover:bg-gray-600 transition shadow-md">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                            Cancel
                        </button>
                    </div>
                </form>
            </div>
        </div>
        @endif

        <!-- Mobile-Optimized Listings Grid -->
        <div class="grid grid-cols-1 gap-4 sm:gap-6">
            @forelse($listings as $listing)
                <div class="bg-white dark:bg-gray-800 rounded-lg sm:rounded-xl shadow-md overflow-hidden hover:shadow-xl transition-shadow">
                    <div class="flex flex-col sm:flex-row">
                        <!-- Image Section -->
                        <div class="w-full sm:w-48 md:w-64 sm:flex-shrink-0">
                            @if($listing->images && count($listing->images) > 0)
                                <img src="{{ $listing->images[0] }}" alt="{{ $listing->title }}" class="h-48 sm:h-full w-full object-cover">
                            @else
                                <div class="h-48 sm:h-full w-full bg-gradient-to-br from-blue-500 to-indigo-600 flex items-center justify-center">
                                    <svg class="w-12 h-12 sm:w-16 sm:h-16 text-white opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                            @endif
                        </div>

                        <!-- Content Section -->
                        <div class="p-4 sm:p-5 md:p-6 flex-1">
                            <!-- Badges -->
                            <div class="flex items-center flex-wrap gap-1.5 sm:gap-2 mb-3">
                                <span class="px-2 sm:px-3 py-1 inline-flex items-center text-xs font-bold rounded-full bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200">
                                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                    </svg>
                                    {{ $listing->rentalType->name }}
                                </span>
                                <span class="px-2 sm:px-3 py-1 inline-flex items-center text-xs font-bold rounded-full bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200">
                                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    {{ $listing->location->name }}
                                </span>
                                @if($listing->is_featured)
                                    <span class="px-2 sm:px-3 py-1 inline-flex items-center text-xs font-bold rounded-full bg-yellow-100 dark:bg-yellow-900 text-yellow-800 dark:text-yellow-200">
                                        <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                        </svg>
                                        Featured
                                    </span>
                                @endif
                                @if(!$listing->is_available)
                                    <span class="px-2 sm:px-3 py-1 inline-flex items-center text-xs font-bold rounded-full bg-red-100 dark:bg-red-900 text-red-800 dark:text-red-200">
                                        <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M13.477 14.89A6 6 0 015.11 6.524l8.367 8.368zm1.414-1.414L6.524 5.11a6 6 0 018.367 8.367zM18 10a8 8 0 11-16 0 8 8 0 0116 0z" clip-rule="evenodd"></path>
                                        </svg>
                                        Unavailable
                                    </span>
                                @else
                                    <span class="px-2 sm:px-3 py-1 inline-flex items-center text-xs font-bold rounded-full bg-emerald-100 dark:bg-emerald-900 text-emerald-800 dark:text-emerald-200">
                                        <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                        </svg>
                                        Available
                                    </span>
                                @endif
                            </div>

                            <!-- Title & Description -->
                            <h3 class="text-lg sm:text-xl font-bold text-gray-900 dark:text-white mb-2">{{ $listing->title }}</h3>
                            <p class="text-gray-600 dark:text-gray-300 text-sm mb-3 line-clamp-2">{{ Str::limit($listing->description, 100) }}</p>

                            <!-- Price & Capacity -->
                            <div class="flex items-center gap-3 sm:gap-4 text-sm text-gray-700 dark:text-gray-300 mb-4">
                                <span class="font-bold text-base sm:text-lg text-blue-600 dark:text-blue-400">
                                    RM {{ number_format($listing->price_per_day, 2)}}
                                    <span class="text-xs sm:text-sm text-gray-600 dark:text-gray-400 font-normal">/day</span>
                                </span>
                                <span class="flex items-center text-xs sm:text-sm text-gray-600 dark:text-gray-400">
                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                    </svg>
                                    {{ $listing->capacity }} guests
                                </span>
                            </div>

                            <!-- Action Buttons - Mobile Optimized -->
                            <div class="flex flex-col sm:flex-row gap-2">
                                <button wire:click="edit({{ $listing->id }})" class="inline-flex items-center justify-center px-4 py-2.5 sm:py-2 border-2 border-indigo-300 dark:border-indigo-600 rounded-lg text-sm font-semibold text-indigo-700 dark:text-indigo-300 hover:bg-indigo-50 dark:hover:bg-indigo-900/20 transition touch-manipulation">
                                    <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                    </svg>
                                    Edit
                                </button>
                                <button wire:click="delete({{ $listing->id }})" wire:confirm="Are you sure you want to delete this listing?" class="inline-flex items-center justify-center px-4 py-2.5 sm:py-2 border-2 border-red-300 dark:border-red-600 rounded-lg text-sm font-semibold text-red-700 dark:text-red-300 hover:bg-red-50 dark:hover:bg-red-900/20 transition touch-manipulation">
                                    <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                    </svg>
                                    Delete
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-16 text-center border-4 border-dashed border-gray-300 dark:border-gray-600">
                    <div class="max-w-lg mx-auto">
                        <!-- Simple Large Icon -->
                        <div class="inline-flex items-center justify-center w-32 h-32 bg-gradient-to-br from-green-500 to-emerald-600 rounded-3xl mb-8 shadow-2xl">
                            <svg class="w-16 h-16 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                            </svg>
                        </div>

                        <!-- Clear Text -->
                        <h3 class="text-4xl font-black text-gray-900 dark:text-white mb-4">No Listings Yet</h3>
                        <p class="text-lg text-gray-600 dark:text-gray-300 mb-8 font-medium">Start earning by listing your rental property. It only takes a few minutes!</p>

                        <!-- Big CTA Button -->
                        <button wire:click="create" class="inline-flex items-center px-10 py-5 bg-gradient-to-r from-green-600 to-emerald-600 text-white text-xl font-bold rounded-xl hover:from-green-700 hover:to-emerald-700 transition-all duration-200 shadow-2xl hover:shadow-green-500/30 hover:scale-105">
                            <svg class="w-7 h-7 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2.5">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"></path>
                            </svg>
                            Create Your First Listing
                        </button>

                        <!-- Simple Benefits -->
                        <div class="mt-12 flex justify-center gap-8">
                            <div class="text-center">
                                <div class="inline-flex items-center justify-center w-12 h-12 bg-blue-500 rounded-lg mb-2">
                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="text-sm font-bold text-gray-900 dark:text-white">Quick Setup</div>
                                <div class="text-xs text-gray-600 dark:text-gray-400">5 minutes</div>
                            </div>
                            <div class="text-center">
                                <div class="inline-flex items-center justify-center w-12 h-12 bg-purple-500 rounded-lg mb-2">
                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="text-sm font-bold text-gray-900 dark:text-white">Start Earning</div>
                                <div class="text-xs text-gray-600 dark:text-gray-400">Get bookings</div>
                            </div>
                            <div class="text-center">
                                <div class="inline-flex items-center justify-center w-12 h-12 bg-orange-500 rounded-lg mb-2">
                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"></path>
                                    </svg>
                                </div>
                                <div class="text-sm font-bold text-gray-900 dark:text-white">Full Control</div>
                                <div class="text-xs text-gray-600 dark:text-gray-400">Manage easily</div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforelse
        </div>
    </div>
</div>
