<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">My Bookings</h1>
        <p class="text-gray-600 dark:text-gray-400 mt-2">Manage bookings for your listings</p>
    </div>

    @if (session()->has('message'))
        <div class="mb-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-200 px-4 py-3 rounded relative">
            {{ session('message') }}
        </div>
    @endif

    <!-- Analytics Cards -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg shadow p-4 text-white">
            <div class="flex items-center gap-3">
                <div class="bg-white/20 rounded-lg p-2">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                </div>
                <div>
                    <p class="text-xs text-blue-100">Total Bookings</p>
                    <p class="text-2xl font-bold">{{ $totalBookings }}</p>
                </div>
            </div>
        </div>

        <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-lg shadow p-4 text-white">
            <div class="flex items-center gap-3">
                <div class="bg-white/20 rounded-lg p-2">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div>
                    <p class="text-xs text-green-100">Confirmed</p>
                    <p class="text-2xl font-bold">{{ $confirmedBookings }}</p>
                </div>
            </div>
        </div>

        <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg shadow p-4 text-white">
            <div class="flex items-center gap-3">
                <div class="bg-white/20 rounded-lg p-2">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
                <div>
                    <p class="text-xs text-purple-100">Completed</p>
                    <p class="text-2xl font-bold">{{ $completedBookings }}</p>
                </div>
            </div>
        </div>

        <div class="bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-lg shadow p-4 text-white">
            <div class="flex items-center gap-3">
                <div class="bg-white/20 rounded-lg p-2">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div>
                    <p class="text-xs text-indigo-100">Total Revenue</p>
                    <p class="text-2xl font-bold">RM {{ number_format($totalRevenue, 2) }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <!-- Status Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Status Filter</label>
                <select wire:model.live="filter" wire:change="updateFilter" class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                    <option value="all">All Statuses</option>
                    <option value="pending">Pending</option>
                    <option value="confirmed">Confirmed</option>
                    <option value="completed">Completed</option>
                    <option value="cancelled">Cancelled</option>
                </select>
            </div>

            <!-- Date Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Date Range</label>
                <select wire:model.live="dateFilter" wire:change="updateDateFilter" class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                    <option value="all">All Time</option>
                    <option value="today">Today</option>
                    <option value="week">This Week</option>
                    <option value="month">This Month</option>
                    <option value="custom">Custom Range</option>
                </select>
            </div>

            <!-- Search Filter -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Search</label>
                <input type="text" wire:model.live.debounce.300ms="search" placeholder="Booking ID, Invoice, Name, Email..." class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
            </div>

            @if($dateFilter === 'custom')
                <!-- Custom Date Range -->
                <div class="md:col-span-1">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Custom Range</label>
                    <div class="flex gap-2">
                        <input type="date" wire:model="startDate" class="flex-1 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white text-sm">
                        <input type="date" wire:model="endDate" class="flex-1 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white text-sm">
                        <button wire:click="applyCustomDate" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm">Apply</button>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Export Buttons -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-4 mb-6">
        <div class="flex items-center gap-3">
            <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Export Data:</span>
            <button wire:click="exportCsv" class="inline-flex items-center gap-2 px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-medium rounded-md transition duration-150">
                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Export CSV
            </button>
            <span class="text-xs text-gray-500 dark:text-gray-400">Download your bookings as CSV file</span>
        </div>
    </div>

    <!-- Bookings List -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
        @forelse($bookings as $booking)
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-4">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-start">
                <div class="md:col-span-2">
                    <div class="flex items-start justify-between mb-2">
                        <div>
                            <div class="text-sm font-bold text-gray-900 dark:text-white">#{{ $booking->id }}</div>
                            @if($booking->invoice_number)
                                <div class="text-xs text-gray-500 dark:text-gray-400">{{ $booking->invoice_number }}</div>
                            @endif
                        </div>
                        @if($booking->status === 'pending')
                            <span class="px-2 py-1 text-xs font-semibold rounded bg-yellow-100 dark:bg-yellow-900 text-yellow-800 dark:text-yellow-200">
                                Pending
                            </span>
                        @elseif($booking->status === 'confirmed')
                            <span class="px-2 py-1 text-xs font-semibold rounded bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200">
                                Confirmed
                            </span>
                        @elseif($booking->status === 'completed')
                            <span class="px-2 py-1 text-xs font-semibold rounded bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200">
                                Completed
                            </span>
                        @else
                            <span class="px-2 py-1 text-xs font-semibold rounded bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-300">
                                Cancelled
                            </span>
                        @endif
                    </div>

                    <div class="text-sm font-medium text-gray-900 dark:text-white mb-1">{{ $booking->user->name }}</div>
                    <div class="text-xs text-gray-500 dark:text-gray-400 mb-2">{{ $booking->user->email }}</div>

                    <div class="text-sm text-gray-900 dark:text-white mb-2">{{ Str::limit($booking->listing->title, 30) }}</div>

                    <div class="flex items-center gap-4 text-xs text-gray-500 dark:text-gray-400">
                        <div>
                            <span class="font-medium">Check-in:</span> {{ $booking->check_in->format('M d, Y') }}
                        </div>
                    </div>

                    <div class="text-lg font-bold text-gray-900 dark:text-white mt-2">RM {{ number_format($booking->total_price, 2) }}</div>
                </div>

                <div class="md:col-span-1 flex flex-col gap-2">
                    <a href="{{ route('booking.receipt', $booking->id) }}" target="_blank" class="text-xs px-3 py-1.5 bg-blue-600 hover:bg-blue-700 text-white rounded text-center block">
                        View Receipt
                    </a>

                    @if($booking->status === 'confirmed' || $booking->status === 'completed')
                        <a href="{{ route('booking.host-receipt', $booking->id) }}" target="_blank" class="text-xs px-3 py-1.5 bg-green-600 hover:bg-green-700 text-white rounded text-center block">
                            Host Receipt
                        </a>
                    @endif
                </div>
            </div>
        </div>
        @empty
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-8 text-center text-gray-500 dark:text-gray-400 lg:col-span-2">
            No bookings found for your listings.
        </div>
        @endforelse
    </div>
</div>
