<div class="min-h-screen bg-gray-50 dark:bg-gray-900">
    <!-- Hero Section -->
    <div class="bg-gradient-to-br from-blue-600 via-purple-600 to-indigo-700 dark:from-blue-800 dark:via-purple-800 dark:to-indigo-900 py-8 sm:py-12 md:py-16 relative overflow-hidden">
        <div class="absolute inset-0 bg-black opacity-10 dark:opacity-30"></div>
        <div class="max-w-7xl mx-auto px-3 sm:px-4 lg:px-6 relative z-10">
            <div class="text-center mb-4 sm:mb-6">
                <h1 class="sr-only">{{ \App\Helpers\SeoHelper::siteTagline() }}</h1>
                <p class="sr-only">{{ \App\Helpers\SeoHelper::seoTitle() }}</p>
            </div>

            <div class="bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl shadow-2xl p-4 sm:p-6 md:p-8">
                <form wire:submit="search" class="grid grid-cols-1 md:grid-cols-5 gap-3 sm:gap-4">
                    <div>
                        <label class="block text-xs sm:text-sm font-semibold text-gray-700 dark:text-gray-300 mb-1.5 sm:mb-2 flex items-center">
                            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4 mr-1 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            Where
                        </label>
                        <select wire:model="location_id" class="w-full text-sm sm:text-base py-2 sm:py-2.5 rounded-md sm:rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">All Locations</option>
                            @foreach($allLocations as $location)
                                <option value="{{ $location->id }}">{{ $location->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs sm:text-sm font-semibold text-gray-700 dark:text-gray-300 mb-1.5 sm:mb-2 flex items-center">
                            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4 mr-1 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                            </svg>
                            Type
                        </label>
                        <select wire:model="rental_type_id" class="w-full text-sm sm:text-base py-2 sm:py-2.5 rounded-md sm:rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">All Types</option>
                            @foreach($rentalTypes as $type)
                                <option value="{{ $type->id }}">{{ $type->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs sm:text-sm font-semibold text-gray-700 dark:text-gray-300 mb-1.5 sm:mb-2 flex items-center">
                            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4 mr-1 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                            Check-in
                        </label>
                        <input type="date" wire:model="check_in"
                               min="{{ date('Y-m-d', strtotime('tomorrow')) }}"
                               class="w-full text-sm sm:text-base py-2 sm:py-2.5 rounded-md sm:rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    </div>

                    <div>
                        <label class="block text-xs sm:text-sm font-semibold text-gray-700 dark:text-gray-300 mb-1.5 sm:mb-2 flex items-center">
                            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4 mr-1 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                            Check-out
                        </label>
                        <input type="date" wire:model="check_out"
                               min="{{ $check_in ? date('Y-m-d', strtotime($check_in . ' +1 day')) : date('Y-m-d', strtotime('tomorrow +1 day')) }}"
                               class="w-full text-sm sm:text-base py-2 sm:py-2.5 rounded-md sm:rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    </div>

                    <div>
                        <label class="block text-xs sm:text-sm font-semibold text-gray-700 dark:text-gray-300 mb-1.5 sm:mb-2 flex items-center">
                            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4 mr-1 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                            Guests
                        </label>
                        <input type="number" wire:model="guests" min="1" placeholder="1" class="w-full text-sm sm:text-base py-2 sm:py-2.5 rounded-md sm:rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    </div>

                    <div class="md:col-span-5">
                        <button type="submit" class="w-full inline-flex items-center justify-center px-6 sm:px-8 py-3 sm:py-4 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white text-base sm:text-lg font-bold rounded-md sm:rounded-lg transition shadow-lg hover:shadow-xl">
                            <svg class="w-5 h-5 sm:w-6 sm:h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                            Search Rentals
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- All Malaysian States Section -->
    <div class="max-w-7xl mx-auto px-3 sm:px-4 lg:px-6 py-8 sm:py-12 md:py-16">
        <div class="text-center mb-6 sm:mb-8 md:mb-10">
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-2">Explore All States</h2>
            <p class="text-gray-600 dark:text-gray-400 text-sm sm:text-base md:text-lg">Find rentals across all Malaysian states</p>
        </div>
        <div class="grid grid-cols-4 sm:grid-cols-6 lg:grid-cols-8 gap-2 sm:gap-3 mb-8 sm:mb-12 md:mb-16">
            @foreach($allLocations as $location)
                <a href="{{ route('listings.search', ['location' => $location->id]) }}" class="group relative rounded-md overflow-hidden shadow-sm hover:shadow-md transition-all duration-300 transform hover:-translate-y-0.5 bg-white dark:bg-gray-800 flex flex-col">
                    <div class="relative aspect-square overflow-hidden bg-gray-200 dark:bg-gray-700">
                        @if($location->image)
                            <img src="{{ $location->image }}" alt="{{ $location->name }}" class="w-full h-full object-cover">
                        @else
                            <div class="w-full h-full flex items-center justify-center bg-gradient-to-br from-blue-500 to-purple-600">
                                <span class="text-white font-bold text-2xl">{{ strtoupper(substr($location->name, 0, 1)) }}</span>
                            </div>
                        @endif
                    </div>
                    <div class="p-1.5 bg-white dark:bg-gray-800 flex-1 flex flex-col justify-center">
                        <h3 class="text-[10px] min-[640px]:text-xs font-bold text-gray-900 dark:text-white leading-tight group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors truncate">{{ $location->name }}</h3>
                        <p class="text-[9px] min-[640px]:text-[10px] text-gray-600 dark:text-gray-400">
                            <span class="font-semibold">{{ $location->listings_count ?? 0 }}</span> listings
                        </p>
                    </div>
                    @if($location->is_popular)
                        <div class="absolute top-0.5 right-0.5">
                            <span class="w-4 h-4 bg-yellow-400 rounded-full inline-flex items-center justify-center shadow">
                                <svg class="w-2.5 h-2.5 text-yellow-900" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                            </span>
                        </div>
                    @endif
                </a>
            @endforeach
        </div>

        <!-- Featured Rentals Section -->
        <div class="text-center mb-6 sm:mb-8 md:mb-10">
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-2">
                Featured Rentals
                @if($featuredListings->count() > 0)
                    <span class="text-xl sm:text-2xl md:text-3xl text-blue-600 dark:text-blue-400">({{ $featuredListings->count() }})</span>
                @endif
            </h2>
            <p class="text-gray-600 dark:text-gray-400 text-sm sm:text-base md:text-lg">Handpicked premium rentals just for you</p>
        </div>

        @if($featuredListings->count() > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6">
            @foreach($featuredListings as $listing)
                <a href="{{ route('listing.details', $listing->id) }}" class="group bg-white dark:bg-gray-800 rounded-lg sm:rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1 block">
                    <div class="relative overflow-hidden">
                        @if(!empty($listing->images[0]))
                            <img src="{{ $listing->images[0] }}" alt="{{ $listing->title }}" class="w-full h-44 sm:h-48 lg:h-40 object-cover group-hover:scale-110 transition-transform duration-300" onerror="this.onerror=null; this.src='data:image/svg+xml,%3Csvg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 400 300%22%3E%3Crect fill=%22%234F46E5%22 width=%22400%22 height=%22300%22/%3E%3Ctext x=%2250%25%22 y=%2250%25%22 dominant-baseline=%22middle%22 text-anchor=%22middle%22 fill=%22white%22 font-family=%22Arial%22 font-size=%2224%22 font-weight=%22bold%22%3E{{ substr($listing->title, 0, 20) }}%3C/text%3E%3C/svg%3E';">
                        @else
                            <div class="w-full h-44 sm:h-48 lg:h-40 bg-gradient-to-br from-blue-500 via-purple-500 to-indigo-600 flex items-center justify-center">
                                <div class="text-center text-white p-4">
                                    <svg class="w-12 h-12 sm:w-16 sm:h-16 mx-auto mb-2 opacity-80" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                                    </svg>
                                    <p class="text-xs sm:text-sm font-semibold">{{ \Illuminate\Support\Str::limit($listing->title, 30) }}</p>
                                </div>
                            </div>
                        @endif
                        <div class="absolute top-2 left-2">
                            <span class="px-2 py-0.5 bg-yellow-400 text-yellow-900 text-[9px] sm:text-[10px] font-bold rounded-full inline-flex items-center shadow-md">
                                <svg class="w-2 h-2 sm:w-2.5 sm:h-2.5 mr-0.5" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                                Featured
                            </span>
                        </div>
                    </div>
                    <div class="p-3 sm:p-4">
                        <div class="flex flex-wrap items-center gap-1 sm:gap-1.5 mb-2">
                            <span class="px-2 py-0.5 sm:px-2.5 sm:py-1 inline-flex items-center gap-1 text-[9px] sm:text-[10px] font-bold rounded-full bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200">
                                <svg class="w-2 h-2 sm:w-2.5 sm:h-2.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                </svg>
                                {{ $listing->rentalType->name }}
                            </span>
                            <span class="px-2 py-0.5 sm:px-2.5 sm:py-1 inline-flex items-center gap-1 text-[9px] sm:text-[10px] font-bold rounded-full bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200">
                                <svg class="w-2 h-2 sm:w-2.5 sm:h-2.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                {{ $listing->location->name }}
                            </span>
                        </div>
                        <h3 class="text-sm sm:text-base lg:text-sm font-bold text-gray-900 dark:text-white mb-1 sm:mb-1.5 group-hover:text-blue-600 dark:group-hover:text-blue-400 transition line-clamp-2">{{ $listing->title }}</h3>
                        <p class="text-gray-600 dark:text-gray-400 text-[11px] sm:text-xs mb-2 sm:mb-3 line-clamp-2">{{ $listing->description }}</p>

                        @if($listing->reviews_count > 0)
                            <div class="flex items-center text-[10px] sm:text-xs mb-2 sm:mb-3">
                                <div class="flex items-center">
                                    @for($i = 1; $i <= 5; $i++)
                                        @if($i <= round($listing->reviews_avg_rating))
                                            <svg class="w-2.5 h-2.5 sm:w-3 sm:h-3 text-yellow-400 fill-current" viewBox="0 0 20 20">
                                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                            </svg>
                                        @else
                                            <svg class="w-2.5 h-2.5 sm:w-3 sm:h-3 text-gray-300 dark:text-gray-600 fill-current" viewBox="0 0 20 20">
                                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                            </svg>
                                        @endif
                                    @endfor
                                    <span class="ml-1 sm:ml-1.5 font-medium text-gray-900 dark:text-white">{{ number_format($listing->reviews_avg_rating, 1) }}</span>
                                    <span class="ml-0.5 text-gray-500 dark:text-gray-400">({{ $listing->reviews_count }})</span>
                                </div>
                            </div>
                        @endif

                        <div class="flex items-center justify-between pt-2 sm:pt-3 border-t border-gray-100 dark:border-gray-700">
                            <div>
                                <span class="text-base sm:text-lg lg:text-base font-bold text-blue-600 dark:text-blue-400">RM {{ number_format($listing->price_per_day, 2) }}</span>
                                <span class="text-gray-600 dark:text-gray-400 text-[10px] sm:text-xs ml-0.5">/ day</span>
                            </div>
                            <div class="inline-flex items-center text-blue-600 dark:text-blue-400 text-[10px] sm:text-xs font-semibold">
                                Details
                                <svg class="w-3 h-3 sm:w-4 sm:h-4 ml-0.5 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                </a>
            @endforeach
        </div>

        @if($featuredListings->count() < 8)
        <div class="mt-6 sm:mt-8 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-700 rounded-lg p-4 sm:p-6 text-center">
            <div class="flex items-center justify-center mb-2">
                <svg class="w-5 h-5 sm:w-6 sm:h-6 text-yellow-600 dark:text-yellow-400 mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                </svg>
                <p class="text-sm sm:text-base text-yellow-800 dark:text-yellow-200 font-semibold">
                    Currently showing {{ $featuredListings->count() }} featured listing{{ $featuredListings->count() != 1 ? 's' : '' }}. Minimum recommended: 8
                </p>
            </div>
            <p class="text-xs sm:text-sm text-yellow-700 dark:text-yellow-300">
                Contact admin to feature more listings for better visibility.
            </p>
        </div>
        @endif

        @else
        <div class="bg-gray-100 dark:bg-gray-800 rounded-xl p-8 sm:p-12 text-center border-2 border-dashed border-gray-300 dark:border-gray-600">
            <svg class="w-16 h-16 sm:w-20 sm:h-20 mx-auto mb-4 text-gray-400 dark:text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <h3 class="text-xl sm:text-2xl font-bold text-gray-900 dark:text-white mb-2">No Featured Listings Yet</h3>
            <p class="text-gray-600 dark:text-gray-400 text-sm sm:text-base">Check back soon for premium rental offerings.</p>
        </div>
        @endif
    </div>
</div>
