<div class="booking-calendar-wrapper">
    {{-- Single Sliding Container --}}
    <div class="w-full">
        {{-- Main Calendar Container - Auto Height --}}
        <div class="bg-white dark:bg-gray-800">

            {{-- Step 1: Check-in Date --}}
            <div id="step-1" class="booking-step active" style="display: block;">
                <h3 class="text-lg font-bold mb-3 text-gray-900 dark:text-white">Select Check-in Date</h3>

                {{-- Calendar Navigation --}}
                <div class="flex items-center justify-between mb-3">
                    <button type="button" id="prev-month-checkin" class="p-1 hover:bg-gray-100 dark:hover:bg-gray-700 rounded transition">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                        </svg>
                    </button>
                    <h4 id="month-year-checkin" class="text-sm font-semibold text-gray-900 dark:text-white"></h4>
                    <button type="button" id="next-month-checkin" class="p-1 hover:bg-gray-100 dark:hover:bg-gray-700 rounded transition">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </button>
                </div>

                {{-- Custom Calendar --}}
                <div id="custom-checkin-calendar" wire:ignore class="bg-gray-100 dark:bg-gray-900 p-2 rounded-lg"></div>

                {{-- Legend --}}
                <div class="mt-4 flex flex-wrap gap-3 text-xs">
                    <span class="flex items-center gap-1">
                        <span class="w-3 h-3 bg-green-500 rounded"></span>Available
                    </span>
                    <span class="flex items-center gap-1">
                        <span class="w-3 h-3 bg-yellow-500 rounded"></span>Buffer Period
                    </span>
                    <span class="flex items-center gap-1">
                        <span class="w-3 h-3 bg-red-500 rounded"></span>Fully Booked
                    </span>
                </div>

                <div id="selected-checkin" class="hidden mt-4 p-3 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                    <p class="text-sm text-gray-700 dark:text-gray-300">
                        <strong>Selected:</strong> <span id="checkin-date-display"></span>
                    </p>
                </div>
            </div>

            {{-- Step 2: Check-in Time --}}
            <div id="step-2" class="booking-step" wire:ignore>
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">Select Check-in Time</h3>
                    <button type="button" onclick="bookingCalendar.goToStep(1)" class="text-sm text-blue-600 hover:text-blue-700">
                        ← Change Date
                    </button>
                </div>

                <div class="mb-4 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <p class="text-sm text-gray-700 dark:text-gray-300">
                        <strong>Date:</strong> <span id="step2-date-display"></span>
                    </p>
                </div>

                {{-- Time Slots Grid --}}
                <div>
                    <div class="flex gap-3 text-xs mb-3">
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-green-500 rounded"></span>Available
                        </span>
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-yellow-500 rounded"></span>Buffer
                        </span>
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-red-500 rounded"></span>Booked
                        </span>
                    </div>
                    <div id="checkin-timeslots" class="grid grid-cols-6 gap-2"></div>
                </div>
            </div>

            {{-- Step 3: Check-out Date --}}
            <div id="step-3" class="booking-step" wire:ignore>
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">Select Check-out Date</h3>
                    <button type="button" onclick="bookingCalendar.goToStep(2)" class="text-sm text-blue-600 hover:text-blue-700">
                        ← Change Time
                    </button>
                </div>

                {{-- Calendar Navigation --}}
                <div class="flex items-center justify-between mb-3">
                    <button type="button" id="prev-month-checkout" class="p-1 hover:bg-gray-100 dark:hover:bg-gray-700 rounded transition">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                        </svg>
                    </button>
                    <h4 id="month-year-checkout" class="text-sm font-semibold text-gray-900 dark:text-white"></h4>
                    <button type="button" id="next-month-checkout" class="p-1 hover:bg-gray-100 dark:hover:bg-gray-700 rounded transition">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </button>
                </div>

                {{-- Custom Checkout Calendar --}}
                <div id="custom-checkout-calendar" class="bg-gray-100 dark:bg-gray-900 p-2 rounded-lg"></div>

                {{-- Legend --}}
                <div class="mt-4 flex flex-wrap gap-3 text-xs">
                    <span class="flex items-center gap-1">
                        <span class="w-3 h-3 bg-green-500 rounded"></span>Available
                    </span>
                    <span class="flex items-center gap-1">
                        <span class="w-3 h-3 bg-yellow-500 rounded"></span>Buffer Period
                    </span>
                    <span class="flex items-center gap-1">
                        <span class="w-3 h-3 bg-red-500 rounded"></span>Fully Booked
                    </span>
                </div>
            </div>

            {{-- Step 4: Check-out Time --}}
            <div id="step-4" class="booking-step" wire:ignore>
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">Select Check-out Time</h3>
                    <button type="button" onclick="bookingCalendar.goToStep(3)" class="text-sm text-blue-600 hover:text-blue-700">
                        ← Change Date
                    </button>
                </div>

                <div class="mb-4 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <p class="text-sm text-gray-700 dark:text-gray-300">
                        <strong>Date:</strong> <span id="checkout-date-display"></span>
                    </p>
                </div>

                {{-- Time Slots Grid --}}
                <div>
                    <div class="flex gap-3 text-xs mb-3">
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-green-500 rounded"></span>Available
                        </span>
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-yellow-500 rounded"></span>Buffer
                        </span>
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-red-500 rounded"></span>Booked
                        </span>
                    </div>
                    <div id="checkout-timeslots" class="grid grid-cols-6 gap-2"></div>
                </div>
            </div>

            {{-- Step 5: Booking Details --}}
            <div id="step-5" class="booking-step">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">Booking Details</h3>
                    <button type="button" onclick="bookingCalendar.goToStep(4)" class="text-sm text-blue-600 hover:text-blue-700">
                        ← Change Time
                    </button>
                </div>

                {{-- Booking Summary --}}
                <div class="mb-6 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg space-y-2">
                    <div class="flex justify-between text-sm text-gray-900 dark:text-gray-100">
                        <span class="font-semibold">Check-in:</span>
                        <span id="summary-checkin" class="text-gray-700 dark:text-gray-300"></span>
                    </div>
                    <div class="flex justify-between text-sm text-gray-900 dark:text-gray-100">
                        <span class="font-semibold">Check-out:</span>
                        <span id="summary-checkout" class="text-gray-700 dark:text-gray-300"></span>
                    </div>
                    <div class="flex justify-between text-sm border-t border-blue-200 dark:border-blue-800 pt-2 text-gray-900 dark:text-gray-100">
                        <span class="font-semibold">Duration:</span>
                        <span id="summary-duration" class="text-gray-700 dark:text-gray-300"></span>
                    </div>
                </div>

                {{-- Form Fields --}}
                <form wire:submit="book" class="space-y-4">
                    {{-- Hidden fields for Livewire --}}
                    <input type="hidden" wire:model.live="check_in" id="hidden_check_in">
                    <input type="hidden" wire:model.live="check_in_hour" id="hidden_check_in_hour">
                    <input type="hidden" wire:model.live="check_out" id="hidden_check_out">
                    <input type="hidden" wire:model.live="check_out_hour" id="hidden_check_out_hour">

                    {{-- Guests --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Number of Guests (Max: {{ $listing->capacity }})
                        </label>
                        <input type="number" wire:model.live="guests" min="1" max="{{ $listing->capacity }}" required
                               class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                        @error('guests') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                    </div>

                    {{-- Pickup/Dropoff Locations --}}
                    @if($listing->pickupLocations && $listing->pickupLocations->count() > 0)
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Pickup Location *
                                </label>
                                <select wire:model="pickup_location_id" required
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                                    <option value="">Select location</option>
                                    @foreach($listing->pickupLocations as $location)
                                        <option value="{{ $location->id }}">{{ $location->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Dropoff Location *
                                </label>
                                <select wire:model="dropoff_location_id" required
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                                    <option value="">Select location</option>
                                    @foreach($listing->pickupLocations as $location)
                                        <option value="{{ $location->id }}">{{ $location->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    @endif

                    {{-- Add-ons --}}
                    @if($listing->addOns && $listing->addOns->count() > 0)
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Optional Add-ons</label>
                            <div class="space-y-2">
                                @foreach($listing->addOns as $addOn)
                                    <label class="flex items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600">
                                        <input type="checkbox" wire:model.live="selectedAddOns" value="{{ $addOn->id }}" class="rounded">
                                        <div class="ml-3 flex-1">
                                            <div class="font-medium text-sm">{{ $addOn->name }}</div>
                                            <div class="text-xs text-gray-600 dark:text-gray-400">RM {{ number_format($addOn->pivot->custom_price ?? $addOn->price, 2) }}</div>
                                        </div>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    {{-- Payment Method --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payment Method</label>
                        <select wire:model="payment_channel" required class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                            <option value="fpx">FPX (Online Banking)</option>
                            <option value="tng">DuitNow QR</option>
                        </select>
                    </div>

                    {{-- Price Summary --}}
                    @if($days > 0)
                        <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4">
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span>RM {{ number_format($listing->price_per_day, 2) }} × {{ $days }} days</span>
                                    <span>RM {{ number_format($subtotal, 2) }}</span>
                                </div>
                                @if($discount_amount > 0)
                                    <div class="flex justify-between text-green-600">
                                        <span>Discount ({{ $discount_percentage }}%)</span>
                                        <span>-RM {{ number_format($discount_amount, 2) }}</span>
                                    </div>
                                @endif
                                @if($addOnsTotal > 0)
                                    <div class="flex justify-between text-blue-600">
                                        <span>Add-ons</span>
                                        <span>+RM {{ number_format($addOnsTotal, 2) }}</span>
                                    </div>
                                @endif
                                @if($gateway_fee > 0)
                                    <div class="flex justify-between">
                                        <span>Gateway Fee</span>
                                        <span>RM {{ number_format($gateway_fee, 2) }}</span>
                                    </div>
                                @endif
                                <div class="flex justify-between font-bold text-lg pt-2 border-t">
                                    <span>Total</span>
                                    <span>RM {{ number_format($total_price, 2) }}</span>
                                </div>
                            </div>
                        </div>
                    @endif

                    <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 rounded-lg transition">
                        Confirm & Pay
                    </button>
                </form>
            </div>
        </div>
    </div>

    {{-- Booking Data --}}
    <script>
        window.bookingData = @json($calendarData);
        window.bufferHours = {{ $listing->buffer_hours ?? 0 }};
    </script>

    {{-- Custom Booking Calendar Logic --}}
    <script src="{{ asset('js/custom-booking-calendar.js') }}"></script>

    {{-- Custom Styles --}}
    <style>
        /* Simple display toggle - no padding as parent has padding already */
        .booking-step {
            display: none !important;
        }
        .booking-step.active {
            display: block !important;
        }
        .step-item {
            display: flex;
            align-items: center;
            gap: 8px;
            opacity: 0.5;
        }
        .step-item.active {
            opacity: 1;
        }
        .step-item.completed {
            opacity: 0.7;
        }
        .step-circle {
            width: 28px;
            height: 28px;
            border-radius: 50%;
            background: #e5e7eb;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 12px;
        }
        .step-item.active .step-circle {
            background: #3b82f6;
            color: white;
        }
        .step-item.completed .step-circle {
            background: #10b981;
            color: white;
        }
        .step-label {
            font-size: 14px;
            font-weight: 500;
        }
        .step-divider {
            width: 20px;
            height: 2px;
            background: #e5e7eb;
        }

        /* Custom Calendar Grid */
        .calendar-grid {
            display: grid !important;
            grid-template-columns: repeat(7, 1fr);
            gap: 4px;
            margin-bottom: 8px;
            visibility: visible !important;
            opacity: 1 !important;
            width: 100%;
        }

        .calendar-day-header {
            text-align: center;
            font-weight: 600;
            font-size: 10px;
            padding: 4px 0;
            color: #9ca3af;
            background: transparent;
        }

        .calendar-day {
            border-radius: 6px;
            padding: 6px 4px 2px 4px;
            display: flex !important;
            flex-direction: column;
            align-items: center;
            justify-content: space-between;
            cursor: pointer;
            transition: all 0.2s;
            border: 1px solid #374151;
            position: relative;
            height: 50px;
            visibility: visible !important;
            opacity: 1 !important;
            background: #1f2937;
            color: #e5e7eb;
        }

        .calendar-day.empty {
            cursor: default;
            background: transparent;
        }

        .calendar-day .day-number {
            font-weight: 700;
            font-size: 16px;
            line-height: 1;
            flex-grow: 1;
            display: flex;
            align-items: center;
        }

        .calendar-day .status-bar {
            width: 100%;
            height: 4px;
            border-radius: 2px;
            margin-top: auto;
        }

        /* Available days */
        .calendar-day.available {
            background: #1f2937;
            color: #e5e7eb;
        }
        .calendar-day.available:hover {
            background: #374151;
            border-color: #10b981;
            transform: scale(1.05);
        }
        .calendar-day.available .status-bar {
            background: #10b981;
        }

        /* Buffer days */
        .calendar-day.buffer {
            background: #1f2937;
            color: #9ca3af;
            cursor: not-allowed;
            opacity: 0.7;
        }
        .calendar-day.buffer .status-bar {
            background: #f59e0b;
        }

        /* Fully booked days */
        .calendar-day.fully-booked {
            background: #1f2937;
            color: #6b7280;
            cursor: not-allowed;
            opacity: 0.6;
        }
        .calendar-day.fully-booked .status-bar {
            background: #ef4444;
        }

        /* Past days */
        .calendar-day.past {
            background: #f3f4f6;
            color: #9ca3af;
            cursor: not-allowed;
            opacity: 0.5;
        }

        /* Dark mode adjustments */
        @media (prefers-color-scheme: dark) {
            .calendar-day-header {
                color: #9ca3af;
            }
            .calendar-day.past {
                background: #374151;
                color: #6b7280;
            }
        }

        /* Time Slot Buttons */
        .timeslot-btn {
            padding: 6px 4px;
            border-radius: 4px;
            font-weight: 500;
            text-align: center;
            cursor: pointer;
            transition: all 0.2s;
            font-size: 11px;
            border: none;
        }
        .timeslot-available {
            background: #10b981;
            color: white;
        }
        .timeslot-available:hover {
            background: #059669;
            transform: scale(1.05);
        }
        .timeslot-buffer {
            background: #fef3c7;
            color: #92400e;
            opacity: 0.6;
            cursor: not-allowed;
        }
        .timeslot-booked {
            background: #fee2e2;
            color: #991b1b;
            opacity: 0.6;
            cursor: not-allowed;
        }
    </style>
</div>
