<div class="booking-calendar-wrapper">
    {{-- Load CSS from CDN --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/air-datepicker@3.5.3/air-datepicker.min.css">

    {{-- Booking Container --}}
    <div class="max-w-4xl mx-auto">
        {{-- Step Indicator --}}
        <div class="mb-6 flex items-center justify-center gap-4">
            <div class="flex items-center gap-2" id="step-indicator">
                <div class="step-item active" data-step="1">
                    <div class="step-circle">1</div>
                    <span class="step-label">Select Date</span>
                </div>
                <div class="step-divider"></div>
                <div class="step-item" data-step="2">
                    <div class="step-circle">2</div>
                    <span class="step-label">Select Time</span>
                </div>
                <div class="step-divider"></div>
                <div class="step-item" data-step="3">
                    <div class="step-circle">3</div>
                    <span class="step-label">Details</span>
                </div>
            </div>
        </div>

        {{-- Step 1: Date Selection --}}
        <div id="step-1" class="booking-step active">
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6">
                <h3 class="text-xl font-bold mb-4 text-gray-900 dark:text-white">Select Check-in Date</h3>

                {{-- Calendar Container --}}
                <div id="checkin-calendar" class="mb-4"></div>

                <div id="selected-checkin" class="hidden mt-4 p-3 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                    <p class="text-sm text-gray-700 dark:text-gray-300">
                        <strong>Selected:</strong> <span id="checkin-date-display"></span>
                    </p>
                </div>
            </div>
        </div>

        {{-- Step 2: Time Selection --}}
        <div id="step-2" class="booking-step hidden">
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">Select Check-in Time</h3>
                    <button type="button" onclick="bookingCalendar.goToStep(1)" class="text-sm text-blue-600 hover:text-blue-700">
                        ← Change Date
                    </button>
                </div>

                <div class="mb-4 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <p class="text-sm text-gray-700 dark:text-gray-300">
                        <strong>Date:</strong> <span id="step2-date-display"></span>
                    </p>
                </div>

                {{-- Time Slots Grid --}}
                <div class="mb-4">
                    <div class="flex gap-3 text-xs mb-3">
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-green-500 rounded"></span>Available
                        </span>
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-yellow-500 rounded"></span>Buffer
                        </span>
                        <span class="flex items-center gap-1">
                            <span class="w-3 h-3 bg-red-500 rounded"></span>Booked
                        </span>
                    </div>
                    <div id="checkin-timeslots" class="grid grid-cols-3 sm:grid-cols-4 md:grid-cols-6 gap-2"></div>
                </div>
            </div>

            {{-- Checkout Date Selection --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 mt-6" id="checkout-section" style="display: none;">
                <h3 class="text-xl font-bold mb-4 text-gray-900 dark:text-white">Select Check-out Date</h3>
                <div id="checkout-calendar" class="mb-4"></div>
            </div>

            {{-- Checkout Time Selection --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 mt-6" id="checkout-time-section" style="display: none;">
                <h3 class="text-xl font-bold mb-4 text-gray-900 dark:text-white">Select Check-out Time</h3>
                <div class="mb-4 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <p class="text-sm text-gray-700 dark:text-gray-300">
                        <strong>Date:</strong> <span id="checkout-date-display"></span>
                    </p>
                </div>
                <div id="checkout-timeslots" class="grid grid-cols-3 sm:grid-cols-4 md:grid-cols-6 gap-2"></div>
            </div>
        </div>

        {{-- Step 3: Booking Details --}}
        <div id="step-3" class="booking-step hidden">
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">Booking Details</h3>
                    <button type="button" onclick="bookingCalendar.goToStep(2)" class="text-sm text-blue-600 hover:text-blue-700">
                        ← Change Time
                    </button>
                </div>

                {{-- Booking Summary --}}
                <div class="mb-6 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg space-y-2">
                    <div class="flex justify-between text-sm">
                        <span class="font-semibold">Check-in:</span>
                        <span id="summary-checkin"></span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="font-semibold">Check-out:</span>
                        <span id="summary-checkout"></span>
                    </div>
                    <div class="flex justify-between text-sm border-t border-blue-200 dark:border-blue-800 pt-2">
                        <span class="font-semibold">Duration:</span>
                        <span id="summary-duration"></span>
                    </div>
                </div>

                {{-- Form Fields --}}
                <form wire:submit="book" class="space-y-4">
                    {{-- Hidden fields for Livewire --}}
                    <input type="hidden" wire:model="check_in" id="hidden_check_in">
                    <input type="hidden" wire:model="check_in_hour" id="hidden_check_in_hour">
                    <input type="hidden" wire:model="check_out" id="hidden_check_out">
                    <input type="hidden" wire:model="check_out_hour" id="hidden_check_out_hour">

                    {{-- Guests --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Number of Guests (Max: {{ $listing->capacity }})
                        </label>
                        <input type="number" wire:model.live="guests" min="1" max="{{ $listing->capacity }}" required
                               class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                        @error('guests') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                    </div>

                    {{-- Pickup/Dropoff Locations --}}
                    @if($listing->pickupLocations && $listing->pickupLocations->count() > 0)
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Pickup Location *
                                </label>
                                <select wire:model="pickup_location_id" required
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                                    <option value="">Select location</option>
                                    @foreach($listing->pickupLocations as $location)
                                        <option value="{{ $location->id }}">{{ $location->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Dropoff Location *
                                </label>
                                <select wire:model="dropoff_location_id" required
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                                    <option value="">Select location</option>
                                    @foreach($listing->pickupLocations as $location)
                                        <option value="{{ $location->id }}">{{ $location->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    @endif

                    {{-- Add-ons --}}
                    @if($listing->addOns && $listing->addOns->count() > 0)
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Optional Add-ons</label>
                            <div class="space-y-2">
                                @foreach($listing->addOns as $addOn)
                                    <label class="flex items-center p-3 bg-gray-50 dark:bg-gray-700 rounded-lg cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-600">
                                        <input type="checkbox" wire:model.live="selectedAddOns" value="{{ $addOn->id }}" class="rounded">
                                        <div class="ml-3 flex-1">
                                            <div class="font-medium text-sm">{{ $addOn->name }}</div>
                                            <div class="text-xs text-gray-600 dark:text-gray-400">RM {{ number_format($addOn->pivot->custom_price ?? $addOn->price, 2) }}</div>
                                        </div>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    {{-- Payment Method --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payment Method</label>
                        <select wire:model="payment_channel" required class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100">
                            <option value="fpx">FPX (Online Banking)</option>
                            <option value="tng">DuitNow QR</option>
                        </select>
                    </div>

                    {{-- Price Summary --}}
                    @if($days > 0)
                        <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4">
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span>RM {{ number_format($listing->price_per_day, 2) }} × {{ $days }} days</span>
                                    <span>RM {{ number_format($subtotal, 2) }}</span>
                                </div>
                                @if($discount_amount > 0)
                                    <div class="flex justify-between text-green-600">
                                        <span>Discount ({{ $discount_percentage }}%)</span>
                                        <span>-RM {{ number_format($discount_amount, 2) }}</span>
                                    </div>
                                @endif
                                @if($addOnsTotal > 0)
                                    <div class="flex justify-between text-blue-600">
                                        <span>Add-ons</span>
                                        <span>+RM {{ number_format($addOnsTotal, 2) }}</span>
                                    </div>
                                @endif
                                @if($gateway_fee > 0)
                                    <div class="flex justify-between">
                                        <span>Gateway Fee</span>
                                        <span>RM {{ number_format($gateway_fee, 2) }}</span>
                                    </div>
                                @endif
                                <div class="flex justify-between font-bold text-lg pt-2 border-t">
                                    <span>Total</span>
                                    <span>RM {{ number_format($total_price, 2) }}</span>
                                </div>
                            </div>
                        </div>
                    @endif

                    <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 rounded-lg transition">
                        Confirm & Pay
                    </button>
                </form>
            </div>
        </div>
    </div>

    {{-- Load Air Datepicker from CDN --}}
    <script src="https://cdn.jsdelivr.net/npm/air-datepicker@3.5.3/air-datepicker.min.js"></script>

    {{-- Booking Data --}}
    <script>
        window.bookingData = @json($calendarData);
        window.bufferHours = {{ $listing->buffer_hours ?? 0 }};
    </script>

    {{-- Booking Calendar Logic --}}
    <script src="{{ asset('js/booking-calendar.js') }}"></script>

    {{-- Inline Styles for Steps --}}
    <style>
        .booking-step {
            display: none;
        }
        .booking-step.active {
            display: block;
        }
        .step-item {
            display: flex;
            align-items: center;
            gap: 8px;
            opacity: 0.5;
        }
        .step-item.active {
            opacity: 1;
        }
        .step-item.completed {
            opacity: 0.7;
        }
        .step-circle {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: #e5e7eb;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 14px;
        }
        .step-item.active .step-circle {
            background: #3b82f6;
            color: white;
        }
        .step-item.completed .step-circle {
            background: #10b981;
            color: white;
        }
        .step-label {
            font-size: 14px;
            font-weight: 500;
        }
        .step-divider {
            width: 40px;
            height: 2px;
            background: #e5e7eb;
        }
        .timeslot-btn {
            padding: 12px;
            border-radius: 8px;
            font-weight: 500;
            text-align: center;
            cursor: pointer;
            transition: all 0.2s;
            font-size: 14px;
        }
        .timeslot-available {
            background: #10b981;
            color: white;
        }
        .timeslot-available:hover {
            background: #059669;
            transform: scale(1.05);
        }
        .timeslot-buffer {
            background: #eab308;
            color: #000;
            opacity: 0.5;
            cursor: not-allowed;
        }
        .timeslot-booked {
            background: #ef4444;
            color: white;
            opacity: 0.5;
            cursor: not-allowed;
        }
    </style>
</div>