<div>
    {{-- Load Flatpickr CSS and JS --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

    @php
        // Define rental-type-specific labels
        $rentalTypeName = $listing->rentalType->name ?? '';
        $labels = [
            'Car' => ['start' => 'Pick-up', 'end' => 'Drop-off'],
            'Houseboat' => ['start' => 'Check-in', 'end' => 'Check-out'],
            'Guesthouse' => ['start' => 'Check-in', 'end' => 'Check-out'],
            'Boat' => ['start' => 'Departure', 'end' => 'Return'],
            'Fishing Trip' => ['start' => 'Trip Start', 'end' => 'Trip End'],
        ];
        $currentLabels = $labels[$rentalTypeName] ?? ['start' => 'Check-in', 'end' => 'Check-out'];
    @endphp

    {{-- Availability Info Banner --}}
    @php
        $bookedDates = $calendarData['booked'] ?? [];
        $bufferDates = $calendarData['buffer'] ?? [];
    @endphp

    @if($listing->buffer_hours > 0 || count($bookedDates) > 0 || count($bufferDates) > 0)
        <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-3">
            <div class="flex items-start gap-2">
                <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div class="text-sm text-gray-700 dark:text-gray-300">
                    <p class="font-semibold mb-1">Booking Availability Information</p>
                    <ul class="text-xs space-y-1 text-gray-600 dark:text-gray-400">
                        @if(count($bookedDates) > 0)
                            <li class="flex items-center gap-2">
                                <span class="w-3 h-3 bg-red-500 rounded-full flex-shrink-0"></span>
                                <span><strong>{{ count($bookedDates) }}</strong> dates currently booked</span>
                            </li>
                        @endif
                        @if($listing->buffer_hours > 0)
                            <li class="flex items-center gap-2">
                                <span class="w-3 h-3 bg-yellow-500 rounded-full flex-shrink-0"></span>
                                <span><strong>{{ $listing->buffer_hours }} hour</strong> preparation buffer after each checkout</span>
                            </li>
                        @endif
                        <li class="flex items-center gap-2">
                            <span class="w-3 h-3 bg-green-500 rounded-full flex-shrink-0"></span>
                            <span>Dates not marked as booked or in buffer period are available</span>
                        </li>
                    </ul>
                    <p class="mt-2 text-xs italic">The native date picker will show unavailable dates - these cannot be selected for booking.</p>
                </div>
            </div>
        </div>
    @endif

    <form wire:submit="book">
        <div class="space-y-4">
            {{-- Pick-up Date & Hour --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    {{ $currentLabels['start'] }} Date & Hour
                </label>

                {{-- Date Picker --}}
                <input type="text" id="check_in_picker" wire:model="check_in" required readonly
                       placeholder="Select date"
                       class="w-full mb-3 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500 cursor-pointer">

                {{-- Hour Availability Visual Grid (PRIMARY METHOD) --}}
                <div id="check_in_hour_grid" class="mt-2 hidden">
                    <div class="mb-2 flex items-center justify-between">
                        <div class="text-sm font-semibold text-gray-700 dark:text-gray-300">Click a time slot to select:</div>
                        <div class="flex gap-2 text-xs">
                            <span class="flex items-center gap-1"><span class="w-3 h-3 bg-green-500 rounded"></span>Available</span>
                            <span class="flex items-center gap-1"><span class="w-3 h-3 bg-yellow-500 rounded"></span>Buffer</span>
                            <span class="flex items-center gap-1"><span class="w-3 h-3 bg-red-500 rounded"></span>Booked</span>
                        </div>
                    </div>
                    <div class="grid grid-cols-6 gap-2 p-3 bg-gray-50 dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700"></div>
                </div>

                {{-- Hidden select for form submission --}}
                <select wire:model.live="check_in_hour" id="check_in_hour_select" required class="hidden">
                    <option value="">Hour</option>
                    @for($h = 0; $h < 24; $h++)
                        <option value="{{ str_pad($h, 2, '0', STR_PAD_LEFT) }}">
                            {{ date('h:00 A', strtotime("$h:00")) }}
                        </option>
                    @endfor
                </select>

                {{-- Selected time display --}}
                <div id="check_in_selected" class="hidden mt-2 p-2 bg-blue-50 dark:bg-blue-900/20 rounded text-sm">
                    <strong class="text-blue-700 dark:text-blue-300">Selected:</strong> <span id="check_in_selected_text"></span>
                </div>

                @error('check_in') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
                @error('check_in_hour') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
            </div>

            {{-- Drop-off Date & Hour --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    {{ $currentLabels['end'] }} Date & Hour
                </label>

                {{-- Date Picker --}}
                <input type="text" id="check_out_picker" wire:model="check_out" required readonly
                       placeholder="Select date"
                       class="w-full mb-3 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500 cursor-pointer">

                {{-- Hour Availability Visual Grid (PRIMARY METHOD) --}}
                <div id="check_out_hour_grid" class="mt-2 hidden">
                    <div class="mb-2 flex items-center justify-between">
                        <div class="text-sm font-semibold text-gray-700 dark:text-gray-300">Click a time slot to select:</div>
                        <div class="flex gap-2 text-xs">
                            <span class="flex items-center gap-1"><span class="w-3 h-3 bg-green-500 rounded"></span>Available</span>
                            <span class="flex items-center gap-1"><span class="w-3 h-3 bg-yellow-500 rounded"></span>Buffer</span>
                            <span class="flex items-center gap-1"><span class="w-3 h-3 bg-red-500 rounded"></span>Booked</span>
                        </div>
                    </div>
                    <div class="grid grid-cols-6 gap-2 p-3 bg-gray-50 dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700"></div>
                </div>

                {{-- Hidden select for form submission --}}
                <select wire:model.live="check_out_hour" id="check_out_hour_select" required class="hidden">
                    <option value="">Hour</option>
                    @for($h = 0; $h < 24; $h++)
                        <option value="{{ str_pad($h, 2, '0', STR_PAD_LEFT) }}">
                            {{ date('h:00 A', strtotime("$h:00")) }}
                        </option>
                    @endfor
                </select>

                {{-- Selected time display --}}
                <div id="check_out_selected" class="hidden mt-2 p-2 bg-purple-50 dark:bg-purple-900/20 rounded text-sm">
                    <strong class="text-purple-700 dark:text-purple-300">Selected:</strong> <span id="check_out_selected_text"></span>
                </div>

                @error('check_out')
                    <div class="mt-2 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-3">
                        <div class="flex items-start gap-2">
                            <svg class="w-5 h-5 text-red-600 dark:text-red-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div class="flex-1">
                                <p class="text-sm font-semibold text-red-800 dark:text-red-200">Dates Not Available</p>
                                <p class="text-xs text-red-700 dark:text-red-300 mt-1">{{ $message }}</p>
                            </div>
                        </div>
                    </div>
                @enderror
                @error('check_out_hour') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Guests (Max: {{ $listing->capacity }})</label>
                <input type="number" wire:model.live="guests" min="1" max="{{ $listing->capacity }}" value="1" required
                       class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                @error('guests') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
            </div>

            {{-- Pickup/Dropoff Locations (for Car/Boat rentals) --}}
            @if($listing->pickupLocations && $listing->pickupLocations->count() > 0)
                <div class="border-t border-gray-200 dark:border-gray-700 pt-4 mt-2">
                    <h3 class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-3 flex items-center">
                        <svg class="w-5 h-5 inline-block mr-2 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        Pickup & Dropoff Locations
                    </h3>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        {{-- Pickup Location --}}
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Pickup Location <span class="text-red-500">*</span>
                            </label>
                            <select wire:model="pickup_location_id" required
                                    class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="">Select pickup location</option>
                                @foreach($listing->pickupLocations as $location)
                                    <option value="{{ $location->id }}">
                                        {{ $location->name }}
                                        @if($location->type !== 'general')
                                            ({{ ucfirst(str_replace('_', ' ', $location->type)) }})
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                            @error('pickup_location_id') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
                        </div>

                        {{-- Dropoff Location --}}
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Dropoff Location <span class="text-red-500">*</span>
                            </label>
                            <select wire:model="dropoff_location_id" required
                                    class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="">Select dropoff location</option>
                                @foreach($listing->pickupLocations as $location)
                                    <option value="{{ $location->id }}">
                                        {{ $location->name }}
                                        @if($location->type !== 'general')
                                            ({{ ucfirst(str_replace('_', ' ', $location->type)) }})
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                            @error('dropoff_location_id') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-2 flex items-start">
                        <svg class="w-4 h-4 mr-1 mt-0.5 text-blue-600 dark:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                        </svg>
                        <span>You can choose different locations for pickup and dropoff for your convenience.</span>
                    </p>
                </div>
            @endif

            @if($listing->addOns && $listing->addOns->count() > 0)
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                        <svg class="w-4 h-4 inline-block mr-1 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Optional Add-ons
                    </label>
                    <div class="space-y-2 max-h-48 overflow-y-auto">
                        @foreach($listing->addOns as $addOn)
                            <label class="flex items-start p-3 bg-gray-50 dark:bg-gray-700/50 rounded border border-gray-200 dark:border-gray-600 cursor-pointer hover:border-blue-500 dark:hover:border-blue-400 transition">
                                <input type="checkbox" wire:model.live="selectedAddOns" value="{{ $addOn->id }}" class="rounded border-gray-300 dark:border-gray-600 text-blue-600 focus:ring-blue-500 mt-1">
                                <div class="ml-2 flex-1">
                                    <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $addOn->name }}</div>
                                    <div class="text-xs text-gray-600 dark:text-gray-400">{{ Str::limit($addOn->description, 50) }}</div>
                                    <div class="flex items-center gap-2 mt-1">
                                        <span class="text-xs text-blue-600 dark:text-blue-400 font-semibold">RM {{ number_format($addOn->pivot->custom_price ?? $addOn->price, 2) }}</span>
                                        <span class="text-xs px-2 py-0.5 bg-blue-600 dark:bg-blue-500 text-white rounded-full font-semibold">{{ $addOn->getPricingTypeLabel() }}</span>
                                    </div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>
            @endif

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payment Method</label>
                <select wire:model="payment_channel" required
                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <option value="fpx">FPX (Online Banking)</option>
                    {{-- <option value="card">Credit/Debit Card</option> --}}
                    <option value="tng">DuitNow QR</option>
                    {{-- <option value="boost">Boost</option> --}}
                </select>
                @error('payment_channel') <span class="text-red-500 dark:text-red-400 text-xs">{{ $message }}</span> @enderror
            </div>

            @if($days > 0)
                <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4">
                    <div class="flex justify-between text-sm text-gray-700 dark:text-gray-300 mb-2">
                        <span>RM {{ number_format($listing->price_per_day, 2) }} x {{ $days }} days</span>
                        <span>RM {{ number_format($subtotal, 2) }}</span>
                    </div>

                    @if($discount_amount > 0)
                        <div class="flex justify-between text-sm text-green-600 dark:text-green-400 mb-2">
                            <span class="flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Discount ({{ number_format($discount_percentage, 0) }}% OFF)
                            </span>
                            <span>-RM {{ number_format($discount_amount, 2) }}</span>
                        </div>
                    @endif

                    @if($addOnsTotal > 0)
                        <div class="flex justify-between text-sm text-blue-600 dark:text-blue-400 mb-2">
                            <span class="flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                </svg>
                                Add-ons ({{ count($selectedAddOns) }})
                            </span>
                            <span>+RM {{ number_format($addOnsTotal, 2) }}</span>
                        </div>
                    @endif

                    <div class="flex justify-between text-sm text-gray-700 dark:text-gray-300 mb-2 pt-2 border-t border-gray-200 dark:border-gray-600">
                        <span class="font-medium">Subtotal</span>
                        <span class="font-medium">RM {{ number_format($booking_amount, 2) }}</span>
                    </div>

                    @if($gateway_fee > 0)
                        <div class="flex justify-between text-sm text-gray-700 dark:text-gray-300 mb-2">
                            <span class="flex items-center">
                                <svg class="w-4 h-4 mr-1 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                </svg>
                                Gateway Fee
                            </span>
                            <span>RM {{ number_format($gateway_fee, 2) }}</span>
                        </div>
                    @endif

                    <div class="flex justify-between font-bold text-lg text-gray-900 dark:text-gray-100 pt-2 border-t-2 border-gray-300 dark:border-gray-600">
                        <span>Total</span>
                        <span>RM {{ number_format($total_price, 2) }}</span>
                    </div>
                </div>
            @endif

            <button type="submit"
                    class="w-full bg-blue-600 hover:bg-blue-700 dark:bg-blue-500 dark:hover:bg-blue-600 text-white font-semibold py-3 px-6 rounded-md transition"
                    @if($days <= 0) disabled @endif>
                Book Now & Pay
            </button>
        </div>
    </form>

    {{-- Custom Flatpickr Styling and Initialization --}}
    <style>
        /* Color-code dates in the calendar */
        .flatpickr-day.booked-date {
            background-color: #EF4444 !important;
            color: white !important;
            border-color: #DC2626 !important;
        }
        .flatpickr-day.buffer-date {
            background-color: #EAB308 !important;
            color: white !important;
            border-color: #CA8A04 !important;
        }
        .flatpickr-day.available-date:hover {
            background-color: #10B981 !important;
            color: white !important;
        }
        /* Disable booked and buffer dates */
        .flatpickr-day.booked-date.flatpickr-disabled,
        .flatpickr-day.buffer-date.flatpickr-disabled {
            cursor: not-allowed !important;
            opacity: 0.8;
        }
        /* Dark mode support */
        .dark .flatpickr-calendar {
            background: #1F2937 !important;
            border-color: #374151 !important;
        }
        .dark .flatpickr-months {
            background: #111827 !important;
        }
        .dark .flatpickr-month,
        .dark .flatpickr-weekday,
        .dark .flatpickr-day {
            color: #E5E7EB !important;
        }
        .dark .flatpickr-day:not(.booked-date):not(.buffer-date) {
            background: #374151 !important;
        }

        /* Hour dropdown option styling */
        select option {
            padding: 8px !important;
            margin: 2px 0 !important;
            border-radius: 4px !important;
        }

        /* Better visibility for colored options */
        select option[style*="background-color: #EF4444"] {
            font-weight: bold !important;
        }

        select option[style*="background-color: #EAB308"] {
            font-weight: bold !important;
        }

        select option[style*="background-color: #10B981"] {
            font-weight: bold !important;
        }
    </style>

    <script>
        // Pass data from PHP to JavaScript
        window.bookingCalendarData = {
            bookedDates: @json($calendarData['booked'] ?? []),
            bufferDates: @json($calendarData['buffer'] ?? []),
            unavailableDates: @json($calendarData['unavailable'] ?? []),
            bufferPeriods: @json($calendarData['buffer_periods'] ?? []),
            bookedPeriods: @json($calendarData['booked_periods'] ?? [])
        };
    </script>

    @script
    <script>
        // Wait for Flatpickr to be loaded
        (function() {
            let checkInterval = setInterval(function() {
                if (typeof flatpickr !== 'undefined' && window.bookingCalendarData) {
                    clearInterval(checkInterval);
                    initializeDatePickers();
                }
            }, 100);

            function initializeDatePickers() {
                console.log('Calendar data:', window.bookingCalendarData);

                // Get unavailable dates from window with better error handling
                let bookedDates = [];
                let bufferDates = [];

                try {
                    if (window.bookingCalendarData && window.bookingCalendarData.bookedDates) {
                        bookedDates = Array.isArray(window.bookingCalendarData.bookedDates)
                            ? window.bookingCalendarData.bookedDates
                            : Object.values(window.bookingCalendarData.bookedDates);
                    }
                    if (window.bookingCalendarData && window.bookingCalendarData.bufferDates) {
                        bufferDates = Array.isArray(window.bookingCalendarData.bufferDates)
                            ? window.bookingCalendarData.bufferDates
                            : Object.values(window.bookingCalendarData.bufferDates);
                    }
                } catch (e) {
                    console.error('Error processing dates:', e);
                    bookedDates = [];
                    bufferDates = [];
                }

                // Only disable fully booked dates, not buffer dates
                const unavailableDates = [...bookedDates]; // Changed: removed bufferDates
                const bufferPeriods = window.bookingCalendarData.bufferPeriods || {};

                console.log('Initializing Flatpickr...');
                console.log('Booked dates:', bookedDates);
                console.log('Buffer dates:', bufferDates);
                console.log('Unavailable dates:', unavailableDates);

                // Destroy existing instances if any
                const checkInInput = document.getElementById('check_in_picker');
                const checkOutInput = document.getElementById('check_out_picker');

                if (checkInInput && checkInInput._flatpickr) {
                    checkInInput._flatpickr.destroy();
                }
                if (checkOutInput && checkOutInput._flatpickr) {
                    checkOutInput._flatpickr.destroy();
                }

                // Initialize check-in date picker
                if (checkInInput) {
                    flatpickr("#check_in_picker", {
                        minDate: "tomorrow",
                        dateFormat: "Y-m-d",
                        disable: unavailableDates,
                        allowInput: false,
                        clickOpens: true,
                        onChange: function(selectedDates, dateStr) {
                            $wire.set('check_in', dateStr);
                            // Filter available hours based on buffer periods
                            setTimeout(() => filterAvailableHours('check_in_hour_select', dateStr, bufferPeriods), 100);
                        },
                        onDayCreate: function(dObj, dStr, fp, dayElem) {
                            const date = dayElem.dateObj;
                            const dateString = fp.formatDate(date, 'Y-m-d');

                            if (bookedDates.includes(dateString)) {
                                dayElem.classList.add('booked-date');
                                dayElem.title = 'Booked - Unavailable';
                            } else if (bufferDates.includes(dateString)) {
                                dayElem.classList.add('buffer-date');
                                dayElem.title = 'Buffer Period - Available after buffer hours';
                            } else {
                                dayElem.classList.add('available-date');
                                dayElem.title = 'Available';
                            }
                        }
                    });
                    console.log('Check-in picker initialized');
                }

                // Initialize checkout date picker
                if (checkOutInput) {
                    flatpickr("#check_out_picker", {
                        minDate: "tomorrow",
                        dateFormat: "Y-m-d",
                        disable: unavailableDates,
                        allowInput: false,
                        clickOpens: true,
                        onChange: function(selectedDates, dateStr) {
                            $wire.set('check_out', dateStr);
                            // Filter available hours based on buffer periods
                            setTimeout(() => filterAvailableHours('check_out_hour_select', dateStr, bufferPeriods), 100);
                        },
                        onDayCreate: function(dObj, dStr, fp, dayElem) {
                            const date = dayElem.dateObj;
                            const dateString = fp.formatDate(date, 'Y-m-d');

                            if (bookedDates.includes(dateString)) {
                                dayElem.classList.add('booked-date');
                                dayElem.title = 'Booked - Unavailable';
                            } else if (bufferDates.includes(dateString)) {
                                dayElem.classList.add('buffer-date');
                                dayElem.title = 'Buffer Period - Available after buffer hours';
                            } else {
                                dayElem.classList.add('available-date');
                                dayElem.title = 'Available';
                            }
                        }
                    });
                    console.log('Check-out picker initialized');
                }

                // Check if dates are already selected and apply hour filtering
                const checkInValue = checkInInput?.value;
                const checkOutValue = checkOutInput?.value;

                if (checkInValue) {
                    console.log('Check-in date already selected:', checkInValue);
                    setTimeout(() => filterAvailableHours('check_in_hour_select', checkInValue, bufferPeriods), 200);
                }

                if (checkOutValue) {
                    console.log('Check-out date already selected:', checkOutValue);
                    setTimeout(() => filterAvailableHours('check_out_hour_select', checkOutValue, bufferPeriods), 200);
                }
            }

            // Function to render visual hour grid
            function renderHourGrid(gridId, dateStr, bufferPeriods) {
                const gridContainer = document.getElementById(gridId);
                if (!gridContainer) return;

                const gridElement = gridContainer.querySelector('.grid');
                if (!gridElement) return;

                // Get booked and buffer periods for this date
                const bookedPeriods = window.bookingCalendarData.bookedPeriods?.[dateStr] || [];
                const datePeriods = bufferPeriods[dateStr] || [];

                // Clear grid
                gridElement.innerHTML = '';

                // If no bookings, hide grid
                if (bookedPeriods.length === 0 && datePeriods.length === 0) {
                    gridContainer.classList.add('hidden');
                    return;
                }

                // Show grid
                gridContainer.classList.remove('hidden');

                // Create hour boxes for each hour
                for (let hour = 0; hour < 24; hour++) {
                    const hourDateTime = new Date(dateStr + ' ' + String(hour).padStart(2, '0') + ':00:00');
                    let isBooked = false;
                    let isBuffer = false;

                    // Check if hour is booked
                    bookedPeriods.forEach(period => {
                        const start = new Date(period.start);
                        const end = new Date(period.end);
                        if (hourDateTime >= start && hourDateTime < end) {
                            isBooked = true;
                        }
                    });

                    // Check if hour is in buffer
                    if (!isBooked) {
                        datePeriods.forEach(period => {
                            const start = new Date(period.start);
                            const end = new Date(period.end);
                            if (hourDateTime >= start && hourDateTime < end) {
                                isBuffer = true;
                            }
                        });
                    }

                    // Create hour box
                    const box = document.createElement('div');
                    box.className = 'p-2 rounded text-center font-semibold text-xs';

                    const hourText = (hour === 0 ? 12 : (hour > 12 ? hour - 12 : hour)) + (hour < 12 ? 'AM' : 'PM');

                    if (isBooked) {
                        box.className += ' bg-red-500 text-white';
                        box.textContent = hourText;
                        box.title = 'Booked';
                    } else if (isBuffer) {
                        box.className += ' bg-yellow-500 text-black';
                        box.textContent = hourText;
                        box.title = 'Buffer Period';
                    } else {
                        box.className += ' bg-green-500 text-white cursor-pointer hover:bg-green-600';
                        box.textContent = hourText;
                        box.title = 'Available - Click to select';
                        box.onclick = () => {
                            // Set the hour in the select
                            const selectId = gridId.replace('_grid', '_select');
                            const select = document.getElementById(selectId);
                            if (select) {
                                select.value = String(hour).padStart(2, '0');
                                // Trigger change event for Livewire
                                select.dispatchEvent(new Event('change', { bubbles: true }));

                                // Show selected time
                                const selectedDiv = document.getElementById(selectId.replace('_select', '_selected'));
                                const selectedText = document.getElementById(selectId.replace('_select', '_selected_text'));
                                if (selectedDiv && selectedText) {
                                    selectedDiv.classList.remove('hidden');
                                    selectedText.textContent = hourText;
                                }

                                // Highlight selected box
                                gridElement.querySelectorAll('.selected-hour').forEach(el => el.classList.remove('selected-hour', 'ring-2', 'ring-blue-500'));
                                box.classList.add('selected-hour', 'ring-2', 'ring-blue-500');
                            }
                        };
                    }

                    gridElement.appendChild(box);
                }
            }

            // Function to filter available hours based on buffer periods and booked periods
            function filterAvailableHours(selectId, dateStr, bufferPeriods) {
                const select = document.getElementById(selectId);
                if (!select) {
                    console.error('Select element not found:', selectId);
                    return;
                }

                console.log('Filtering hours for', dateStr);

                // Render visual grid
                const gridId = selectId.replace('_select', '_grid');
                renderHourGrid(gridId, dateStr, bufferPeriods);

                // Get all options
                const options = select.querySelectorAll('option');

                // Get booked and buffer periods for this date
                const bookedPeriods = window.bookingCalendarData.bookedPeriods?.[dateStr] || [];
                const datePeriods = bufferPeriods[dateStr] || [];

                console.log('Booked periods:', bookedPeriods);
                console.log('Buffer periods:', datePeriods);

                // Reset all options first
                options.forEach(opt => {
                    if (opt.value !== '') {
                        opt.disabled = false;
                        opt.style.backgroundColor = '';
                        opt.style.color = '';
                        opt.style.fontWeight = '';
                        opt.removeAttribute('data-status');
                        // Remove old labels and emoji indicators
                        let cleanText = opt.textContent
                            .replace(/🔴\s*/, '')
                            .replace(/🟡\s*/, '')
                            .replace(/🟢\s*/, '')
                            .replace(' - BOOKED', '')
                            .replace(' - BUFFER', '')
                            .replace(' - Available', '')
                            .replace(' ❌ (Booked)', '')
                            .replace(' ❌ (Buffer)', '')
                            .replace(' ✅ (Available)', '')
                            .trim();
                        opt.textContent = cleanText;
                    }
                });

                // If no periods, all hours are available
                if (bookedPeriods.length === 0 && datePeriods.length === 0) {
                    return;
                }

                // Process each hour option
                options.forEach(opt => {
                    if (opt.value === '') return; // Skip placeholder

                    const hour = parseInt(opt.value);
                    // Remove any previous status indicators
                    let baseText = opt.textContent
                        .replace(/🔴\s*/, '')
                        .replace(/🟡\s*/, '')
                        .replace(/🟢\s*/, '')
                        .replace(' - BOOKED', '')
                        .replace(' - BUFFER', '')
                        .replace(' - Available', '')
                        .replace(' ❌ (Booked)', '')
                        .replace(' ❌ (Buffer)', '')
                        .replace(' ✅ (Available)', '')
                        .trim();

                    // Create datetime for this hour on the selected date
                    const hourDateTime = new Date(dateStr + ' ' + String(hour).padStart(2, '0') + ':00:00');

                    let isBooked = false;
                    let isBuffer = false;

                    // Check if hour falls within any booked period
                    bookedPeriods.forEach(period => {
                        const start = new Date(period.start);
                        const end = new Date(period.end);
                        if (hourDateTime >= start && hourDateTime < end) {
                            isBooked = true;
                        }
                    });

                    // Check if hour falls within any buffer period (only if not booked)
                    if (!isBooked) {
                        datePeriods.forEach(period => {
                            const start = new Date(period.start);
                            const end = new Date(period.end);
                            if (hourDateTime >= start && hourDateTime < end) {
                                isBuffer = true;
                            }
                        });
                    }

                    // Apply styling based on status
                    if (isBooked) {
                        // Booked hours - red background, disabled
                        opt.disabled = true;
                        opt.style.backgroundColor = '#EF4444'; // red
                        opt.style.color = '#FFFFFF'; // white
                        opt.style.fontWeight = 'bold';
                        opt.textContent = '🔴 ' + baseText + ' - BOOKED';
                        opt.setAttribute('data-status', 'booked');
                    } else if (isBuffer) {
                        // Buffer period hours - yellow background, disabled
                        opt.disabled = true;
                        opt.style.backgroundColor = '#EAB308'; // yellow
                        opt.style.color = '#000000'; // black for better contrast
                        opt.style.fontWeight = 'bold';
                        opt.textContent = '🟡 ' + baseText + ' - BUFFER';
                        opt.setAttribute('data-status', 'buffer');
                    } else {
                        // Available hours - green background
                        opt.disabled = false;
                        opt.style.backgroundColor = '#10B981'; // green
                        opt.style.color = '#FFFFFF'; // white
                        opt.style.fontWeight = 'bold';
                        opt.textContent = '🟢 ' + baseText + ' - Available';
                        opt.setAttribute('data-status', 'available');
                    }
                });

                console.log('Hours filtered for', dateStr);
            }

            // Listen for Livewire updates and reapply hour filtering
            document.addEventListener('livewire:updated', function() {
                console.log('Livewire updated - reapplying hour filters');
                const bufferPeriods = window.bookingCalendarData.bufferPeriods || {};
                const checkInInput = document.getElementById('check_in_picker');
                const checkOutInput = document.getElementById('check_out_picker');

                if (checkInInput?.value) {
                    setTimeout(() => filterAvailableHours('check_in_hour_select', checkInInput.value, bufferPeriods), 100);
                }

                if (checkOutInput?.value) {
                    setTimeout(() => filterAvailableHours('check_out_hour_select', checkOutInput.value, bufferPeriods), 100);
                }
            });
        })();
    </script>
    @endscript
</div>
