<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Platform Settings</h1>
        <p class="text-gray-600 dark:text-gray-400 mt-2">Configure payment gateway, platform fees, and SEO</p>
    </div>

    <!-- Settings Navigation Tabs -->
    <div class="mb-8 border-b border-gray-200 dark:border-gray-700">
        <nav class="-mb-px flex space-x-8 overflow-x-auto">
            <a href="{{ route('admin.settings') }}" class="border-indigo-600 dark:border-indigo-400 text-indigo-600 dark:text-indigo-400 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                Payment & Fees
            </a>
            <a href="{{ route('admin.seo') }}" class="border-transparent text-gray-500 dark:text-gray-400 hover:border-gray-300 dark:hover:border-gray-600 hover:text-gray-700 dark:hover:text-gray-300 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                SEO & Branding
            </a>
            <a href="{{ route('admin.email-templates') }}" class="border-transparent text-gray-500 dark:text-gray-400 hover:border-gray-300 dark:hover:border-gray-600 hover:text-gray-700 dark:hover:text-gray-300 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                Email Templates
            </a>
        </nav>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Payment Gateway Settings -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <div class="flex items-center mb-6">
                <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                </svg>
                <h2 class="text-xl font-bold text-gray-900 dark:text-white">Payment Gateway Configuration</h2>
            </div>

            @if(session('payment_success'))
                <div class="mb-4 p-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-200 rounded-lg">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('payment_success') }}
                    </div>
                </div>
            @endif

            <form wire:submit.prevent="savePaymentSettings">
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            BayarCash Portal ID
                        </label>
                        <input type="text" wire:model="bayarcash_portal"
                            class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                            placeholder="Enter your BayarCash Portal ID">
                        @error('bayarcash_portal') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            BayarCash PAT (Personal Access Token)
                        </label>
                        <input type="password" wire:model="bayarcash_pat"
                            class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                            placeholder="Enter your PAT">
                        @error('bayarcash_pat') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            BayarCash Secret Key
                        </label>
                        <input type="password" wire:model="bayarcash_secret"
                            class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                            placeholder="Enter your Secret Key">
                        @error('bayarcash_secret') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Gateway Mode
                        </label>
                        <select wire:model.live="bayarcash_mode"
                            class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="sandbox">Sandbox (Testing)</option>
                            <option value="production">Production (Live)</option>
                        </select>
                        <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Use Sandbox for testing, Production for real transactions</p>
                        @error('bayarcash_mode') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>

                    <!-- Gateway Processing Fee -->
                    <div class="pt-4 border-t border-gray-200 dark:border-gray-700">
                        <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3">Gateway Processing Fee</h3>

                        <div class="space-y-3">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Fee Type
                                </label>
                                <select wire:model.live="payment_gateway_fee_type"
                                    class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="fixed">Fixed Amount (RM)</option>
                                    <option value="percentage">Percentage (%)</option>
                                    <option value="both">Both (Fixed + Percentage)</option>
                                </select>
                                @error('payment_gateway_fee_type') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>

                            <div class="grid grid-cols-2 gap-3">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        Fixed Fee (RM)
                                    </label>
                                    <input type="number" step="0.01" wire:model.live="payment_gateway_fee_fixed"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="0.00">
                                    @error('payment_gateway_fee_fixed') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        Percentage (%)
                                    </label>
                                    <input type="number" step="0.01" wire:model.live="payment_gateway_fee_percentage"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="0.00">
                                    @error('payment_gateway_fee_percentage') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <!-- Gateway Fee Preview -->
                            <div class="p-3 bg-indigo-50 dark:bg-indigo-900/20 border border-indigo-200 dark:border-indigo-800 rounded-md">
                                <p class="text-xs font-semibold text-indigo-900 dark:text-indigo-300 mb-2">Gateway Fee Preview (RM 100 booking)</p>
                                @php
                                    $example = 100;
                                    $gwFixed = floatval($payment_gateway_fee_fixed);
                                    $gwPercentage = floatval($payment_gateway_fee_percentage);
                                    $gwFee = 0;

                                    if ($payment_gateway_fee_type === 'fixed') {
                                        $gwFee = $gwFixed;
                                    } elseif ($payment_gateway_fee_type === 'percentage') {
                                        $gwFee = ($example * $gwPercentage) / 100;
                                    } else {
                                        $gwFee = $gwFixed + (($example * $gwPercentage) / 100);
                                    }
                                @endphp
                                <div class="flex justify-between text-xs text-indigo-800 dark:text-indigo-300">
                                    <span>Gateway Fee:</span>
                                    <span class="font-bold">RM {{ number_format($gwFee, 2) }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="pt-4">
                        <button type="submit"
                            class="w-full bg-indigo-600 hover:bg-indigo-700 dark:bg-indigo-500 dark:hover:bg-indigo-600 text-white font-semibold py-3 px-6 rounded-md transition">
                            Save Payment Settings
                        </button>
                    </div>
                </div>
            </form>

            <div class="mt-6 p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 mt-0.5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                    </svg>
                    <div class="text-sm text-blue-800 dark:text-blue-300">
                        <p class="font-semibold mb-1">Configuration Note</p>
                        <p>These settings replace .env file configuration. Get your credentials from BayarCash portal dashboard.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Platform Fee Settings -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <div class="flex items-center mb-6">
                <svg class="w-6 h-6 text-green-600 dark:text-green-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <h2 class="text-xl font-bold text-gray-900 dark:text-white">Platform Fee Configuration</h2>
            </div>

            @if(session('fee_success'))
                <div class="mb-4 p-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-200 rounded-lg">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('fee_success') }}
                    </div>
                </div>
            @endif

            <form wire:submit.prevent="saveFeeSettings">
                <div class="space-y-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Fee Type
                        </label>
                        <select wire:model.live="platform_fee_type"
                            class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-green-500 focus:ring-green-500">
                            <option value="fixed">Fixed Amount (RM)</option>
                            <option value="percentage">Percentage (%)</option>
                            <option value="both">Both (Fixed + Percentage)</option>
                        </select>
                        @error('platform_fee_type') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Fixed Fee (RM)
                            </label>
                            <input type="number" step="0.01" wire:model.live="platform_fee_fixed"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-green-500 focus:ring-green-500"
                                placeholder="0.00">
                            @error('platform_fee_fixed') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Percentage (%)
                            </label>
                            <input type="number" step="0.01" wire:model.live="platform_fee_percentage"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-green-500 focus:ring-green-500"
                                placeholder="0.00">
                            @error('platform_fee_percentage') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Charge Fee To
                        </label>
                        <div class="space-y-2">
                            <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700">
                                <input type="radio" name="platform_fee_charged_to" wire:model.live="platform_fee_charged_to" value="guest"
                                    class="text-green-600 focus:ring-green-500">
                                <span class="ml-3 text-gray-900 dark:text-white">
                                    <strong>Guest</strong> - Fee added to guest's total
                                </span>
                            </label>
                            <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700">
                                <input type="radio" name="platform_fee_charged_to" wire:model.live="platform_fee_charged_to" value="host"
                                    class="text-green-600 focus:ring-green-500">
                                <span class="ml-3 text-gray-900 dark:text-white">
                                    <strong>Host</strong> - Fee deducted from host's earnings
                                </span>
                            </label>
                        </div>
                        @error('platform_fee_charged_to') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Featured Listing Fee (RM)
                        </label>
                        <input type="number" step="0.01" wire:model.live="featured_listing_fee"
                            class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-green-500 focus:ring-green-500"
                            placeholder="0.00">
                        <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Fee charged to hosts when they feature their listing</p>
                        @error('featured_listing_fee') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>

                    <div class="pt-4">
                        <button type="submit"
                            class="w-full bg-green-600 hover:bg-green-700 dark:bg-green-500 dark:hover:bg-green-600 text-white font-semibold py-3 px-6 rounded-md transition">
                            Save Fee Settings
                        </button>
                    </div>
                </div>
            </form>

            <!-- Fee Calculator Preview -->
            <div class="mt-6 p-4 bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-600 rounded-lg">
                <h3 class="font-semibold text-gray-900 dark:text-white mb-3">Fee Preview (Example: RM 100 booking)</h3>
                <div class="space-y-2 text-sm">
                    @php
                        $example = 100;
                        $fixed = floatval($platform_fee_fixed);
                        $percentage = floatval($platform_fee_percentage);
                        $fee = 0;

                        if ($platform_fee_type === 'fixed') {
                            $fee = $fixed;
                        } elseif ($platform_fee_type === 'percentage') {
                            $fee = ($example * $percentage) / 100;
                        } else {
                            $fee = $fixed + (($example * $percentage) / 100);
                        }
                    @endphp

                    <div class="flex justify-between text-gray-600 dark:text-gray-300">
                        <span>Booking Amount:</span>
                        <span class="font-semibold text-gray-900 dark:text-white">RM {{ number_format($example, 2) }}</span>
                    </div>
                    <div class="flex justify-between text-gray-600 dark:text-gray-300">
                        <span>Platform Fee:</span>
                        <span class="font-semibold text-green-600 dark:text-green-400">RM {{ number_format($fee, 2) }}</span>
                    </div>
                    <div class="pt-2 border-t border-gray-300 dark:border-gray-600"></div>
                    <div class="flex justify-between text-gray-900 dark:text-white font-bold">
                        <span>{{ $platform_fee_charged_to === 'guest' ? 'Guest Pays:' : 'Host Receives:' }}</span>
                        <span>RM {{ number_format($platform_fee_charged_to === 'guest' ? $example + $fee : $example - $fee, 2) }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Outgoing Webhook Configuration -->
    <div class="mt-8">
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <div class="flex items-center mb-6">
                <svg class="w-6 h-6 text-purple-600 dark:text-purple-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                </svg>
                <h2 class="text-xl font-bold text-gray-900 dark:text-white">Webhook Configuration</h2>
            </div>

            @if(session('webhook_success'))
                <div class="mb-4 p-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-200 rounded-lg">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('webhook_success') }}
                    </div>
                </div>
            @endif

            <form wire:submit.prevent="saveWebhookSettings">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Left Column -->
                    <div class="space-y-4">
                        <!-- Enable Webhook Toggle -->
                        <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-gray-900 rounded-lg border-2 {{ $webhook_enabled ? 'border-purple-500' : 'border-transparent' }} transition-colors duration-200">
                            <div class="flex-1">
                                <label for="webhook_toggle" class="text-sm font-medium text-gray-900 dark:text-white cursor-pointer">
                                    Enable Webhook
                                    @if($webhook_enabled)
                                        <span class="ml-2 text-xs font-semibold text-purple-600 dark:text-purple-400">(Active)</span>
                                    @else
                                        <span class="ml-2 text-xs font-semibold text-gray-500">(Disabled)</span>
                                    @endif
                                </label>
                                <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Enable to receive webhook notifications for form events</p>
                            </div>
                            <div class="ml-4 flex items-center">
                                <button type="button" wire:click="$toggle('webhook_enabled')"
                                    class="relative inline-flex h-8 w-16 flex-shrink-0 cursor-pointer rounded-full transition-all duration-300 ease-in-out focus:outline-none focus:ring-4 focus:ring-purple-300 dark:focus:ring-purple-800 {{ $webhook_enabled ? 'bg-purple-600 shadow-lg shadow-purple-500/50' : 'bg-gray-400 dark:bg-gray-600' }}">
                                    <span class="pointer-events-none relative inline-block h-7 w-7 transform rounded-full bg-white shadow-lg ring-0 transition-all duration-300 ease-in-out {{ $webhook_enabled ? 'translate-x-8' : 'translate-x-0.5' }}">
                                        @if($webhook_enabled)
                                            <svg class="absolute inset-0 h-7 w-7 text-purple-600" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        @else
                                            <svg class="absolute inset-0 h-7 w-7 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                            </svg>
                                        @endif
                                    </span>
                                </button>
                            </div>
                        </div>

                        <!-- Webhook URL -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Webhook URL <span class="text-red-500">*</span>
                            </label>
                            <input type="url" wire:model="webhook_url"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                placeholder="https://your-website.com/webhook"
                                @if(!$webhook_enabled) disabled @endif>
                            <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Enter the URL where you want to receive webhook notifications</p>
                            @error('webhook_url') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <!-- Secret Key (Optional) -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Webhook Secret Key (Optional)
                            </label>
                            <input type="password" wire:model="webhook_secret_key"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                placeholder="Enter secret key for webhook signature"
                                @if(!$webhook_enabled) disabled @endif>
                            <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Used to verify webhook authenticity. Check X-Webhook-Signature header.</p>
                            @error('webhook_secret_key') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <!-- Right Column - Webhook Events -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                            Webhook Events <span class="text-red-500">*</span>
                        </label>
                        <div class="space-y-2">
                            <label class="flex items-start p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 @if(!$webhook_enabled) opacity-50 cursor-not-allowed @endif">
                                <input type="checkbox" wire:model="webhook_payment_success"
                                    class="mt-1 text-purple-600 focus:ring-purple-500"
                                    @if(!$webhook_enabled) disabled @endif>
                                <div class="ml-3">
                                    <span class="text-sm font-semibold text-gray-900 dark:text-white">Payment Success</span>
                                    <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">When payment is completed successfully</p>
                                </div>
                            </label>

                            <label class="flex items-start p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 @if(!$webhook_enabled) opacity-50 cursor-not-allowed @endif">
                                <input type="checkbox" wire:model="webhook_payment_failed"
                                    class="mt-1 text-purple-600 focus:ring-purple-500"
                                    @if(!$webhook_enabled) disabled @endif>
                                <div class="ml-3">
                                    <span class="text-sm font-semibold text-gray-900 dark:text-white">Payment Failed</span>
                                    <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">When payment fails or is cancelled</p>
                                </div>
                            </label>

                            <label class="flex items-start p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 @if(!$webhook_enabled) opacity-50 cursor-not-allowed @endif">
                                <input type="checkbox" wire:model="webhook_booking_created"
                                    class="mt-1 text-purple-600 focus:ring-purple-500"
                                    @if(!$webhook_enabled) disabled @endif>
                                <div class="ml-3">
                                    <span class="text-sm font-semibold text-gray-900 dark:text-white">Booking Created</span>
                                    <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">When a new booking is created</p>
                                </div>
                            </label>

                            <label class="flex items-start p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 @if(!$webhook_enabled) opacity-50 cursor-not-allowed @endif">
                                <input type="checkbox" wire:model="webhook_booking_cancelled"
                                    class="mt-1 text-purple-600 focus:ring-purple-500"
                                    @if(!$webhook_enabled) disabled @endif>
                                <div class="ml-3">
                                    <span class="text-sm font-semibold text-gray-900 dark:text-white">Booking Cancelled</span>
                                    <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">When booking is cancelled</p>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="mt-6">
                    <button type="submit"
                        class="w-full text-white font-bold py-4 px-6 rounded-lg transition-all duration-200 transform hover:scale-[1.02] active:scale-[0.98] shadow-lg flex items-center justify-center gap-2 {{ $webhook_enabled ? 'bg-gradient-to-r from-green-500 to-green-600 hover:from-green-600 hover:to-green-700 shadow-green-500/50' : 'bg-gray-400 dark:bg-gray-600 cursor-not-allowed opacity-50' }}"
                        @if(!$webhook_enabled) disabled @endif>
                        @if($webhook_enabled)
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            <span>Save Webhook Configuration</span>
                        @else
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                            </svg>
                            <span>Enable Webhook to Save</span>
                        @endif
                    </button>
                </div>
            </form>

            <div class="mt-6 p-4 bg-purple-50 dark:bg-purple-900/20 border border-purple-200 dark:border-purple-800 rounded-lg">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-purple-600 dark:text-purple-400 mt-0.5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                    </svg>
                    <div class="text-sm text-purple-800 dark:text-purple-300">
                        <p class="font-semibold mb-1">Webhook Information</p>
                        <p>Webhooks will send POST requests with JSON data including user details, booking details, and host information. Use the secret key to verify the webhook signature.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Receipt Configuration -->
    <div class="mt-8">
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <div class="flex items-center mb-6">
                <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                <h2 class="text-xl font-bold text-gray-900 dark:text-white">Receipt Customization</h2>
            </div>

            @if(session('receipt_success'))
                <div class="mb-4 p-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-200 rounded-lg">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        {{ session('receipt_success') }}
                    </div>
                </div>
            @endif

            <form wire:submit.prevent="saveReceiptSettings">
                <!-- Receipt Template Selector -->
                <div class="mb-6 p-4 bg-gradient-to-r from-indigo-50 to-purple-50 dark:from-indigo-900/20 dark:to-purple-900/20 rounded-lg border border-indigo-200 dark:border-indigo-800">
                    <label class="block text-sm font-bold text-gray-700 dark:text-gray-300 mb-3">
                        Receipt Design Template
                    </label>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Option 1: Professional -->
                        <label class="relative flex items-start p-4 border-2 rounded-lg cursor-pointer transition-all {{ $receipt_template === 'professional' ? 'border-indigo-600 bg-indigo-50 dark:bg-indigo-900/30' : 'border-gray-300 dark:border-gray-600 hover:border-indigo-300' }}">
                            <input type="radio" wire:model.live="receipt_template" value="professional" class="mt-1 text-indigo-600 focus:ring-indigo-500">
                            <div class="ml-3">
                                <div class="flex items-center gap-2">
                                    <span class="font-bold text-gray-900 dark:text-white">Design 1: Professional</span>
                                    @if($receipt_template === 'professional')
                                        <span class="px-2 py-0.5 bg-indigo-600 text-white text-xs rounded-full">Selected</span>
                                    @endif
                                </div>
                                <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">
                                    Beautiful gradient header, spacious layout with visual sections, icons, and modern design. Best for premium presentation.
                                </p>
                                <div class="mt-2 flex flex-wrap gap-1">
                                    <span class="text-xs bg-blue-100 text-blue-700 px-2 py-0.5 rounded">Gradient Header</span>
                                    <span class="text-xs bg-green-100 text-green-700 px-2 py-0.5 rounded">Icons</span>
                                    <span class="text-xs bg-purple-100 text-purple-700 px-2 py-0.5 rounded">Modern</span>
                                </div>
                            </div>
                        </label>

                        <!-- Option 2: Compact -->
                        <label class="relative flex items-start p-4 border-2 rounded-lg cursor-pointer transition-all {{ $receipt_template === 'compact' ? 'border-indigo-600 bg-indigo-50 dark:bg-indigo-900/30' : 'border-gray-300 dark:border-gray-600 hover:border-indigo-300' }}">
                            <input type="radio" wire:model.live="receipt_template" value="compact" class="mt-1 text-indigo-600 focus:ring-indigo-500">
                            <div class="ml-3">
                                <div class="flex items-center gap-2">
                                    <span class="font-bold text-gray-900 dark:text-white">Design 2: Compact</span>
                                    @if($receipt_template === 'compact')
                                        <span class="px-2 py-0.5 bg-indigo-600 text-white text-xs rounded-full">Selected</span>
                                    @endif
                                </div>
                                <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">
                                    Clean and minimal design, fits perfectly on 1 page. Efficient use of space with table format. Ideal for printing.
                                </p>
                                <div class="mt-2 flex flex-wrap gap-1">
                                    <span class="text-xs bg-gray-100 text-gray-700 px-2 py-0.5 rounded">1-Page Fit</span>
                                    <span class="text-xs bg-blue-100 text-blue-700 px-2 py-0.5 rounded">Clean</span>
                                    <span class="text-xs bg-green-100 text-green-700 px-2 py-0.5 rounded">Print-Ready</span>
                                </div>
                            </div>
                        </label>
                    </div>
                    @error('receipt_template') <span class="text-red-500 text-xs mt-2">{{ $message }}</span> @enderror
                </div>

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Left Column -->
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Company Name
                            </label>
                            <input type="text" wire:model="receipt_company_name"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                placeholder="Your Company Name">
                            <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Defaults to site name if empty</p>
                            @error('receipt_company_name') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Company Address
                            </label>
                            <textarea wire:model="receipt_company_address" rows="2"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                placeholder="123 Business Street, City, State"></textarea>
                            @error('receipt_company_address') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Company Phone
                            </label>
                            <input type="text" wire:model="receipt_company_phone"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                placeholder="+60 12-345 6789">
                            @error('receipt_company_phone') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700">
                                <input type="checkbox" wire:model="receipt_show_logo"
                                    class="text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-3 text-sm text-gray-900 dark:text-white">
                                    <strong>Show Company Logo</strong> on receipt
                                </span>
                            </label>
                        </div>
                    </div>

                    <!-- Right Column -->
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Company Email
                            </label>
                            <input type="email" wire:model="receipt_company_email"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                placeholder="info@yourcompany.com">
                            <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Customer support email</p>
                            @error('receipt_company_email') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Website URL
                            </label>
                            <input type="url" wire:model="receipt_website"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                placeholder="https://yourwebsite.com">
                            @error('receipt_website') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Footer Text
                            </label>
                            <textarea wire:model="receipt_footer_text" rows="2"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                placeholder="Thank you for your business!"></textarea>
                            <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">Message displayed at bottom of receipt</p>
                            @error('receipt_footer_text') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>

                <div class="mt-6">
                    <button type="submit"
                        class="w-full bg-indigo-600 hover:bg-indigo-700 dark:bg-indigo-500 dark:hover:bg-indigo-600 text-white font-semibold py-3 px-6 rounded-md transition">
                        Save Receipt Settings
                    </button>
                </div>
            </form>

            <div class="mt-6 p-4 bg-indigo-50 dark:bg-indigo-900/20 border border-indigo-200 dark:border-indigo-800 rounded-lg">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400 mt-0.5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                    </svg>
                    <div class="text-sm text-indigo-800 dark:text-indigo-300">
                        <p class="font-semibold mb-1">Professional Receipts</p>
                        <p>Customize your booking receipts with your company information. Receipts use a new format with invoice numbers like <span class="font-mono bg-white dark:bg-gray-800 px-2 py-0.5 rounded">20251016-12345</span> (Date-5 digits) for easy tracking.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Information Section -->
    <div class="mt-8 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-6">
        <div class="flex items-start">
            <svg class="w-6 h-6 text-yellow-600 dark:text-yellow-400 mt-0.5 mr-3" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
            </svg>
            <div class="text-sm text-yellow-800 dark:text-yellow-300">
                <p class="font-semibold text-base mb-2">Platform Sustainability</p>
                <p class="mb-2">Platform fees help cover operational costs including server maintenance, payment processing, customer support, and platform improvements.</p>
                <ul class="list-disc list-inside space-y-1 ml-2">
                    <li><strong>Guest Fee:</strong> Added to the booking total - transparent to guests at checkout</li>
                    <li><strong>Host Fee:</strong> Deducted from host earnings - host receives booking amount minus fee</li>
                    <li><strong>Combined Fee:</strong> You can use both fixed and percentage fees together for flexible pricing</li>
                </ul>
            </div>
        </div>
    </div>
</div>
