<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">SEO & Branding Settings</h1>
        <p class="text-gray-600 dark:text-gray-400 mt-2">Configure your site's SEO, branding, and analytics</p>
    </div>

    <!-- Settings Navigation Tabs -->
    <div class="mb-8 border-b border-gray-200 dark:border-gray-700">
        <nav class="-mb-px flex space-x-8 overflow-x-auto">
            <a href="{{ route('admin.settings') }}" class="border-transparent text-gray-500 dark:text-gray-400 hover:border-gray-300 dark:hover:border-gray-600 hover:text-gray-700 dark:hover:text-gray-300 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                Payment & Fees
            </a>
            <a href="{{ route('admin.seo') }}" class="border-indigo-600 dark:border-indigo-400 text-indigo-600 dark:text-indigo-400 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                SEO & Branding
            </a>
            <a href="{{ route('admin.email-templates') }}" class="border-transparent text-gray-500 dark:text-gray-400 hover:border-gray-300 dark:hover:border-gray-600 hover:text-gray-700 dark:hover:text-gray-300 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                Email Templates
            </a>
        </nav>
    </div>

    @if (session()->has('message'))
        <div class="mb-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-200 px-4 py-3 rounded relative">
            {{ session('message') }}
        </div>
    @endif

    <form wire:submit.prevent="save" class="space-y-6">

        <!-- 2-Column Layout -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">

            <!-- LEFT COLUMN -->
            <div class="space-y-6">

                <!-- Basic SEO Information -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Basic Information</h3>

                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Site Name
                            </label>
                            <input type="text" wire:model="site_name"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            @error('site_name') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Site Tagline
                            </label>
                            <input type="text" wire:model="site_tagline"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            @error('site_tagline') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SEO Title (60-70 characters recommended)
                            </label>
                            <input type="text" wire:model="seo_title"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                   maxlength="255">
                            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                Current length: {{ strlen($seo_title ?? '') }} characters
                            </p>
                            @error('seo_title') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SEO Meta Description (150-160 characters recommended)
                            </label>
                            <textarea wire:model="seo_description" rows="3"
                                      class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                      maxlength="500"></textarea>
                            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                Current length: {{ strlen($seo_description ?? '') }} characters
                            </p>
                            @error('seo_description') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                SEO Keywords (comma-separated)
                            </label>
                            <textarea wire:model="seo_keywords" rows="2"
                                      class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                      placeholder="car rental malaysia, boat rental, houseboat rental"></textarea>
                            @error('seo_keywords') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>

                <!-- Analytics & Verification -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Analytics & Verification</h3>

                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Google Analytics ID (e.g., G-XXXXXXXXXX or UA-XXXXXXXXX-X)
                            </label>
                            <input type="text" wire:model="google_analytics_id"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                   placeholder="G-XXXXXXXXXX">
                            @error('google_analytics_id') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Google Site Verification Code
                            </label>
                            <input type="text" wire:model="google_site_verification"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                   placeholder="Enter verification meta tag content">
                            @error('google_site_verification') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Get this from Google Search Console</p>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Facebook App ID
                            </label>
                            <input type="text" wire:model="facebook_app_id"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                   placeholder="Enter Facebook App ID">
                            @error('facebook_app_id') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">For Facebook Insights and sharing</p>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Twitter Handle (without @)
                            </label>
                            <input type="text" wire:model="twitter_handle"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                   placeholder="gengsewa">
                            @error('twitter_handle') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">For Twitter Card metadata</p>
                        </div>
                    </div>
                </div>

            </div>

            <!-- RIGHT COLUMN -->
            <div class="space-y-6">

                <!-- Images & Branding -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Images & Branding</h3>

                    <div class="space-y-6">
                        <!-- Logo -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Site Logo (Recommended: PNG with transparent background)
                            </label>
                            @if($site_logo)
                                <div class="mb-2">
                                    <img src="{{ asset($site_logo) }}" alt="Current Logo" class="h-16 mb-2 bg-gray-100 dark:bg-gray-700 p-2 rounded">
                                    <p class="text-sm text-gray-500 dark:text-gray-400">Current logo</p>
                                </div>
                            @endif
                            <input type="file" wire:model="new_logo" accept="image/*"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                            @error('new_logo') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Max size: 2MB</p>
                        </div>

                        <!-- Favicon -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Favicon (16x16 or 32x32 pixels, ICO or PNG)
                            </label>
                            @if($site_favicon)
                                <div class="mb-2">
                                    <img src="{{ asset($site_favicon) }}" alt="Current Favicon" class="h-8 mb-2 bg-gray-100 dark:bg-gray-700 p-2 rounded">
                                    <p class="text-sm text-gray-500 dark:text-gray-400">Current favicon</p>
                                </div>
                            @endif
                            <input type="file" wire:model="new_favicon" accept="image/x-icon,image/png"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                            @error('new_favicon') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Max size: 1MB</p>
                        </div>

                        <!-- OG Image -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Open Graph Image (Recommended: 1200x630 pixels for social sharing)
                            </label>
                            @if($og_image)
                                <div class="mb-2">
                                    <img src="{{ asset($og_image) }}" alt="Current OG Image" class="h-32 mb-2 bg-gray-100 dark:bg-gray-700 p-2 rounded">
                                    <p class="text-sm text-gray-500 dark:text-gray-400">Current OG image</p>
                                </div>
                            @endif
                            <input type="file" wire:model="new_og_image" accept="image/*"
                                   class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                            @error('new_og_image') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Max size: 2MB. Used when sharing links on Facebook, Twitter, LinkedIn, etc.</p>
                        </div>
                    </div>
                </div>

                <!-- Theme & Display Settings -->
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Theme & Display Settings</h3>

                    <div class="space-y-6">
                        <!-- Logo Display Mode -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                                Header Logo Display
                            </label>
                            <div class="space-y-2">
                                <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 transition">
                                    <input type="radio" name="logo_display_mode" wire:model.live="logo_display_mode" value="both" class="text-blue-600 focus:ring-blue-500">
                                    <span class="ml-3 text-gray-900 dark:text-white">
                                        <strong>Logo + Site Name</strong> - Display both logo and site name
                                    </span>
                                </label>
                                <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 transition">
                                    <input type="radio" name="logo_display_mode" wire:model.live="logo_display_mode" value="logo_only" class="text-blue-600 focus:ring-blue-500">
                                    <span class="ml-3 text-gray-900 dark:text-white">
                                        <strong>Logo Only</strong> - Display only the logo
                                    </span>
                                </label>
                                <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 transition">
                                    <input type="radio" name="logo_display_mode" wire:model.live="logo_display_mode" value="name_only" class="text-blue-600 focus:ring-blue-500">
                                    <span class="ml-3 text-gray-900 dark:text-white">
                                        <strong>Site Name Only</strong> - Display only the site name
                                    </span>
                                </label>
                            </div>
                            @error('logo_display_mode') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        </div>

                        <!-- Theme Mode -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                                Color Theme
                            </label>
                            <div class="space-y-2">
                                <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 transition">
                                    <input type="radio" name="theme_mode" wire:model.live="theme_mode" value="system" class="text-blue-600 focus:ring-blue-500">
                                    <span class="ml-3 text-gray-900 dark:text-white">
                                        <strong>System Default</strong> - Follow user's system preference
                                    </span>
                                </label>
                                <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 transition">
                                    <input type="radio" name="theme_mode" wire:model.live="theme_mode" value="dark" class="text-blue-600 focus:ring-blue-500">
                                    <span class="ml-3 text-gray-900 dark:text-white">
                                        <strong>Dark Theme</strong> - Always use dark theme
                                    </span>
                                </label>
                                <label class="flex items-center p-3 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer hover:bg-gray-50 dark:hover:bg-gray-700 transition">
                                    <input type="radio" name="theme_mode" wire:model.live="theme_mode" value="custom" class="text-blue-600 focus:ring-blue-500">
                                    <span class="ml-3 text-gray-900 dark:text-white">
                                        <strong>Custom Theme</strong> - Use custom color matching your brand
                                    </span>
                                </label>
                            </div>
                            @error('theme_mode') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        </div>

                        <!-- Custom Primary Color -->
                        @if($theme_mode === 'custom')
                        <div class="p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                                Brand Primary Color
                            </label>
                            <div class="flex items-center gap-4">
                                <input type="color" wire:model.live="custom_primary_color" class="h-12 w-20 rounded cursor-pointer border-2 border-gray-300 dark:border-gray-600">
                                <div class="flex-1">
                                    <input type="text" wire:model.live="custom_primary_color"
                                           class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 font-mono"
                                           placeholder="#6366f1" pattern="^#[0-9A-Fa-f]{6}$">
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Choose a color that matches your brand. The system will automatically generate matching shades.</p>
                                </div>
                            </div>
                            @error('custom_primary_color') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror

                            <!-- Color Preview -->
                            <div class="mt-4">
                                <p class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Color Preview:</p>
                                <div class="grid grid-cols-10 gap-1">
                                    @php
                                        $hex = str_replace('#', '', $custom_primary_color);
                                        $r = hexdec(substr($hex, 0, 2));
                                        $g = hexdec(substr($hex, 2, 2));
                                        $b = hexdec(substr($hex, 4, 2));

                                        function adjustBrightness($r, $g, $b, $percent) {
                                            if ($percent > 0) {
                                                $r = round($r + (255 - $r) * $percent);
                                                $g = round($g + (255 - $g) * $percent);
                                                $b = round($b + (255 - $b) * $percent);
                                            } else {
                                                $r = round($r * (1 + $percent));
                                                $g = round($g * (1 + $percent));
                                                $b = round($b * (1 + $percent));
                                            }
                                            $r = max(0, min(255, $r));
                                            $g = max(0, min(255, $g));
                                            $b = max(0, min(255, $b));
                                            return sprintf('#%02x%02x%02x', $r, $g, $b);
                                        }

                                        $shades = [
                                            adjustBrightness($r, $g, $b, 0.95),
                                            adjustBrightness($r, $g, $b, 0.90),
                                            adjustBrightness($r, $g, $b, 0.75),
                                            adjustBrightness($r, $g, $b, 0.60),
                                            adjustBrightness($r, $g, $b, 0.40),
                                            $custom_primary_color,
                                            adjustBrightness($r, $g, $b, -0.10),
                                            adjustBrightness($r, $g, $b, -0.25),
                                            adjustBrightness($r, $g, $b, -0.40),
                                            adjustBrightness($r, $g, $b, -0.55),
                                        ];
                                    @endphp
                                    @foreach($shades as $index => $shade)
                                        <div class="h-10 rounded" style="background-color: {{ $shade }}" title="{{ ['50', '100', '200', '300', '400', '500', '600', '700', '800', '900'][$index] }}"></div>
                                    @endforeach
                                </div>
                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">These color shades will be automatically applied throughout your site</p>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>

            </div>
        </div>

        <!-- Full Width Sections Below -->

        <!-- Footer Settings -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Footer Settings</h3>

            <div class="space-y-6">
                <!-- Copyright Text with HTML Support -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Copyright Text (HTML supported)
                    </label>
                    <textarea wire:model="footer_copyright_text" rows="3"
                              class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent font-mono text-sm"
                              placeholder="© 2025 GengSewa. All rights reserved."></textarea>
                    @error('footer_copyright_text') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                        Supports HTML formatting: &lt;a&gt;, &lt;strong&gt;, &lt;em&gt;, &lt;br&gt;, etc.
                    </p>
                </div>

                <!-- URL Slugs -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Privacy Policy URL Slug
                        </label>
                        <input type="text" wire:model="privacy_policy_slug"
                               class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                               placeholder="/privacy-policy">
                        @error('privacy_policy_slug') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Terms and Conditions URL Slug
                        </label>
                        <input type="text" wire:model="terms_conditions_slug"
                               class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                               placeholder="/terms-and-conditions">
                        @error('terms_conditions_slug') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Advertise URL Slug
                        </label>
                        <input type="text" wire:model="advertise_slug"
                               class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                               placeholder="/advertise">
                        @error('advertise_slug') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            About Us URL Slug
                        </label>
                        <input type="text" wire:model="about_us_slug"
                               class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                               placeholder="/about-us">
                        @error('about_us_slug') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Sponsor/Partnership Logos -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                    <div class="flex justify-between items-center mb-4">
                        <div>
                            <h4 class="text-lg font-semibold text-gray-900 dark:text-gray-100">Sponsor/Partnership Logos</h4>
                            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Upload logos of your sponsors, partners, or brands for recognition in the footer.</p>
                        </div>
                        <a href="{{ route('admin.custom-pages') }}" class="px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-semibold rounded-md transition inline-flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                            </svg>
                            Manage Custom Pages
                        </a>
                    </div>

                    <!-- Existing Logos -->
                    @if(count($footer_sponsor_logos) > 0)
                        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4 mb-4">
                            @foreach($footer_sponsor_logos as $index => $logo)
                                <div class="relative group border border-gray-200 dark:border-gray-600 rounded-lg p-3 bg-gray-50 dark:bg-gray-700">
                                    <img src="{{ asset($logo) }}" alt="Sponsor Logo" class="w-full h-20 object-contain">
                                    <button type="button" wire:click="removeSponsorLogo({{ $index }})"
                                            class="absolute top-1 right-1 bg-red-600 hover:bg-red-700 text-white rounded-full p-1 opacity-0 group-hover:opacity-100 transition-opacity">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                        </svg>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <!-- Upload New Logo -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Add New Sponsor Logo
                        </label>
                        <input type="file" wire:model="new_sponsor_logo" accept="image/*"
                               class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                        @error('new_sponsor_logo') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Max size: 2MB. Logos will be displayed in the footer section.</p>
                    </div>
                </div>
            </div>

            <!-- Footer Preview -->
            <div class="mt-6 p-4 bg-gray-50 dark:bg-gray-900 border border-gray-200 dark:border-gray-600 rounded-lg">
                <p class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">Footer Preview:</p>

                <!-- Sponsor Logos Preview -->
                @if(count($footer_sponsor_logos) > 0)
                    <div class="mb-4 pb-4 border-b border-gray-200 dark:border-gray-700">
                        <p class="text-xs text-gray-500 dark:text-gray-400 mb-2">Sponsors & Partners</p>
                        <div class="flex flex-wrap justify-center gap-4">
                            @foreach($footer_sponsor_logos as $logo)
                                <img src="{{ asset($logo) }}" alt="Sponsor" class="h-12 object-contain opacity-70">
                            @endforeach
                        </div>
                    </div>
                @endif

                <div class="text-sm text-gray-600 dark:text-gray-400 text-center">
                    <div class="mb-2">{!! $footer_copyright_text !!}</div>
                    <div class="flex flex-wrap justify-center gap-3 text-xs">
                        <span class="text-blue-600 dark:text-blue-400 hover:underline cursor-pointer">About Us</span>
                        <span class="text-gray-400">•</span>
                        <span class="text-blue-600 dark:text-blue-400 hover:underline cursor-pointer">Our Services</span>
                        <span class="text-gray-400">•</span>
                        <span class="text-blue-600 dark:text-blue-400 hover:underline cursor-pointer">Privacy Policy</span>
                        <span class="text-gray-400">•</span>
                        <span class="text-blue-600 dark:text-blue-400 hover:underline cursor-pointer">Terms and Conditions</span>
                        @php
                            $customPages = \App\Models\CustomPage::where('is_active', true)->where('show_in_footer', true)->orderBy('order')->get();
                        @endphp
                        @foreach($customPages as $page)
                            <span class="text-gray-400">•</span>
                            <span class="text-blue-600 dark:text-blue-400 hover:underline cursor-pointer">{{ $page->title }}</span>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- Privacy Policy Content -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Privacy Policy Content</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Write or edit your privacy policy. This will be displayed on your privacy policy page.</p>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Privacy Policy (HTML supported)
                </label>
                <textarea wire:model="privacy_policy_content" rows="8"
                          class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent font-mono text-sm"
                          placeholder="Enter your privacy policy content here. You can use HTML tags for formatting."></textarea>
                @error('privacy_policy_content') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    Supports HTML formatting: &lt;h1&gt;, &lt;h2&gt;, &lt;p&gt;, &lt;ul&gt;, &lt;ol&gt;, &lt;strong&gt;, &lt;em&gt;, etc.
                </p>
            </div>
        </div>

        <!-- Terms and Conditions Content -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Terms and Conditions Content</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Write or edit your terms and conditions. This will be displayed on your terms and conditions page.</p>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Terms and Conditions (HTML supported)
                </label>
                <textarea wire:model="terms_conditions_content" rows="8"
                          class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent font-mono text-sm"
                          placeholder="Enter your terms and conditions content here. You can use HTML tags for formatting."></textarea>
                @error('terms_conditions_content') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    Supports HTML formatting: &lt;h1&gt;, &lt;h2&gt;, &lt;p&gt;, &lt;ul&gt;, &lt;ol&gt;, &lt;strong&gt;, &lt;em&gt;, etc.
                </p>
            </div>
        </div>

        <!-- Our Services Content -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Our Services Content</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Write or edit your Our Services page content. Explain Our Services options, featured listing benefits, durations, and fees.</p>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Our Services (HTML supported)
                </label>
                <textarea wire:model="advertise_content" rows="8"
                          class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent font-mono text-sm"
                          placeholder="Enter your Our Services page content. Include information about Our Servicess, featured listing options (1 month, 3 month, 6 month, yearly), and associated fees."></textarea>
                @error('advertise_content') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    Supports HTML formatting: &lt;h1&gt;, &lt;h2&gt;, &lt;p&gt;, &lt;ul&gt;, &lt;ol&gt;, &lt;strong&gt;, &lt;em&gt;, etc.
                </p>
            </div>
        </div>

        <!-- About Us Content -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">About Us Content</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Write or edit your about us page content. Tell your story, mission, and what makes your platform unique.</p>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    About Us (HTML supported)
                </label>
                <textarea wire:model="about_us_content" rows="8"
                          class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent font-mono text-sm"
                          placeholder="Enter your about us page content. Share your company story, mission, values, and team information."></textarea>
                @error('about_us_content') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    Supports HTML formatting: &lt;h1&gt;, &lt;h2&gt;, &lt;p&gt;, &lt;ul&gt;, &lt;ol&gt;, &lt;strong&gt;, &lt;em&gt;, etc.
                </p>
            </div>
        </div>

        <!-- SEO Tips -->
        <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-6">
            <h3 class="text-lg font-semibold text-blue-900 dark:text-blue-100 mb-3">SEO Tips for Better Rankings</h3>
            <ul class="grid grid-cols-1 md:grid-cols-2 gap-3 text-sm text-blue-800 dark:text-blue-200">
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    <span><strong>Title:</strong> Keep it under 60 characters and include your main keyword</span>
                </li>
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    <span><strong>Description:</strong> Write compelling 150-160 character description with keywords</span>
                </li>
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    <span><strong>Keywords:</strong> Focus on 5-10 relevant keywords, include location-based keywords</span>
                </li>
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    <span><strong>OG Image:</strong> Use high-quality 1200x630px image for social media sharing</span>
                </li>
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    <span><strong>Analytics:</strong> Track with Google Analytics to understand user behavior</span>
                </li>
                <li class="flex items-start">
                    <svg class="w-5 h-5 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    <span><strong>Verification:</strong> Submit sitemap to Google Search Console for better indexing</span>
                </li>
            </ul>
        </div>

        <!-- Save Button -->
        <div class="flex justify-end">
            <button type="submit"
                    class="px-6 py-3 bg-blue-600 hover:bg-blue-700 dark:bg-blue-500 dark:hover:bg-blue-600 text-white font-semibold rounded-md transition">
                Save SEO Settings
            </button>
        </div>
    </form>
</div>

<script>
// Live theme preview
document.addEventListener('DOMContentLoaded', function() {
    // Listen for theme mode changes
    const themeRadios = document.querySelectorAll('input[name="theme_mode"]');
    themeRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            const themeMode = this.value;
            applyThemePreview(themeMode);
        });
    });

    // Listen for Livewire updates (when color changes via wire:model.live)
    window.addEventListener('livewire:update', function() {
        const checkedTheme = document.querySelector('input[name="theme_mode"]:checked');
        if (checkedTheme && checkedTheme.value === 'custom') {
            applyThemePreview('custom');
        }
    });
});

function applyThemePreview(themeMode) {
    const html = document.documentElement;

    if (themeMode === 'dark') {
        html.classList.add('dark');
        html.classList.remove('custom');
    } else if (themeMode === 'custom') {
        html.classList.add('custom');
        html.classList.remove('dark');

        // Inject or update custom theme CSS
        injectCustomThemeCSS();
    } else {
        // System default
        html.classList.remove('custom');
        if (window.matchMedia('(prefers-color-scheme: dark)').matches) {
            html.classList.add('dark');
        } else {
            html.classList.remove('dark');
        }
    }
}

function injectCustomThemeCSS() {
    // Get the current custom color from the page
    const customColor = document.querySelector('input[wire\\:model\\.live="custom_primary_color"]')?.value || '#6366f1';

    // Check if style element already exists
    let styleElement = document.getElementById('custom-theme-preview');
    if (!styleElement) {
        styleElement = document.createElement('style');
        styleElement.id = 'custom-theme-preview';
        document.head.appendChild(styleElement);
    }

    // Generate color shades
    const shades = generateColorShades(customColor);

    // Generate CSS
    const css = `
:root {
    --color-primary-50: ${shades[0]};
    --color-primary-100: ${shades[1]};
    --color-primary-200: ${shades[2]};
    --color-primary-300: ${shades[3]};
    --color-primary-400: ${shades[4]};
    --color-primary-500: ${shades[5]};
    --color-primary-600: ${shades[6]};
    --color-primary-700: ${shades[7]};
    --color-primary-800: ${shades[8]};
    --color-primary-900: ${shades[9]};
}

.custom { background-color: #ffffff; color: #1f2937; }
.custom .bg-gray-50 { background-color: ${shades[0]} !important; }
.custom .bg-gray-100 { background-color: ${shades[1]} !important; }
.custom .bg-white { background-color: #ffffff !important; }
.custom .bg-blue-600, .custom .bg-indigo-600, .custom .bg-purple-600 { background-color: ${shades[6]} !important; }
.custom .bg-blue-700, .custom .bg-indigo-700, .custom .bg-purple-700 { background-color: ${shades[7]} !important; }
.custom .bg-blue-100 { background-color: ${shades[1]} !important; }
.custom .text-blue-600, .custom .text-indigo-600, .custom .text-purple-600 { color: ${shades[6]} !important; }
.custom .text-blue-700, .custom .text-indigo-700 { color: ${shades[7]} !important; }
.custom .text-blue-800, .custom .text-indigo-800 { color: ${shades[8]} !important; }
.custom .border-blue-600, .custom .border-indigo-600 { border-color: ${shades[6]} !important; }
.custom .from-blue-600 { --tw-gradient-from: ${shades[6]} !important; }
.custom .via-purple-600 { --tw-gradient-via: ${shades[6]} !important; }
.custom .to-indigo-700 { --tw-gradient-to: ${shades[7]} !important; }
.custom .hover\\:from-blue-700:hover { --tw-gradient-from: ${shades[7]} !important; }
.custom .hover\\:to-purple-700:hover { --tw-gradient-to: ${shades[7]} !important; }
.custom .focus\\:border-blue-500:focus { border-color: ${shades[5]} !important; }
.custom .focus\\:ring-blue-500:focus { --tw-ring-color: ${shades[5]} !important; }
.custom .hover\\:bg-blue-700:hover { background-color: ${shades[7]} !important; }
`;

    styleElement.textContent = css;
}

function generateColorShades(hexColor) {
    const hex = hexColor.replace('#', '');
    const r = parseInt(hex.substr(0, 2), 16);
    const g = parseInt(hex.substr(2, 2), 16);
    const b = parseInt(hex.substr(4, 2), 16);

    function adjustBrightness(r, g, b, percent) {
        if (percent > 0) {
            r = Math.round(r + (255 - r) * percent);
            g = Math.round(g + (255 - g) * percent);
            b = Math.round(b + (255 - b) * percent);
        } else {
            r = Math.round(r * (1 + percent));
            g = Math.round(g * (1 + percent));
            b = Math.round(b * (1 + percent));
        }
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        return `#${r.toString(16).padStart(2, '0')}${g.toString(16).padStart(2, '0')}${b.toString(16).padStart(2, '0')}`;
    }

    return [
        adjustBrightness(r, g, b, 0.95),
        adjustBrightness(r, g, b, 0.90),
        adjustBrightness(r, g, b, 0.75),
        adjustBrightness(r, g, b, 0.60),
        adjustBrightness(r, g, b, 0.40),
        hexColor,
        adjustBrightness(r, g, b, -0.10),
        adjustBrightness(r, g, b, -0.25),
        adjustBrightness(r, g, b, -0.40),
        adjustBrightness(r, g, b, -0.55),
    ];
}

// Initialize on page load
window.addEventListener('load', function() {
    const checkedTheme = document.querySelector('input[name="theme_mode"]:checked');
    if (checkedTheme && checkedTheme.value === 'custom') {
        applyThemePreview('custom');
    }
});
</script>
