<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Platform Settings</h1>
        <p class="text-gray-600 dark:text-gray-400 mt-2">Configure email settings and customize email templates</p>
    </div>

    <!-- Settings Navigation Tabs -->
    <div class="mb-8 border-b border-gray-200 dark:border-gray-700">
        <nav class="-mb-px flex space-x-8 overflow-x-auto">
            <a href="{{ route('admin.settings') }}" class="border-transparent text-gray-500 dark:text-gray-400 hover:border-gray-300 dark:hover:border-gray-600 hover:text-gray-700 dark:hover:text-gray-300 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                Payment & Fees
            </a>
            <a href="{{ route('admin.seo') }}" class="border-transparent text-gray-500 dark:text-gray-400 hover:border-gray-300 dark:hover:border-gray-600 hover:text-gray-700 dark:hover:text-gray-300 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                SEO & Branding
            </a>
            <a href="{{ route('admin.email-templates') }}" class="border-indigo-600 dark:border-indigo-400 text-indigo-600 dark:text-indigo-400 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium">
                Email Templates
            </a>
        </nav>
    </div>

    <div>
        <!-- Email/SMTP Configuration Section -->
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg mb-6">
            <div class="p-6">
                <div class="flex items-center mb-6">
                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Email / SMTP Configuration</h2>
                </div>

                @if (session()->has('email_success'))
                    <div class="mb-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-200 px-4 py-3 rounded relative">
                        {{ session('email_success') }}
                    </div>
                @endif

                <form wire:submit.prevent="saveEmailSettings">
                    <div class="space-y-6">
                        <!-- Mail Driver Selection -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Email Driver <span class="text-red-500">*</span>
                            </label>
                            <select wire:model.live="mail_mailer"
                                class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="log">Log (Local Development)</option>
                                <option value="smtp">SMTP</option>
                                <option value="ses">AWS SES</option>
                            </select>
                            @error('mail_mailer') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                        </div>

                        <!-- SMTP Settings -->
                        @if($mail_mailer === 'smtp')
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 p-4 bg-gray-50 dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-700">
                                <div class="md:col-span-2">
                                    <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3">SMTP Configuration</h3>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        SMTP Host <span class="text-red-500">*</span>
                                    </label>
                                    <input type="text" wire:model="mail_host"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="smtp.gmail.com">
                                    @error('mail_host') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        SMTP Port <span class="text-red-500">*</span>
                                    </label>
                                    <input type="number" wire:model="mail_port"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="587">
                                    @error('mail_port') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        SMTP Username
                                    </label>
                                    <input type="text" wire:model="mail_username"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="your-email@gmail.com">
                                    @error('mail_username') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        SMTP Password
                                    </label>
                                    <input type="password" wire:model="mail_password"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="your-smtp-password">
                                    @error('mail_password') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <div class="md:col-span-2">
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        Encryption
                                    </label>
                                    <select wire:model="mail_encryption"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                        <option value="tls">TLS (Recommended)</option>
                                        <option value="ssl">SSL</option>
                                    </select>
                                    @error('mail_encryption') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        @endif

                        <!-- AWS SES Settings -->
                        @if($mail_mailer === 'ses')
                            <div class="grid grid-cols-1 gap-4 p-4 bg-orange-50 dark:bg-orange-900/20 rounded-lg border border-orange-200 dark:border-orange-800">
                                <div>
                                    <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3">AWS SES Configuration</h3>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        AWS Access Key ID <span class="text-red-500">*</span>
                                    </label>
                                    <input type="text" wire:model="aws_access_key_id"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="AKIA...">
                                    @error('aws_access_key_id') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        AWS Secret Access Key <span class="text-red-500">*</span>
                                    </label>
                                    <input type="password" wire:model="aws_secret_access_key"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="Enter your AWS Secret Key">
                                    @error('aws_secret_access_key') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        AWS Default Region <span class="text-red-500">*</span>
                                    </label>
                                    <select wire:model="aws_default_region"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                        <option value="us-east-1">US East (N. Virginia) - us-east-1</option>
                                        <option value="us-west-2">US West (Oregon) - us-west-2</option>
                                        <option value="eu-west-1">EU (Ireland) - eu-west-1</option>
                                        <option value="ap-southeast-1">Asia Pacific (Singapore) - ap-southeast-1</option>
                                        <option value="ap-northeast-1">Asia Pacific (Tokyo) - ap-northeast-1</option>
                                    </select>
                                    @error('aws_default_region') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        @endif

                        <!-- From Address & Name -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    From Email Address <span class="text-red-500">*</span>
                                </label>
                                <input type="email" wire:model="mail_from_address"
                                    class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    placeholder="noreply@yourdomain.com">
                                @error('mail_from_address') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    From Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" wire:model="mail_from_name"
                                    class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    placeholder="GengSewa">
                                @error('mail_from_name') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                            </div>
                        </div>

                        <div class="pt-4">
                            <button type="submit"
                                class="w-full bg-blue-600 hover:bg-blue-700 dark:bg-blue-500 dark:hover:bg-blue-600 text-white font-semibold py-3 px-6 rounded-md transition">
                                Save Email Settings
                            </button>
                        </div>

                        <!-- Email Branding Settings -->
                        <div class="pt-6 mt-6 border-t border-gray-200 dark:border-gray-700">
                            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Email Branding</h3>

                            <div class="space-y-4">
                                <!-- Logo URL -->
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        Email Logo URL
                                    </label>
                                    <input type="url" wire:model="email_logo_url"
                                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                        placeholder="https://yourdomain.com/logo.png">
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Full URL to your logo image (PNG or JPG, max 150px height recommended)</p>
                                    @error('email_logo_url') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                </div>

                                <!-- Color Settings -->
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                            Primary Color (Headers)
                                        </label>
                                        <div class="flex items-center gap-3">
                                            <input type="color" wire:model.live="email_primary_color"
                                                class="h-10 w-20 rounded cursor-pointer border-2 border-gray-300 dark:border-gray-600">
                                            <input type="text" wire:model.live="email_primary_color"
                                                class="flex-1 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500 font-mono"
                                                placeholder="#667eea">
                                        </div>
                                        @error('email_primary_color') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                    </div>

                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                            Secondary Color (Gradient)
                                        </label>
                                        <div class="flex items-center gap-3">
                                            <input type="color" wire:model.live="email_secondary_color"
                                                class="h-10 w-20 rounded cursor-pointer border-2 border-gray-300 dark:border-gray-600">
                                            <input type="text" wire:model.live="email_secondary_color"
                                                class="flex-1 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500 font-mono"
                                                placeholder="#764ba2">
                                        </div>
                                        @error('email_secondary_color') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                                    </div>
                                </div>

                                <!-- Color Preview -->
                                <div class="p-4 rounded-lg" style="background: linear-gradient(135deg, {{ $email_primary_color }} 0%, {{ $email_secondary_color }} 100%);">
                                    <p class="text-white font-semibold text-center">Email Header Preview</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                <div class="mt-6 p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 mt-0.5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                        </svg>
                        <div class="text-sm text-blue-800 dark:text-blue-300">
                            <p class="font-semibold mb-1">Email Configuration Note</p>
                            <p><strong>Log:</strong> For local development - emails are written to storage/logs/laravel.log (no actual emails sent).</p>
                            <p class="mt-1"><strong>SMTP:</strong> Configure your mail server credentials. Supports Gmail, Mailgun, SendGrid, etc.</p>
                            <p class="mt-1"><strong>AWS SES:</strong> Amazon Simple Email Service - requires verified email/domain in AWS Console.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Email Templates Section -->
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6">
                <!-- Header -->
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Email Templates</h2>
                </div>

                <!-- Success Message -->
                @if (session()->has('success'))
                    <div class="mb-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-200 px-4 py-3 rounded relative">
                        {{ session('success') }}
                    </div>
                @endif

                <!-- Templates List -->
                <div class="grid gap-6 md:grid-cols-2">
                    @foreach($templates as $template)
                        <div class="border border-gray-200 dark:border-gray-700 rounded-lg p-6 {{ $template->enabled ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}">
                            <div class="flex justify-between items-start mb-4">
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                                        {{ $this->getTemplateName($template->name) }}
                                    </h3>
                                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                        {{ $template->subject }}
                                    </p>
                                </div>
                                <div class="flex items-center gap-2">
                                    <!-- Enable/Disable Toggle -->
                                    <button
                                        wire:click="toggleEnabled({{ $template->id }})"
                                        class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 {{ $template->enabled ? 'bg-blue-600' : 'bg-gray-200 dark:bg-gray-700' }}"
                                    >
                                        <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform {{ $template->enabled ? 'translate-x-6' : 'translate-x-1' }}"></span>
                                    </button>
                                    <span class="text-sm {{ $template->enabled ? 'text-green-600 dark:text-green-400' : 'text-gray-500 dark:text-gray-400' }}">
                                        {{ $template->enabled ? 'Enabled' : 'Disabled' }}
                                    </span>
                                </div>
                            </div>

                            <!-- Available Placeholders -->
                            <div class="mb-4">
                                <p class="text-xs font-semibold text-gray-700 dark:text-gray-300 mb-1">Available Placeholders:</p>
                                <p class="text-xs text-gray-600 dark:text-gray-400 font-mono bg-gray-100 dark:bg-gray-900 p-2 rounded">
                                    {{ $this->getPlaceholders($template->name) }}
                                </p>
                            </div>

                            <!-- Action Buttons -->
                            <div class="grid grid-cols-2 gap-2">
                                <button
                                    wire:click="previewTemplate({{ $template->id }})"
                                    class="w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-2 px-4 rounded-lg transition">
                                    Preview
                                </button>
                                <button
                                    wire:click="editTemplate({{ $template->id }})"
                                    class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition">
                                    Edit Template
                                </button>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    @if($showEditModal)
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity z-50" wire:click="closeModal"></div>

        <div class="fixed inset-0 z-50 overflow-y-auto">
            <div class="flex min-h-full items-center justify-center p-4">
                <div class="relative bg-white dark:bg-gray-800 rounded-lg shadow-xl w-full max-w-4xl" @click.stop>
                    <!-- Modal Header -->
                    <div class="bg-gradient-to-r from-blue-600 to-purple-600 px-6 py-4 rounded-t-lg">
                        <h3 class="text-xl font-semibold text-white">
                            Edit {{ $this->getTemplateName($name) }}
                        </h3>
                    </div>

                    <!-- Modal Body -->
                    <div class="p-6 max-h-[70vh] overflow-y-auto">
                        <form wire:submit.prevent="saveTemplate">
                            <!-- Subject -->
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Email Subject
                                </label>
                                <input
                                    type="text"
                                    wire:model="subject"
                                    class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white"
                                    placeholder="Enter email subject"
                                >
                                @error('subject')
                                    <span class="text-red-500 text-sm">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Body -->
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                    Email Body
                                </label>

                                <!-- Tab Buttons -->
                                <div class="flex border-b border-gray-300 dark:border-gray-600 mb-2">
                                    <button type="button" onclick="showVisualEditor()" id="visualTab"
                                        class="px-4 py-2 text-sm font-medium text-blue-600 dark:text-blue-400 border-b-2 border-blue-600 dark:border-blue-400">
                                        Visual Editor
                                    </button>
                                    <button type="button" onclick="showHtmlEditor()" id="htmlTab"
                                        class="px-4 py-2 text-sm font-medium text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-300">
                                        HTML Code
                                    </button>
                                </div>

                                <!-- Visual Editor (TinyMCE) -->
                                <div id="visualEditor">
                                    <textarea id="tinymceEditor" wire:model="body"></textarea>
                                </div>

                                <!-- HTML Editor -->
                                <div id="htmlEditor" style="display: none;">
                                    <textarea
                                        wire:model="body"
                                        rows="15"
                                        class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white font-mono text-sm"
                                        placeholder="Enter HTML email template"
                                    ></textarea>
                                </div>

                                @error('body')
                                    <span class="text-red-500 text-sm">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Available Placeholders Info -->
                            <div class="mb-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                                <p class="text-sm font-semibold text-blue-900 dark:text-blue-300 mb-2">
                                    📌 Available Placeholders:
                                </p>
                                <p class="text-xs text-blue-800 dark:text-blue-400 font-mono">
                                    {{ $this->getPlaceholders($name) }}
                                </p>
                            </div>

                            <!-- Enabled Checkbox -->
                            <div class="mb-6">
                                <label class="flex items-center cursor-pointer">
                                    <input
                                        type="checkbox"
                                        wire:model="enabled"
                                        class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500"
                                    >
                                    <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">
                                        Enable this email template
                                    </span>
                                </label>
                            </div>

                            <!-- Buttons -->
                            <div class="flex justify-end gap-3">
                                <button
                                    type="button"
                                    wire:click="closeModal"
                                    class="px-6 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-300 dark:hover:bg-gray-600 transition"
                                >
                                    Cancel
                                </button>
                                <button
                                    type="submit"
                                    class="px-6 py-2 bg-gradient-to-r from-blue-600 to-purple-600 text-white rounded-lg hover:from-blue-700 hover:to-purple-700 transition"
                                >
                                    Save Changes
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Preview Modal -->
    @if($showPreviewModal)
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity z-50" wire:click="closeModal"></div>

        <div class="fixed inset-0 z-50 overflow-y-auto">
            <div class="flex min-h-full items-center justify-center p-4">
                <div class="relative bg-white dark:bg-gray-800 rounded-lg shadow-xl w-full max-w-5xl" @click.stop>
                    <!-- Modal Header -->
                    <div class="bg-gradient-to-r from-green-600 to-teal-600 px-6 py-4 rounded-t-lg">
                        <h3 class="text-xl font-semibold text-white">
                            📧 Email Preview: {{ $this->getTemplateName($name) }}
                        </h3>
                        <p class="text-sm text-green-100 mt-1">This is how your email will appear to recipients</p>
                    </div>

                    <!-- Modal Body -->
                    <div class="max-h-[80vh] overflow-y-auto">
                        <!-- Email Header (like email client) -->
                        <div class="bg-gray-50 dark:bg-gray-900 border-b border-gray-200 dark:border-gray-700 p-6">
                            <div class="max-w-3xl mx-auto">
                                <div class="flex items-center justify-between mb-3">
                                    <div class="flex items-center">
                                        <div class="w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-white font-bold mr-3">
                                            {{ substr($mail_from_name ?: 'GS', 0, 2) }}
                                        </div>
                                        <div>
                                            <p class="font-semibold text-gray-900 dark:text-white">{{ $mail_from_name ?: 'GengSewa' }}</p>
                                            <p class="text-sm text-gray-500 dark:text-gray-400">{{ $mail_from_address ?: 'noreply@example.com' }}</p>
                                        </div>
                                    </div>
                                    <span class="text-xs text-gray-500 dark:text-gray-400">Just now</span>
                                </div>
                                <div class="border-l-4 border-blue-600 pl-4">
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mb-1">Subject:</p>
                                    <h2 class="text-lg font-semibold text-gray-900 dark:text-white">{{ $subject }}</h2>
                                </div>
                            </div>
                        </div>

                        <!-- Email Body (rendered HTML) -->
                        <div class="p-6 bg-white dark:bg-gray-800">
                            <div class="max-w-3xl mx-auto bg-gray-50 dark:bg-gray-900 rounded-lg shadow-inner">
                                <iframe
                                    srcdoc="{{ $body }}"
                                    class="w-full border-0 rounded-lg"
                                    style="min-height: 600px; height: auto;"
                                    onload="this.style.height = (this.contentWindow.document.documentElement.scrollHeight + 40) + 'px';"
                                    sandbox="allow-same-origin"
                                ></iframe>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="bg-gray-50 dark:bg-gray-900 border-t border-gray-200 dark:border-gray-700 px-6 py-4">
                            <div class="max-w-3xl mx-auto flex justify-between items-center">
                                <p class="text-sm text-gray-500 dark:text-gray-400">
                                    💡 This is a preview. Actual emails may vary slightly based on email client.
                                </p>
                                <button
                                    type="button"
                                    wire:click="closeModal"
                                    class="px-6 py-2 bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-lg hover:from-green-700 hover:to-teal-700 transition font-semibold"
                                >
                                    Close Preview
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
    </div>
</div>

<!-- TinyMCE Self-Hosted -->
<script src="{{ asset('vendor/tinymce/tinymce.min.js') }}"></script>

<script>
let editorInitialized = false;

// Watch for showEditModal changes
window.addEventListener('livewire:init', () => {
    Livewire.on('editTemplateOpened', () => {
        editorInitialized = false;
        setTimeout(() => initTinyMCE(), 200);
    });

    Livewire.on('editorClosed', () => {
        if (tinymce.get('tinymceEditor')) {
            tinymce.get('tinymceEditor').remove();
        }
        editorInitialized = false;
    });
});

function initTinyMCE() {
    const editorElement = document.getElementById('tinymceEditor');
    if (!editorElement || editorInitialized) return;

    // Remove existing instance if any
    if (tinymce.get('tinymceEditor')) {
        tinymce.get('tinymceEditor').remove();
    }

    editorInitialized = true;

    tinymce.init({
        selector: '#tinymceEditor',
        license_key: 'gpl',
        height: 450,
        menubar: false,
        base_url: '{{ asset("vendor/tinymce") }}',
        suffix: '.min',
        plugins: [
            'advlist', 'autolink', 'lists', 'link', 'image', 'charmap',
            'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
            'insertdatetime', 'media', 'table', 'help', 'wordcount'
        ],
        toolbar: 'undo redo | blocks | bold italic forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | removeformat | code | fullscreen | help',
        content_style: 'body { font-family:Arial,sans-serif; font-size:14px; padding: 10px; }',
        promotion: false,
        branding: false,
        setup: function (editor) {
            editor.on('init', function () {
                // Set initial content
                const bodyContent = @this.get('body') || '';
                editor.setContent(bodyContent);
            });

            editor.on('blur', function () {
                const content = editor.getContent();
                @this.set('body', content, false);
            });
        }
    });
}

function showVisualEditor() {
    document.getElementById('visualEditor').style.display = 'block';
    document.getElementById('htmlEditor').style.display = 'none';

    document.getElementById('visualTab').classList.add('text-blue-600', 'dark:text-blue-400', 'border-blue-600', 'dark:border-blue-400');
    document.getElementById('visualTab').classList.remove('text-gray-500', 'dark:text-gray-400', 'border-transparent');

    document.getElementById('htmlTab').classList.remove('text-blue-600', 'dark:text-blue-400', 'border-blue-600', 'dark:border-blue-400');
    document.getElementById('htmlTab').classList.add('text-gray-500', 'dark:text-gray-400', 'border-transparent');

    // Sync content from HTML to visual editor (without triggering Livewire update)
    if (tinymce.get('tinymceEditor')) {
        const htmlContent = document.querySelector('#htmlEditor textarea').value;
        tinymce.get('tinymceEditor').setContent(htmlContent);
    }
}

function showHtmlEditor() {
    document.getElementById('visualEditor').style.display = 'none';
    document.getElementById('htmlEditor').style.display = 'block';

    document.getElementById('htmlTab').classList.add('text-blue-600', 'dark:text-blue-400', 'border-blue-600', 'dark:border-blue-400');
    document.getElementById('htmlTab').classList.remove('text-gray-500', 'dark:text-gray-400', 'border-transparent');

    document.getElementById('visualTab').classList.remove('text-blue-600', 'dark:text-blue-400', 'border-blue-600', 'dark:border-blue-400');
    document.getElementById('visualTab').classList.add('text-gray-500', 'dark:text-gray-400', 'border-transparent');

    // Sync content from visual editor to HTML (without triggering Livewire update)
    if (tinymce.get('tinymceEditor')) {
        const visualContent = tinymce.get('tinymceEditor').getContent();
        document.querySelector('#htmlEditor textarea').value = visualContent;
    }
}
</script>
