<div class="py-12 bg-gray-50 dark:bg-gray-900 min-h-screen">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Admin Dashboard</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-2">Manage your rental platform</p>
        </div>

        <!-- Flash Message -->
        @if(session()->has('success'))
            <div class="mb-6 bg-green-100 dark:bg-green-900 border-l-4 border-green-500 text-green-700 dark:text-green-200 p-4 rounded-lg shadow-md">
                <div class="flex items-center">
                    <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <p class="font-semibold">{{ session('success') }}</p>
                </div>
            </div>
        @endif

        <!-- Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Total Users Card -->
            <div class="relative overflow-hidden bg-white dark:bg-gray-800 p-6 rounded-2xl shadow-xl border-l-8 border-blue-500 hover:shadow-2xl transition-all duration-300 transform hover:scale-105">
                <!-- Icon positioned at top right -->
                <div class="absolute top-4 right-4">
                    <div class="bg-blue-500 p-2 rounded-xl shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                    </div>
                </div>

                <div class="pr-12">
                    <div class="text-blue-600 dark:text-blue-400 text-xs font-black uppercase tracking-widest mb-2">Total Users</div>
                    <div class="text-gray-900 dark:text-white mb-2 leading-tight">
                        <div class="text-xl font-black whitespace-nowrap overflow-hidden text-ellipsis">{{ $stats['total_users'] ?? 0 }}</div>
                    </div>
                    <div class="text-gray-600 dark:text-gray-300 text-sm font-semibold">{{ $stats['total_hosts'] ?? 0 }} hosts registered</div>
                </div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-blue-500 opacity-5 rounded-tl-full"></div>
            </div>

            <!-- Total Listings Card -->
            <div class="relative overflow-hidden bg-white dark:bg-gray-800 p-6 rounded-2xl shadow-xl border-l-8 border-green-500 hover:shadow-2xl transition-all duration-300 transform hover:scale-105">
                <!-- Icon positioned at top right -->
                <div class="absolute top-4 right-4">
                    <div class="bg-green-500 p-2 rounded-xl shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                    </div>
                </div>

                <div class="pr-12">
                    <div class="text-green-600 dark:text-green-400 text-xs font-black uppercase tracking-widest mb-2">Total Listings</div>
                    <div class="text-gray-900 dark:text-white mb-2 leading-tight">
                        <div class="text-xl font-black whitespace-nowrap overflow-hidden text-ellipsis">{{ $stats['total_listings'] ?? 0 }}</div>
                    </div>
                    <div class="text-gray-600 dark:text-gray-300 text-sm font-semibold">Active rentals available</div>
                </div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-green-500 opacity-5 rounded-tl-full"></div>
            </div>

            <!-- Total Bookings Card -->
            <div class="relative overflow-hidden bg-white dark:bg-gray-800 p-6 rounded-2xl shadow-xl border-l-8 border-purple-500 hover:shadow-2xl transition-all duration-300 transform hover:scale-105">
                <!-- Icon positioned at top right -->
                <div class="absolute top-4 right-4">
                    <div class="bg-purple-500 p-2 rounded-xl shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                </div>

                <div class="pr-12">
                    <div class="text-purple-600 dark:text-purple-400 text-xs font-black uppercase tracking-widest mb-2">Total Bookings</div>
                    <div class="text-gray-900 dark:text-white mb-2 leading-tight">
                        <div class="text-xl font-black whitespace-nowrap overflow-hidden text-ellipsis">{{ $stats['total_bookings'] ?? 0 }}</div>
                    </div>
                    <div class="text-gray-600 dark:text-gray-300 text-sm font-semibold">{{ $stats['confirmed_bookings'] ?? 0 }} confirmed</div>
                </div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-purple-500 opacity-5 rounded-tl-full"></div>
            </div>

            <!-- Total Revenue Card -->
            <div class="relative overflow-hidden bg-white dark:bg-gray-800 p-6 rounded-2xl shadow-xl border-l-8 border-orange-500 hover:shadow-2xl transition-all duration-300 transform hover:scale-105">
                <!-- Icon positioned at top right -->
                <div class="absolute top-4 right-4">
                    <div class="bg-orange-500 p-2 rounded-xl shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                </div>

                <div class="pr-12">
                    <div class="text-orange-600 dark:text-orange-400 text-xs font-black uppercase tracking-widest mb-2">Total Revenue</div>
                    <div class="text-gray-900 dark:text-white mb-2 leading-tight">
                        <div class="text-xl font-black whitespace-nowrap overflow-hidden text-ellipsis">
                            RM {{ number_format($stats['total_revenue'] ?? 0, 2) }}
                        </div>
                    </div>
                    <div class="text-gray-600 dark:text-gray-300 text-sm font-semibold">From confirmed & completed</div>
                </div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-orange-500 opacity-5 rounded-tl-full"></div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="mb-8">
            <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-4">Quick Actions</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <a href="{{ route('admin.users') }}" class="group bg-white dark:bg-gray-800 p-6 rounded-xl shadow-md hover:shadow-xl transition-all duration-300 border-2 border-transparent hover:border-indigo-500">
                    <div class="flex items-center justify-between mb-3">
                        <div class="bg-indigo-100 dark:bg-indigo-900 p-3 rounded-lg group-hover:bg-indigo-500 transition-colors">
                            <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                            </svg>
                        </div>
                        <svg class="w-5 h-5 text-gray-400 dark:text-gray-500 group-hover:text-indigo-500 group-hover:translate-x-1 transition-all" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">Manage Users</h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm">View, verify and manage user accounts</p>
                </a>

                <a href="{{ route('admin.rental-types') }}" class="group bg-white dark:bg-gray-800 p-6 rounded-xl shadow-md hover:shadow-xl transition-all duration-300 border-2 border-transparent hover:border-blue-500">
                    <div class="flex items-center justify-between mb-3">
                        <div class="bg-blue-100 dark:bg-blue-900 p-3 rounded-lg group-hover:bg-blue-500 transition-colors">
                            <svg class="w-6 h-6 text-blue-600 dark:text-blue-400 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                            </svg>
                        </div>
                        <svg class="w-5 h-5 text-gray-400 dark:text-gray-500 group-hover:text-blue-500 group-hover:translate-x-1 transition-all" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">Rental Types</h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm">Manage categories like Car, Houseboat, etc.</p>
                </a>

                <a href="{{ route('admin.locations') }}" class="group bg-white dark:bg-gray-800 p-6 rounded-xl shadow-md hover:shadow-xl transition-all duration-300 border-2 border-transparent hover:border-green-500">
                    <div class="flex items-center justify-between mb-3">
                        <div class="bg-green-100 dark:bg-green-900 p-3 rounded-lg group-hover:bg-green-500 transition-colors">
                            <svg class="w-6 h-6 text-green-600 dark:text-green-400 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                        </div>
                        <svg class="w-5 h-5 text-gray-400 dark:text-gray-500 group-hover:text-green-500 group-hover:translate-x-1 transition-all" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">Locations</h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm">Add or edit locations like Langkawi, Penang</p>
                </a>

                <a href="{{ route('admin.badges') }}" class="group bg-white dark:bg-gray-800 p-6 rounded-xl shadow-md hover:shadow-xl transition-all duration-300 border-2 border-transparent hover:border-yellow-500">
                    <div class="flex items-center justify-between mb-3">
                        <div class="bg-yellow-100 dark:bg-yellow-900 p-3 rounded-lg group-hover:bg-yellow-500 transition-colors">
                            <svg class="w-6 h-6 text-yellow-600 dark:text-yellow-400 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                            </svg>
                        </div>
                        <svg class="w-5 h-5 text-gray-400 dark:text-gray-500 group-hover:text-yellow-500 group-hover:translate-x-1 transition-all" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">Host Badges</h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm">Configure badge tiers and requirements</p>
                </a>
            </div>
        </div>

        <!-- Recent Bookings -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md overflow-hidden">
            <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Recent Bookings</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-700 dark:text-gray-300 uppercase tracking-wider">Booking ID</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-700 dark:text-gray-300 uppercase tracking-wider">User</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-700 dark:text-gray-300 uppercase tracking-wider">Listing</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-700 dark:text-gray-300 uppercase tracking-wider">Check In</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-700 dark:text-gray-300 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-700 dark:text-gray-300 uppercase tracking-wider">Total</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-700 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @forelse($recent_bookings as $booking)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900 dark:text-white">#{{ $booking->id }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-300">{{ $booking->user->name }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-gray-300">{{ $booking->listing->title }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 dark:text-gray-400">{{ $booking->check_in->format('M d, Y') }}</td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full
                                    @if($booking->status == 'confirmed') bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200
                                    @elseif($booking->status == 'pending') bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200
                                    @elseif($booking->status == 'cancelled') bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200
                                    @elseif($booking->status == 'completed') bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200
                                    @else bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200
                                    @endif">
                                    {{ ucfirst($booking->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900 dark:text-white">RM {{ number_format($booking->total_price, 2) }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm">
                                <div class="flex gap-2">
                                    @if($booking->status === 'pending')
                                        <button wire:click="approveBooking({{ $booking->id }})"
                                                wire:confirm="Are you sure you want to approve this booking?"
                                                class="inline-flex items-center px-3 py-1.5 bg-green-600 hover:bg-green-700 text-white text-xs font-semibold rounded-lg transition-colors">
                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                            </svg>
                                            Approve
                                        </button>
                                    @endif
                                    @if(in_array($booking->status, ['pending', 'confirmed']))
                                        <button wire:click="cancelBooking({{ $booking->id }})"
                                                wire:confirm="Are you sure you want to cancel this booking?"
                                                class="inline-flex items-center px-3 py-1.5 bg-red-600 hover:bg-red-700 text-white text-xs font-semibold rounded-lg transition-colors">
                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                            </svg>
                                            Cancel
                                        </button>
                                    @endif
                                    @if(!in_array($booking->status, ['pending', 'confirmed']))
                                        <span class="text-gray-400 dark:text-gray-500 text-xs italic">No actions available</span>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center">
                                <svg class="mx-auto h-12 w-12 text-gray-400 dark:text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                </svg>
                                <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">No bookings yet</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
