@php
    $themeMode = \App\Helpers\SeoHelper::themeMode();
    $customColor = \App\Helpers\SeoHelper::customPrimaryColor();

    // Generate theme-based classes
    if ($themeMode === 'custom' && $customColor) {
        $shades = \App\Helpers\SeoHelper::generateColorShades($customColor);
        $linkClass = 'font-semibold transition hover:opacity-80';
        $linkStyle = 'color: ' . $customColor;
        $buttonClass = 'inline-flex items-center px-4 py-2 text-white font-semibold rounded-lg shadow-lg transition hover:opacity-90';
        $buttonStyle = 'background: linear-gradient(to right, ' . $customColor . ', ' . $shades['700'] . ');';
    } else {
        $linkClass = 'text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-semibold transition';
        $linkStyle = '';
        $buttonClass = 'inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg shadow-lg transition';
        $buttonStyle = '';
    }

    // Generate prose link color class
    if ($themeMode === 'custom' && $customColor) {
        $proseClass = 'prose prose-lg dark:prose-invert max-w-none prose-headings:text-gray-900 dark:prose-headings:text-gray-50 prose-p:text-gray-700 dark:prose-p:text-gray-200 prose-strong:text-gray-900 dark:prose-strong:text-gray-100';
    } else {
        $proseClass = 'prose prose-lg dark:prose-invert max-w-none prose-headings:text-gray-900 dark:prose-headings:text-gray-50 prose-p:text-gray-700 dark:prose-p:text-gray-200 prose-a:text-blue-600 dark:prose-a:text-blue-400 prose-strong:text-gray-900 dark:prose-strong:text-gray-100';
    }

    // SEO meta data
    $siteName = \App\Models\Setting::get('site_name', config('app.name'));
    $metaTitle = 'About Us - ' . $siteName;
    $metaDescription = 'Learn about our story, mission, and what makes us the trusted rental marketplace.';
@endphp

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <!-- SEO Meta Tags -->
        {!! \App\Helpers\SeoHelper::generateMetaTags(
            $metaTitle,
            $metaDescription,
            null,
            []
        ) !!}

        <!-- Favicon -->
        @if(\App\Helpers\SeoHelper::favicon())
            <link rel="icon" type="image/x-icon" href="{{ \App\Helpers\SeoHelper::favicon() }}">
        @endif

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Structured Data -->
        {!! \App\Helpers\SeoHelper::organizationSchema() !!}

        <!-- Custom Theme CSS -->
        @if(\App\Helpers\SeoHelper::themeMode() === 'custom')
        <style>
            {!! \App\Helpers\SeoHelper::generateCustomThemeCSS() !!}
        </style>
        @endif

        <!-- Theme Mode Script (must run before body renders to prevent flash) -->
        <script>
            const themeMode = '{{ \App\Helpers\SeoHelper::themeMode() }}';

            if (themeMode === 'dark') {
                document.documentElement.classList.add('dark');
                document.documentElement.classList.remove('custom');
            } else if (themeMode === 'custom') {
                document.documentElement.classList.add('custom');
                document.documentElement.classList.remove('dark');
            } else {
                // System default
                if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                    document.documentElement.classList.add('dark');
                    document.documentElement.classList.remove('custom');
                } else {
                    document.documentElement.classList.remove('dark');
                    document.documentElement.classList.remove('custom');
                }
            }
        </script>

        <!-- Google Analytics -->
        @if(\App\Helpers\SeoHelper::googleAnalyticsId())
            {!! \App\Helpers\SeoHelper::googleAnalyticsScript() !!}
        @endif

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
            @include('layouts.navigation')

            <!-- Page Content -->
            <main class="py-16">
                <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-8 lg:p-12">
                        <div class="{{ $proseClass }}" @if($themeMode === 'custom' && $customColor) style="--link-color: {{ $customColor }};" @endif>
                            @if($themeMode === 'custom' && $customColor)
                                <style>
                                    .prose a { color: {{ $customColor }} !important; }
                                    .prose a:hover { opacity: 0.8; }
                                </style>
                            @endif
                            {!! $content !!}
                        </div>

                        @if(empty($content))
                            <div class="text-center py-12">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-white">No Content Available</h3>
                                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">The about us content has not been set yet.</p>
                                @auth
                                    @if(auth()->user()->isAdmin())
                                        <div class="mt-6">
                                            <a href="{{ route('admin.seo') }}" class="{{ $buttonClass }}" @if($buttonStyle) style="{{ $buttonStyle }}" @endif>
                                                Edit About Us Content
                                            </a>
                                        </div>
                                    @endif
                                @endauth
                            </div>
                        @endif

                        <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700 text-center">
                            <a href="{{ route('home') }}" class="{{ $linkClass }}" @if($linkStyle) style="{{ $linkStyle }}" @endif>
                                <svg class="w-5 h-5 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                                </svg>
                                Back to Home
                            </a>
                        </div>
                    </div>
                </div>
            </main>

            <!-- Footer -->
            <x-footer />
        </div>
    </body>
</html>
