<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <!-- SEO Meta Tags -->
        {!! \App\Helpers\SeoHelper::generateMetaTags(
            $metaTitle ?? null,
            $metaDescription ?? null,
            $metaImage ?? null,
            $additionalMeta ?? []
        ) !!}

        <!-- Favicon -->
        @if(\App\Helpers\SeoHelper::favicon())
            <link rel="icon" type="image/x-icon" href="{{ \App\Helpers\SeoHelper::favicon() }}">
        @endif

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Structured Data -->
        {!! \App\Helpers\SeoHelper::organizationSchema() !!}

        <!-- Dark Mode Script (must run before body renders to prevent flash) -->
        <script>
            if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                document.documentElement.classList.add('dark')
            } else {
                document.documentElement.classList.remove('dark')
            }
        </script>

        <!-- Google Analytics -->
        @if(\App\Helpers\SeoHelper::googleAnalyticsId())
            {!! \App\Helpers\SeoHelper::googleAnalyticsScript() !!}
        @endif

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans text-gray-900 dark:text-gray-100 antialiased">
        <div class="min-h-screen flex flex-col sm:justify-center items-center pt-6 sm:pt-0 bg-gray-100 dark:bg-gray-900">
            <div>
                <a href="/" class="flex items-center gap-2">
                    @php
                        $logoMode = \App\Helpers\SeoHelper::logoDisplayMode();
                    @endphp

                    @if($logoMode === 'both' || $logoMode === 'logo_only')
                        @if($siteLogo)
                            <img src="{{ $siteLogo }}" alt="{{ $siteName }}" class="block h-20 w-auto">
                        @else
                            <x-application-logo class="w-20 h-20 fill-current text-gray-500 dark:text-gray-400" />
                        @endif
                    @endif

                    @if($logoMode === 'both' || $logoMode === 'name_only')
                        <span class="text-2xl font-bold text-gray-800 dark:text-gray-200">{{ $siteName }}</span>
                    @endif
                </a>
            </div>

            <div class="w-full sm:max-w-md mt-6 px-6 py-4 bg-white dark:bg-gray-800 shadow-md overflow-hidden sm:rounded-lg">
                {{ $slot }}
            </div>

            <!-- Footer -->
            <div class="mt-8 w-full">
                <x-footer />
            </div>
        </div>
    </body>
</html>
