<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <!-- SEO Meta Tags -->
        {!! \App\Helpers\SeoHelper::generateMetaTags(
            $metaTitle ?? null,
            $metaDescription ?? null,
            $metaImage ?? null,
            $additionalMeta ?? []
        ) !!}

        <!-- Favicon -->
        @if(\App\Helpers\SeoHelper::favicon())
            <link rel="icon" type="image/x-icon" href="{{ \App\Helpers\SeoHelper::favicon() }}">
        @endif

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Structured Data -->
        {!! \App\Helpers\SeoHelper::organizationSchema() !!}

        <!-- Custom Theme CSS -->
        @if(\App\Helpers\SeoHelper::themeMode() === 'custom')
        <style>
            {!! \App\Helpers\SeoHelper::generateCustomThemeCSS() !!}
        </style>
        @endif

        <!-- Theme Mode Script (must run before body renders to prevent flash) -->
        <script>
            const themeMode = '{{ \App\Helpers\SeoHelper::themeMode() }}';

            if (themeMode === 'dark') {
                document.documentElement.classList.add('dark');
                document.documentElement.classList.remove('custom');
            } else if (themeMode === 'custom') {
                document.documentElement.classList.add('custom');
                document.documentElement.classList.remove('dark');
            } else {
                // System default
                if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                    document.documentElement.classList.add('dark');
                    document.documentElement.classList.remove('custom');
                } else {
                    document.documentElement.classList.remove('dark');
                    document.documentElement.classList.remove('custom');
                }
            }
        </script>

        <!-- Google Analytics -->
        @if(\App\Helpers\SeoHelper::googleAnalyticsId())
            {!! \App\Helpers\SeoHelper::googleAnalyticsScript() !!}
        @endif

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
            @include('layouts.navigation')

            <!-- Page Heading -->
            @isset($header)
                <header class="bg-white dark:bg-gray-800 shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        {{ $header }}
                    </div>
                </header>
            @endisset

            <!-- Page Content -->
            <main>
                {{ $slot }}
            </main>

            <!-- Footer -->
            <x-footer />
        </div>
    </body>
</html>
