<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }
        .content {
            background: #fff;
            padding: 30px;
            border: 1px solid #e5e7eb;
        }
        .booking-details {
            background: #f9fafb;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        .detail-label {
            font-weight: bold;
            color: #6b7280;
        }
        .detail-value {
            color: #111827;
        }
        .total {
            background: #3b82f6;
            color: white;
            padding: 15px 20px;
            border-radius: 8px;
            margin-top: 20px;
            font-size: 18px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            color: #6b7280;
            font-size: 14px;
        }
        .button {
            display: inline-block;
            background: #3b82f6;
            color: white;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 6px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 style="margin: 0;">🎉 Booking Confirmed!</h1>
        <p style="margin: 10px 0 0 0;">Thank you for choosing GengSewa</p>
    </div>

    <div class="content">
        <p>Hello {{ $user->name }},</p>

        <p>Your booking has been confirmed! Here are the details:</p>

        <div class="booking-details">
            <h2 style="margin-top: 0; color: #111827;">{{ $listing->title }}</h2>

            <div class="detail-row">
                <span class="detail-label">Booking Reference:</span>
                <span class="detail-value">BOOK-{{ $booking->id }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Check-in Date:</span>
                <span class="detail-value">{{ $booking->check_in->format('l, F j, Y') }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Check-out Date:</span>
                <span class="detail-value">{{ $booking->check_out->format('l, F j, Y') }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Duration:</span>
                <span class="detail-value">{{ $booking->days }} {{ Str::plural('day', $booking->days) }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Number of Guests:</span>
                <span class="detail-value">{{ $booking->guests }} {{ Str::plural('guest', $booking->guests) }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Location:</span>
                <span class="detail-value">{{ $listing->location->name }}</span>
            </div>

            <div class="detail-row">
                <span class="detail-label">Rental Type:</span>
                <span class="detail-value">{{ $listing->rentalType->name }}</span>
            </div>

            @if($booking->pickupLocation)
                <div class="detail-row">
                    <span class="detail-label">📍 Pickup Location:</span>
                    <span class="detail-value">{{ $booking->pickupLocation->name }}</span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">⏰ Pickup Time:</span>
                    <span class="detail-value">{{ date('h:i A', strtotime($booking->pickup_time)) }}</span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">📍 Dropoff Location:</span>
                    <span class="detail-value">{{ $booking->dropoffLocation->name }}</span>
                </div>

                <div class="detail-row" style="border-bottom: none;">
                    <span class="detail-label">⏰ Dropoff Time:</span>
                    <span class="detail-value">{{ date('h:i A', strtotime($booking->dropoff_time)) }}</span>
                </div>
            @else
                <div class="detail-row" style="border-bottom: none;">
                </div>
            @endif
        </div>

        <div class="total">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <span><strong>Total Amount Paid:</strong></span>
                <span style="font-size: 24px;"><strong>RM {{ number_format($booking->total_price, 2) }}</strong></span>
            </div>
        </div>

        <div style="margin-top: 30px; padding: 20px; background: #fef3c7; border-left: 4px solid #f59e0b; border-radius: 4px;">
            <h3 style="margin-top: 0; color: #92400e;">📌 Important Information</h3>
            <ul style="margin: 0; padding-left: 20px; color: #78350f;">
                <li>Please arrive on or after your check-in date</li>
                <li>Bring a valid ID for verification</li>
                <li>Contact details: {{ $user->email }} / {{ $user->phone }}</li>
                <li>Any questions? Contact our support team</li>
            </ul>
        </div>

        <center>
            <a href="{{ route('home') }}" class="button">View My Bookings</a>
        </center>

        <p style="margin-top: 30px;">We look forward to hosting you!</p>

        <p>
            Best regards,<br>
            <strong>The GengSewa Team</strong>
        </p>
    </div>

    <div class="footer">
        <p>This is an automated email. Please do not reply directly to this message.</p>
        <p>© {{ date('Y') }} GengSewa. All rights reserved.</p>
    </div>
</body>
</html>
