<footer class="mt-auto bg-white dark:bg-gray-800 border-t border-gray-100 dark:border-gray-700">
    <div class="max-w-7xl mx-auto py-8 px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            @php
                $sponsorLogos = \App\Models\Setting::get('footer_sponsor_logos', '[]');
                $sponsorLogos = is_string($sponsorLogos) ? json_decode($sponsorLogos, true) : $sponsorLogos;
                $customPages = \App\Models\CustomPage::where('is_active', true)->where('show_in_footer', true)->orderBy('order')->get();
            @endphp

            <!-- Sponsor/Partnership Logos -->
            @if(!empty($sponsorLogos) && count($sponsorLogos) > 0)
                <div class="mb-6 pb-6 border-b border-gray-200 dark:border-gray-700">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mb-3 uppercase tracking-wide">Our Sponsors & Partners</p>
                    <div class="flex flex-wrap justify-center items-center gap-6">
                        @foreach($sponsorLogos as $logo)
                            <img src="{{ asset($logo) }}" alt="Sponsor Logo" class="h-12 object-contain opacity-70 hover:opacity-100 transition-opacity duration-200">
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Copyright Text with HTML Support -->
            <div class="text-sm text-gray-600 dark:text-gray-400 mb-3 font-medium">
                {!! \App\Models\Setting::get('footer_copyright_text', '© ' . date('Y') . ' GengSewa. All rights reserved.') !!}
            </div>

            <!-- Footer Links -->
            <div class="flex flex-wrap justify-center items-center gap-4 md:gap-6 text-sm">
                @php
                    $privacySlug = \App\Models\Setting::get('privacy_policy_slug', '/privacy-policy');
                    $termsSlug = \App\Models\Setting::get('terms_conditions_slug', '/terms-and-conditions');
                    $advertiseSlug = \App\Models\Setting::get('advertise_slug', '/advertise');
                    $aboutUsSlug = \App\Models\Setting::get('about_us_slug', '/about-us');
                @endphp

                <a href="{{ $aboutUsSlug }}" class="text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white font-semibold transition-colors duration-200 hover:underline">
                    About Us
                </a>

                <span class="text-gray-400 dark:text-gray-600">•</span>

                <a href="{{ $advertiseSlug }}" class="text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white font-semibold transition-colors duration-200 hover:underline">
                    Our Services
                </a>

                <span class="text-gray-400 dark:text-gray-600">•</span>

                <a href="{{ $privacySlug }}" class="text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white font-semibold transition-colors duration-200 hover:underline">
                    Privacy Policy
                </a>

                <span class="text-gray-400 dark:text-gray-600">•</span>

                <a href="{{ $termsSlug }}" class="text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white font-semibold transition-colors duration-200 hover:underline">
                    Terms and Conditions
                </a>

                <!-- Custom Pages -->
                @foreach($customPages as $page)
                    <span class="text-gray-400 dark:text-gray-600">•</span>
                    <a href="/{{ $page->slug }}" class="text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white font-semibold transition-colors duration-200 hover:underline">
                        {{ $page->title }}
                    </a>
                @endforeach
            </div>
        </div>
    </div>
</footer>
