<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt #{{ $booking->invoice_number }}</title>

    <!-- Use built assets if available, otherwise inline styles -->
    @if(file_exists(public_path('build/manifest.json')))
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @else
        <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.4.1/dist/tailwind.min.css" rel="stylesheet">
    @endif

    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 20px; }
            .receipt-container { box-shadow: none !important; }
        }
        @page {
            margin: 0.5cm;
        }
    </style>
</head>
<body class="bg-gray-50">
    @php
        $companyName = \App\Models\Setting::get('receipt_company_name', \App\Helpers\SeoHelper::siteName());
        $companyAddress = \App\Models\Setting::get('receipt_company_address', '');
        $companyPhone = \App\Models\Setting::get('receipt_company_phone', '');
        $companyEmail = \App\Models\Setting::get('receipt_company_email', '');
        $companyWebsite = \App\Models\Setting::get('receipt_website', url('/'));
        $footerText = \App\Models\Setting::get('receipt_footer_text', 'Thank you for your business!');
        $showLogo = \App\Models\Setting::get('receipt_show_logo', true);
        $siteLogo = \App\Helpers\SeoHelper::logo();

        $days = \Carbon\Carbon::parse($booking->check_in)->diffInDays(\Carbon\Carbon::parse($booking->check_out));
        $baseSubtotal = $booking->listing->price_per_day * $days;
        $subtotalAfterDiscount = $baseSubtotal - ($booking->discount_amount ?? 0);
        $addOnsTotal = $booking->addOns->sum('pivot.price_paid');
        $bookingAmount = $subtotalAfterDiscount + $addOnsTotal;

        // Gateway fee (payment processing fee) - charged to guest
        $gatewayFee = $booking->platform_fee > 0
            ? $booking->platform_fee
            : \App\Services\GatewayFeeService::calculateFee($bookingAmount);

        // Get gateway fee settings for display
        $gatewayFeeType = \App\Models\Setting::get('payment_gateway_fee_type', 'fixed');
        $gatewayFeeFixed = \App\Models\Setting::get('payment_gateway_fee_fixed', 0);
        $gatewayFeePercentage = \App\Models\Setting::get('payment_gateway_fee_percentage', 0);
    @endphp

    <div class="max-w-4xl mx-auto p-8">
        <!-- Action Buttons -->
        <div class="mb-6 no-print flex gap-2">
            <button onclick="window.print()" class="bg-indigo-600 hover:bg-indigo-700 text-white px-6 py-2.5 rounded-lg transition font-medium shadow-sm">
                Print Receipt
            </button>
            <a href="{{ route('user.bookings') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2.5 rounded-lg transition inline-block font-medium shadow-sm">
                Back to Bookings
            </a>
        </div>

        <!-- Receipt -->
        <div class="bg-white shadow-xl rounded-lg overflow-hidden receipt-container">
            <!-- Professional Header with Logo -->
            <div class="bg-gradient-to-r from-indigo-600 to-purple-600 px-8 py-6">
                <div class="flex justify-between items-center">
                    @if($showLogo && $siteLogo)
                        <div class="flex items-center">
                            <img src="{{ $siteLogo }}" alt="{{ $companyName }}" class="h-16 w-auto bg-white rounded-lg p-2">
                        </div>
                    @endif
                    <div class="text-right text-white">
                        <h1 class="text-2xl font-bold">{{ $companyName }}</h1>
                        @if($companyAddress)
                            <p class="text-sm opacity-90 mt-1">{{ $companyAddress }}</p>
                        @endif
                        @if($companyPhone)
                            <p class="text-sm opacity-90">Tel: {{ $companyPhone }}</p>
                        @endif
                        @if($companyEmail)
                            <p class="text-sm opacity-90">Email: {{ $companyEmail }}</p>
                        @endif
                        @if($companyWebsite)
                            <p class="text-sm opacity-90">{{ $companyWebsite }}</p>
                        @endif
                    </div>
                </div>
            </div>

            <div class="px-8 py-6">
                <!-- Receipt Title & Invoice Info -->
                <div class="border-b-2 border-gray-200 pb-6 mb-6">
                    <div class="flex justify-between items-start">
                        <div>
                            <h2 class="text-3xl font-bold text-gray-900 mb-2">BOOKING RECEIPT</h2>
                            <div class="text-sm text-gray-600 space-y-1">
                                <p><strong>Receipt #:</strong> {{ $booking->id }}</p>
                                <p><strong>Invoice Number:</strong> <span class="font-mono text-indigo-600">{{ $booking->invoice_number }}</span></p>
                                <p><strong>Issue Date:</strong> {{ now()->format('M d, Y') }}</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="inline-flex px-4 py-2 rounded-lg {{ $booking->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-blue-100 text-blue-800' }}">
                                <span class="font-bold text-sm uppercase">{{ ucfirst($booking->status) }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Customer & Booking Information -->
                <div class="grid grid-cols-2 gap-8 mb-8">
                    <div class="bg-gray-50 rounded-lg p-5">
                        <h3 class="text-xs font-bold text-gray-500 uppercase tracking-wide mb-4">Customer Information</h3>
                        <div class="space-y-2.5">
                            <div>
                                <p class="text-xs text-gray-500">Name</p>
                                <p class="text-sm font-semibold text-gray-900">{{ $booking->user->name }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Email</p>
                                <p class="text-sm text-gray-900">{{ $booking->user->email }}</p>
                            </div>
                            @if($booking->user->phone)
                                <div>
                                    <p class="text-xs text-gray-500">Phone</p>
                                    <p class="text-sm text-gray-900">{{ $booking->user->phone }}</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="bg-gray-50 rounded-lg p-5">
                        <h3 class="text-xs font-bold text-gray-500 uppercase tracking-wide mb-4">Booking Details</h3>
                        <div class="space-y-2.5">
                            <div>
                                <p class="text-xs text-gray-500">Booking ID</p>
                                <p class="text-sm font-semibold text-gray-900">#{{ $booking->id }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Booking Date</p>
                                <p class="text-sm text-gray-900">{{ $booking->created_at->format('M d, Y h:i A') }}</p>
                            </div>
                            @if($booking->payment && $booking->payment->transaction_id)
                                <div>
                                    <p class="text-xs text-gray-500">Transaction ID</p>
                                    <p class="text-sm font-mono text-gray-900">{{ $booking->payment->transaction_id }}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Rental Property Details -->
                <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg p-6 mb-8 border border-gray-200">
                    <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                        Rental Property
                    </h3>
                    <p class="text-xl font-bold text-gray-900 mb-4">{{ $booking->listing->title }}</p>
                    <div class="grid grid-cols-3 gap-4">
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Type</p>
                            <p class="text-sm font-semibold text-gray-900">{{ $booking->listing->rentalType->name }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Location</p>
                            <p class="text-sm font-semibold text-gray-900">{{ $booking->listing->location->name }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Guests</p>
                            <p class="text-sm font-semibold text-gray-900">{{ $booking->guests }} {{ $booking->guests > 1 ? 'Guests' : 'Guest' }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Check-in</p>
                            <p class="text-sm font-semibold text-gray-900">{{ \Carbon\Carbon::parse($booking->check_in)->format('M d, Y') }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Check-out</p>
                            <p class="text-sm font-semibold text-gray-900">{{ \Carbon\Carbon::parse($booking->check_out)->format('M d, Y') }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Duration</p>
                            <p class="text-sm font-semibold text-gray-900">{{ $days }} {{ $days > 1 ? 'Days' : 'Day' }}</p>
                        </div>
                    </div>

                    {{-- Pickup/Dropoff Information --}}
                    @if($booking->pickupLocation)
                        <div class="mt-6 pt-6 border-t border-gray-300">
                            <h4 class="text-sm font-bold text-indigo-700 uppercase tracking-wide mb-4 flex items-center">
                                <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                Pickup & Dropoff Details
                            </h4>
                            <div class="grid grid-cols-2 gap-6">
                                <div>
                                    <p class="text-xs text-gray-500 uppercase mb-1.5">Pickup Location</p>
                                    <p class="text-sm font-semibold text-gray-900">{{ $booking->pickupLocation->name }}</p>
                                    <p class="text-xs text-gray-600 mt-0.5">{{ date('h:i A', strtotime($booking->pickup_time)) }}</p>
                                </div>
                                <div>
                                    <p class="text-xs text-gray-500 uppercase mb-1.5">Dropoff Location</p>
                                    <p class="text-sm font-semibold text-gray-900">{{ $booking->dropoffLocation->name }}</p>
                                    <p class="text-xs text-gray-600 mt-0.5">{{ date('h:i A', strtotime($booking->dropoff_time)) }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                <!-- Payment Breakdown -->
                <div class="border-t-2 border-gray-200 pt-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-5 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2zM10 8.5a.5.5 0 11-1 0 .5.5 0 011 0zm5 5a.5.5 0 11-1 0 .5.5 0 011 0z"></path>
                        </svg>
                        Payment Summary
                    </h3>

                    <div class="space-y-3">
                        <!-- Base Rental -->
                        <div class="flex justify-between py-2">
                            <span class="text-gray-700">Rental (RM {{ number_format($booking->listing->price_per_day, 2) }} × {{ $days }} {{ $days > 1 ? 'days' : 'day' }})</span>
                            <span class="font-semibold text-gray-900">RM {{ number_format($baseSubtotal, 2) }}</span>
                        </div>

                        <!-- Discount -->
                        @if(isset($booking->discount_amount) && $booking->discount_amount > 0)
                            <div class="flex justify-between py-2 bg-green-50 px-3 rounded">
                                <span class="text-green-700 font-medium">Discount ({{ number_format($booking->discount_percentage ?? 0, 0) }}% OFF)</span>
                                <span class="font-semibold text-green-700">-RM {{ number_format($booking->discount_amount, 2) }}</span>
                            </div>
                        @endif

                        <!-- Add-ons -->
                        @if($booking->addOns && $booking->addOns->count() > 0)
                            <div class="border-t border-gray-200 pt-3">
                                <p class="text-sm font-semibold text-gray-700 mb-2">Add-ons</p>
                                @foreach($booking->addOns as $addOn)
                                    <div class="flex justify-between py-1.5 pl-4">
                                        <span class="text-sm text-gray-600">
                                            • {{ $addOn->name }}
                                            <span class="text-xs text-gray-400">
                                                @if($addOn->pricing_type === 'per_day') (per day)
                                                @elseif($addOn->pricing_type === 'per_guest') (per guest)
                                                @elseif($addOn->pricing_type === 'per_day_per_guest') (per day/guest)
                                                @else (one-time)
                                                @endif
                                            </span>
                                        </span>
                                        <span class="text-sm text-gray-900">RM {{ number_format($addOn->pivot->price_paid, 2) }}</span>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <!-- Subtotal (before fees) -->
                        <div class="flex justify-between py-2 border-t border-gray-200">
                            <span class="text-gray-700 font-medium">Subtotal</span>
                            <span class="font-semibold text-gray-900">RM {{ number_format($bookingAmount, 2) }}</span>
                        </div>

                        <!-- Payment Processing Fee (Gateway Fee) -->
                        @if($gatewayFee > 0)
                            <div class="flex justify-between py-2">
                                <span class="text-gray-700">
                                    Payment Processing Fee
                                    <span class="text-xs text-gray-500">
                                        @if($gatewayFeeType === 'fixed')
                                            (RM {{ number_format($gatewayFeeFixed, 2) }})
                                        @elseif($gatewayFeeType === 'percentage')
                                            ({{ number_format($gatewayFeePercentage, 1) }}%)
                                        @else
                                            (RM {{ number_format($gatewayFeeFixed, 2) }} + {{ number_format($gatewayFeePercentage, 1) }}%)
                                        @endif
                                    </span>
                                </span>
                                <span class="font-semibold text-gray-900">RM {{ number_format($gatewayFee, 2) }}</span>
                            </div>
                        @endif

                        <!-- Total -->
                        <div class="flex justify-between py-4 border-t-2 border-gray-300 bg-gradient-to-r from-indigo-50 to-purple-50 px-4 rounded-lg">
                            <span class="text-xl font-bold text-gray-900">Total Amount Paid</span>
                            <span class="text-2xl font-bold text-indigo-600">RM {{ number_format($booking->total_price, 2) }}</span>
                        </div>

                        <!-- Payment Status -->
                        @if($booking->payment)
                            <div class="flex justify-between items-center py-3 bg-gray-50 px-4 rounded-lg text-sm">
                                <span class="text-gray-600">Payment Status:</span>
                                <span class="font-bold px-3 py-1 rounded-full
                                    @if(in_array($booking->payment->status, ['successful', 'completed', 'paid'])) bg-green-100 text-green-700
                                    @elseif($booking->payment->status === 'pending') bg-yellow-100 text-yellow-700
                                    @else bg-red-100 text-red-700
                                    @endif">
                                    @if(in_array($booking->payment->status, ['successful', 'completed']))
                                        ✓ PAID
                                    @else
                                        {{ strtoupper($booking->payment->status) }}
                                    @endif
                                </span>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Footer -->
                <div class="mt-10 pt-6 border-t border-gray-200">
                    <div class="text-center">
                        <p class="text-gray-700 font-medium text-lg mb-2">{{ $footerText }}</p>
                        @if($companyEmail)
                            <p class="text-sm text-gray-600 mb-1">
                                For inquiries, please contact us at
                                <a href="mailto:{{ $companyEmail }}" class="text-indigo-600 font-medium">{{ $companyEmail }}</a>
                            </p>
                        @endif
                        @if($companyPhone)
                            <p class="text-sm text-gray-600 mb-3">
                                Phone: <span class="font-medium">{{ $companyPhone }}</span>
                            </p>
                        @endif
                        <p class="text-xs text-gray-400 mt-4 italic">This is an automatically generated receipt. No signature required.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
