@php
    $companyName = \App\Models\Setting::get('receipt_company_name', \App\Helpers\SeoHelper::siteName());
    $companyAddress = \App\Models\Setting::get('receipt_company_address', '');
    $companyPhone = \App\Models\Setting::get('receipt_company_phone', '');
    $companyEmail = \App\Models\Setting::get('receipt_company_email', '');
    $companyWebsite = \App\Models\Setting::get('receipt_website', url('/'));
    $footerText = \App\Models\Setting::get('receipt_footer_text', 'Thank you for your business!');
    $showLogo = \App\Models\Setting::get('receipt_show_logo', true);
    $siteLogo = \App\Helpers\SeoHelper::logo();

    $days = \Carbon\Carbon::parse($booking->check_in)->diffInDays(\Carbon\Carbon::parse($booking->check_out));
    $baseSubtotal = $booking->listing->price_per_day * $days;
    $subtotalAfterDiscount = $baseSubtotal - ($booking->discount_amount ?? 0);
    $addOnsTotal = $booking->addOns->sum('pivot.price_paid');
    $bookingAmount = $subtotalAfterDiscount + $addOnsTotal;

    // Gateway fee (payment processing fee) - charged to guest
    $gatewayFee = $booking->platform_fee > 0
        ? $booking->platform_fee
        : \App\Services\GatewayFeeService::calculateFee($bookingAmount);

    // Get gateway fee settings for display
    $gatewayFeeType = \App\Models\Setting::get('payment_gateway_fee_type', 'fixed');
    $gatewayFeeFixed = \App\Models\Setting::get('payment_gateway_fee_fixed', 0);
    $gatewayFeePercentage = \App\Models\Setting::get('payment_gateway_fee_percentage', 0);
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt #{{ $booking->invoice_number }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 10px; }
            .receipt-container { box-shadow: none !important; max-width: 100%; }
        }
        @page {
            size: A4;
            margin: 0.5cm;
        }
        body { font-size: 13px; }
    </style>
</head>
<body class="bg-gray-50">
    <div class="max-w-3xl mx-auto p-4">
        <!-- Action Buttons -->
        <div class="mb-4 no-print flex gap-2">
            <button onclick="window.print()" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg text-sm font-medium shadow-sm">
                Print Receipt
            </button>
            <a href="{{ route('user.bookings') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg text-sm inline-block font-medium shadow-sm">
                Back to Bookings
            </a>
        </div>

        <!-- Compact Receipt -->
        <div class="bg-white shadow-lg rounded-lg overflow-hidden receipt-container">
            <!-- Header -->
            <div class="bg-gray-800 text-white px-6 py-4">
                <div class="flex justify-between items-center">
                    <div class="flex items-center gap-3">
                        @if($showLogo && $siteLogo)
                            <img src="{{ $siteLogo }}" alt="{{ $companyName }}" class="h-12 w-auto bg-white rounded p-1">
                        @endif
                        <div>
                            <h1 class="text-lg font-bold">{{ $companyName }}</h1>
                            <p class="text-xs opacity-80">{{ $companyWebsite }}</p>
                        </div>
                    </div>
                    <div class="text-right text-xs">
                        @if($companyAddress)<p class="opacity-90">{{ $companyAddress }}</p>@endif
                        @if($companyPhone)<p class="opacity-90">Tel: {{ $companyPhone }}</p>@endif
                        @if($companyEmail)<p class="opacity-90">{{ $companyEmail }}</p>@endif
                    </div>
                </div>
            </div>

            <div class="px-6 py-4">
                <!-- Title & Invoice -->
                <div class="flex justify-between items-center mb-4 pb-3 border-b-2 border-gray-200">
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">BOOKING RECEIPT</h2>
                        <p class="text-xs text-gray-600 mt-1">Receipt #{{ $booking->id }} | Invoice: <span class="font-mono text-indigo-600">{{ $booking->invoice_number }}</span></p>
                    </div>
                    <div class="text-right">
                        <p class="text-xs text-gray-600">Issue Date</p>
                        <p class="text-sm font-semibold">{{ now()->format('M d, Y') }}</p>
                        <span class="inline-block mt-1 px-3 py-1 rounded text-xs font-bold {{ $booking->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-blue-100 text-blue-800' }}">
                            {{ strtoupper($booking->status) }}
                        </span>
                    </div>
                </div>

                <!-- Customer & Booking Info - Compact Grid -->
                <div class="grid grid-cols-2 gap-4 mb-4 text-xs">
                    <div>
                        <p class="font-bold text-gray-700 uppercase mb-1">Customer</p>
                        <p class="font-semibold">{{ $booking->user->name }}</p>
                        <p class="text-gray-600">{{ $booking->user->email }}</p>
                        @if($booking->user->phone)<p class="text-gray-600">{{ $booking->user->phone }}</p>@endif
                    </div>
                    <div>
                        <p class="font-bold text-gray-700 uppercase mb-1">Booking Info</p>
                        <p><span class="text-gray-600">Booked:</span> {{ $booking->created_at->format('M d, Y h:i A') }}</p>
                        @if($booking->payment && $booking->payment->transaction_id)
                            <p><span class="text-gray-600">Transaction:</span> <span class="font-mono text-xs">{{ $booking->payment->transaction_id }}</span></p>
                        @endif
                    </div>
                </div>

                <!-- Property Details - Compact -->
                <div class="bg-gray-50 rounded p-3 mb-4">
                    <p class="font-bold text-sm mb-2">{{ $booking->listing->title }}</p>
                    <div class="grid grid-cols-3 gap-3 text-xs">
                        <div><span class="text-gray-600">Type:</span> <span class="font-semibold">{{ $booking->listing->rentalType->name }}</span></div>
                        <div><span class="text-gray-600">Location:</span> <span class="font-semibold">{{ $booking->listing->location->name }}</span></div>
                        <div><span class="text-gray-600">Guests:</span> <span class="font-semibold">{{ $booking->guests }}</span></div>
                        <div><span class="text-gray-600">Check-in:</span> <span class="font-semibold">{{ \Carbon\Carbon::parse($booking->check_in)->format('M d, Y') }}</span></div>
                        <div><span class="text-gray-600">Check-out:</span> <span class="font-semibold">{{ \Carbon\Carbon::parse($booking->check_out)->format('M d, Y') }}</span></div>
                        <div><span class="text-gray-600">Duration:</span> <span class="font-semibold">{{ $days }} {{ $days > 1 ? 'days' : 'day' }}</span></div>
                    </div>
                </div>

                <!-- Payment Summary - Compact Table -->
                <div class="border-t-2 border-gray-200 pt-3">
                    <table class="w-full text-sm">
                        <tbody>
                            <tr class="border-b border-gray-100">
                                <td class="py-1.5 text-gray-700">Rental (RM {{ number_format($booking->listing->price_per_day, 2) }} × {{ $days }} {{ $days > 1 ? 'days' : 'day' }})</td>
                                <td class="py-1.5 text-right font-semibold">RM {{ number_format($baseSubtotal, 2) }}</td>
                            </tr>

                            @if(isset($booking->discount_amount) && $booking->discount_amount > 0)
                                <tr class="border-b border-gray-100 bg-green-50">
                                    <td class="py-1.5 text-green-700 font-medium">Discount ({{ number_format($booking->discount_percentage ?? 0, 0) }}% OFF)</td>
                                    <td class="py-1.5 text-right font-semibold text-green-700">-RM {{ number_format($booking->discount_amount, 2) }}</td>
                                </tr>
                            @endif

                            @if($booking->addOns && $booking->addOns->count() > 0)
                                @foreach($booking->addOns as $addOn)
                                    <tr class="border-b border-gray-100">
                                        <td class="py-1.5 text-gray-600 text-xs">
                                            Add-on: {{ $addOn->name }}
                                            @if($addOn->pricing_type === 'per_day') (per day)
                                            @elseif($addOn->pricing_type === 'per_guest') (per guest)
                                            @elseif($addOn->pricing_type === 'per_day_per_guest') (per day/guest)
                                            @endif
                                        </td>
                                        <td class="py-1.5 text-right">RM {{ number_format($addOn->pivot->price_paid, 2) }}</td>
                                    </tr>
                                @endforeach
                            @endif

                            <!-- Subtotal -->
                            <tr class="border-t border-gray-200">
                                <td class="py-1.5 font-medium text-gray-700">Subtotal</td>
                                <td class="py-1.5 text-right font-semibold">RM {{ number_format($bookingAmount, 2) }}</td>
                            </tr>

                            <!-- Payment Processing Fee -->
                            @if($gatewayFee > 0)
                                <tr class="border-b border-gray-100">
                                    <td class="py-1.5 text-gray-700">
                                        Payment Processing Fee
                                        <span class="text-xs text-gray-500">
                                            @if($gatewayFeeType === 'fixed')
                                                (RM {{ number_format($gatewayFeeFixed, 2) }})
                                            @elseif($gatewayFeeType === 'percentage')
                                                ({{ number_format($gatewayFeePercentage, 1) }}%)
                                            @else
                                                (RM {{ number_format($gatewayFeeFixed, 2) }} + {{ number_format($gatewayFeePercentage, 1) }}%)
                                            @endif
                                        </span>
                                    </td>
                                    <td class="py-1.5 text-right font-semibold">RM {{ number_format($gatewayFee, 2) }}</td>
                                </tr>
                            @endif

                            <tr class="border-t-2 border-gray-400 bg-gray-50">
                                <td class="py-2 font-bold text-lg">TOTAL PAID</td>
                                <td class="py-2 text-right font-bold text-xl text-indigo-600">RM {{ number_format($booking->total_price, 2) }}</td>
                            </tr>
                        </tbody>
                    </table>

                    @if($booking->payment)
                        <div class="mt-3 flex justify-between items-center text-xs bg-gray-50 px-3 py-2 rounded">
                            <span class="text-gray-600">Payment Status:</span>
                            <span class="font-bold px-2 py-1 rounded
                                @if(in_array($booking->payment->status, ['successful', 'completed', 'paid'])) bg-green-100 text-green-700
                                @elseif($booking->payment->status === 'pending') bg-yellow-100 text-yellow-700
                                @else bg-red-100 text-red-700
                                @endif">
                                @if(in_array($booking->payment->status, ['successful', 'completed']))
                                    ✓ PAID
                                @else
                                    {{ strtoupper($booking->payment->status) }}
                                @endif
                            </span>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Footer -->
            <div class="bg-gray-50 px-6 py-3 border-t border-gray-200 text-center text-xs text-gray-600">
                <p class="font-medium mb-1">{{ $footerText }}</p>
                @if($companyEmail)
                    <p>Contact: <a href="mailto:{{ $companyEmail }}" class="text-indigo-600">{{ $companyEmail }}</a>
                    @if($companyPhone) | Tel: {{ $companyPhone }}@endif</p>
                @endif
                <p class="text-gray-400 mt-1 italic">Automatically generated receipt. No signature required.</p>
            </div>
        </div>
    </div>
</body>
</html>
