<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Host Receipt #{{ $booking->hostReceipt->receipt_number }}</title>

    @if(file_exists(public_path('build/manifest.json')))
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @else
        <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.4.1/dist/tailwind.min.css" rel="stylesheet">
    @endif

    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 20px; }
            .receipt-container { box-shadow: none !important; }
        }
        @page {
            margin: 0.5cm;
        }
    </style>
</head>
<body class="bg-gray-50">
    @php
        $companyName = \App\Models\Setting::get('receipt_company_name', \App\Helpers\SeoHelper::siteName());
        $companyAddress = \App\Models\Setting::get('receipt_company_address', '');
        $companyPhone = \App\Models\Setting::get('receipt_company_phone', '');
        $companyEmail = \App\Models\Setting::get('receipt_company_email', '');
        $companyWebsite = \App\Models\Setting::get('receipt_website', url('/'));
        $footerText = \App\Models\Setting::get('receipt_footer_text', 'Thank you for your business!');
        $showLogo = \App\Models\Setting::get('receipt_show_logo', true);
        $siteLogo = \App\Helpers\SeoHelper::logo();

        $days = \Carbon\Carbon::parse($booking->check_in)->diffInDays(\Carbon\Carbon::parse($booking->check_out));
        $hostReceipt = $booking->hostReceipt;
    @endphp

    <div class="max-w-4xl mx-auto p-8">
        <!-- Action Buttons -->
        <div class="mb-6 no-print flex gap-2">
            <button onclick="window.print()" class="bg-indigo-600 hover:bg-indigo-700 text-white px-6 py-2.5 rounded-lg transition font-medium shadow-sm">
                Print Receipt
            </button>
            <a href="{{ route('booking.receipt', $booking->id) }}" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2.5 rounded-lg transition inline-block font-medium shadow-sm">
                View Guest Receipt
            </a>

            @if(auth()->user()->isAdmin() && $hostReceipt->payout_status !== 'completed')
                <button onclick="openPayoutModal()" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2.5 rounded-lg transition font-medium shadow-sm">
                    Mark as Paid
                </button>
            @endif

            <a href="{{ auth()->user()->isAdmin() ? route('admin.bookings') : route('host.bookings') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2.5 rounded-lg transition inline-block font-medium shadow-sm">
                Back to Bookings
            </a>
        </div>

        <!-- Payout Modal -->
        <div id="payoutModal" class="hidden fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity z-50 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-gray-800 rounded-lg overflow-hidden shadow-xl transform transition-all max-w-lg w-full">
                <div class="bg-green-600 px-6 py-4">
                    <h3 class="text-lg font-medium text-white">Mark Payout as Completed</h3>
                </div>

                <form action="{{ route('admin.payout.complete', $booking->id) }}" method="POST" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payout Amount</label>
                        <input type="text" value="RM {{ number_format($hostReceipt->host_payout, 2) }}" disabled class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-gray-100 dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payment Reference / Transaction ID <span class="text-red-500">*</span></label>
                        <input type="text" name="payout_reference" required class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100" placeholder="e.g., TXN123456789">
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Bank transfer reference or transaction ID</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Notes (Optional)</label>
                        <textarea name="payout_notes" rows="3" class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100" placeholder="Additional notes about this payout..."></textarea>
                    </div>

                    <div class="flex justify-end space-x-3 pt-4">
                        <button type="button" onclick="closePayoutModal()" class="px-4 py-2 bg-gray-300 hover:bg-gray-400 dark:bg-gray-600 dark:hover:bg-gray-500 text-gray-700 dark:text-gray-200 rounded-md transition">
                            Cancel
                        </button>
                        <button type="submit" class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md transition">
                            Confirm Payment
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <script>
            function openPayoutModal() {
                document.getElementById('payoutModal').classList.remove('hidden');
            }
            function closePayoutModal() {
                document.getElementById('payoutModal').classList.add('hidden');
            }
        </script>

        <!-- Receipt -->
        <div class="bg-white shadow-xl rounded-lg overflow-hidden receipt-container">
            <!-- Professional Header with Logo -->
            <div class="bg-gradient-to-r from-green-600 to-teal-600 px-8 py-6">
                <div class="flex justify-between items-center">
                    @if($showLogo && $siteLogo)
                        <div class="flex items-center">
                            <img src="{{ $siteLogo }}" alt="{{ $companyName }}" class="h-16 w-auto bg-white rounded-lg p-2">
                        </div>
                    @endif
                    <div class="text-right text-white">
                        <h1 class="text-2xl font-bold">{{ $companyName }}</h1>
                        @if($companyAddress)
                            <p class="text-sm opacity-90 mt-1">{{ $companyAddress }}</p>
                        @endif
                        @if($companyPhone)
                            <p class="text-sm opacity-90">Tel: {{ $companyPhone }}</p>
                        @endif
                        @if($companyEmail)
                            <p class="text-sm opacity-90">Email: {{ $companyEmail }}</p>
                        @endif
                        @if($companyWebsite)
                            <p class="text-sm opacity-90">{{ $companyWebsite }}</p>
                        @endif
                    </div>
                </div>
            </div>

            <div class="px-8 py-6">
                <!-- Receipt Title & Invoice Info -->
                <div class="border-b-2 border-gray-200 pb-6 mb-6">
                    <div class="flex justify-between items-start">
                        <div>
                            <h2 class="text-3xl font-bold text-gray-900 mb-2">HOST PAYOUT RECEIPT</h2>
                            <div class="text-sm text-gray-600 space-y-1">
                                <p><strong>Host Receipt #:</strong> <span class="font-mono text-green-600">{{ $hostReceipt->receipt_number }}</span></p>
                                <p><strong>Booking #:</strong> {{ $booking->id }}</p>
                                <p><strong>Invoice Number:</strong> <span class="font-mono text-indigo-600">{{ $booking->invoice_number }}</span></p>
                                <p><strong>Issue Date:</strong> {{ now()->format('M d, Y') }}</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="inline-flex px-4 py-2 rounded-lg
                                @if($hostReceipt->payout_status === 'completed') bg-green-100 text-green-800
                                @elseif($hostReceipt->payout_status === 'processing') bg-blue-100 text-blue-800
                                @elseif($hostReceipt->payout_status === 'failed') bg-red-100 text-red-800
                                @else bg-yellow-100 text-yellow-800
                                @endif">
                                <span class="font-bold text-sm uppercase">{{ ucfirst($hostReceipt->payout_status) }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Host Information -->
                <div class="grid grid-cols-2 gap-8 mb-8">
                    <div class="bg-green-50 rounded-lg p-5">
                        <h3 class="text-xs font-bold text-gray-500 uppercase tracking-wide mb-4">Host (Payee) Information</h3>
                        <div class="space-y-2.5">
                            <div>
                                <p class="text-xs text-gray-500">Name</p>
                                <p class="text-sm font-semibold text-gray-900">{{ $booking->listing->host->name }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Email</p>
                                <p class="text-sm text-gray-900">{{ $booking->listing->host->email }}</p>
                            </div>
                            @if($booking->listing->host->phone)
                                <div>
                                    <p class="text-xs text-gray-500">Phone</p>
                                    <p class="text-sm text-gray-900">{{ $booking->listing->host->phone }}</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="bg-gray-50 rounded-lg p-5">
                        <h3 class="text-xs font-bold text-gray-500 uppercase tracking-wide mb-4">Booking Details</h3>
                        <div class="space-y-2.5">
                            <div>
                                <p class="text-xs text-gray-500">Booking ID</p>
                                <p class="text-sm font-semibold text-gray-900">#{{ $booking->id }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Guest Name</p>
                                <p class="text-sm text-gray-900">{{ $booking->user->name }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Booking Date</p>
                                <p class="text-sm text-gray-900">{{ $booking->created_at->format('M d, Y h:i A') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Rental Property Details -->
                <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg p-6 mb-8 border border-gray-200">
                    <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                        Your Listing
                    </h3>
                    <p class="text-xl font-bold text-gray-900 mb-4">{{ $booking->listing->title }}</p>
                    <div class="grid grid-cols-3 gap-4">
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Type</p>
                            <p class="text-sm font-semibold text-gray-900">{{ $booking->listing->rentalType->name }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Location</p>
                            <p class="text-sm font-semibold text-gray-900">{{ $booking->listing->location->name }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Guests</p>
                            <p class="text-sm font-semibold text-gray-900">{{ $booking->guests }} {{ $booking->guests > 1 ? 'Guests' : 'Guest' }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Check-in</p>
                            <p class="text-sm font-semibold text-gray-900">{{ \Carbon\Carbon::parse($booking->check_in)->format('M d, Y') }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Check-out</p>
                            <p class="text-sm font-semibold text-gray-900">{{ \Carbon\Carbon::parse($booking->check_out)->format('M d, Y') }}</p>
                        </div>
                        <div>
                            <p class="text-xs text-gray-500 uppercase">Duration</p>
                            <p class="text-sm font-semibold text-gray-900">{{ $days }} {{ $days > 1 ? 'Days' : 'Day' }}</p>
                        </div>
                    </div>
                </div>

                <!-- Earnings Breakdown -->
                <div class="border-t-2 border-gray-200 pt-6">
                    <h3 class="text-lg font-bold text-gray-900 mb-5 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Earnings Breakdown
                    </h3>

                    <div class="space-y-3">
                        <!-- Base Rental -->
                        <div class="flex justify-between py-2">
                            <span class="text-gray-700">Base Rental (RM {{ number_format($booking->listing->price_per_day, 2) }} × {{ $days }} {{ $days > 1 ? 'days' : 'day' }})</span>
                            <span class="font-semibold text-gray-900">RM {{ number_format($hostReceipt->base_amount, 2) }}</span>
                        </div>

                        <!-- Add-ons -->
                        @if($hostReceipt->addon_amount > 0)
                            <div class="flex justify-between py-2">
                                <span class="text-gray-700">Add-ons Revenue</span>
                                <span class="font-semibold text-gray-900">RM {{ number_format($hostReceipt->addon_amount, 2) }}</span>
                            </div>
                        @endif

                        <!-- Discount -->
                        @if($hostReceipt->discount_amount > 0)
                            <div class="flex justify-between py-2 bg-orange-50 px-3 rounded">
                                <span class="text-orange-700 font-medium">Discount Applied</span>
                                <span class="font-semibold text-orange-700">-RM {{ number_format($hostReceipt->discount_amount, 2) }}</span>
                            </div>
                        @endif

                        <!-- Subtotal -->
                        <div class="flex justify-between py-3 border-t border-gray-200">
                            <span class="font-semibold text-gray-700">Gross Revenue</span>
                            <span class="font-semibold text-gray-900">RM {{ number_format($hostReceipt->subtotal, 2) }}</span>
                        </div>

                        <!-- DEDUCTIONS SECTION -->
                        <div class="bg-red-50 border border-red-200 rounded-lg p-4 my-4">
                            <h4 class="text-sm font-bold text-red-800 uppercase mb-3">Deductions</h4>

                            <!-- Platform Fee -->
                            <div class="flex justify-between py-2">
                                <span class="text-red-700">Platform Fee</span>
                                <span class="text-red-800 font-semibold">-RM {{ number_format($hostReceipt->platform_fee, 2) }}</span>
                            </div>

                            <!-- Service Fee -->
                            @if($hostReceipt->service_fee > 0)
                                <div class="flex justify-between py-2">
                                    <span class="text-red-700">Service Fee</span>
                                    <span class="text-red-800 font-semibold">-RM {{ number_format($hostReceipt->service_fee, 2) }}</span>
                                </div>
                            @endif

                            <!-- Total Deductions -->
                            <div class="flex justify-between py-2 border-t border-red-300 mt-2 pt-2">
                                <span class="font-bold text-red-800">Total Deductions</span>
                                <span class="font-bold text-red-800">-RM {{ number_format($hostReceipt->total_deductions, 2) }}</span>
                            </div>
                        </div>

                        <!-- HOST PAYOUT -->
                        <div class="flex justify-between py-4 border-t-2 border-gray-300 bg-gradient-to-r from-green-50 to-teal-50 px-4 rounded-lg">
                            <span class="text-xl font-bold text-gray-900">Your Payout</span>
                            <span class="text-2xl font-bold text-green-600">RM {{ number_format($hostReceipt->host_payout, 2) }}</span>
                        </div>

                        <!-- Payout Information -->
                        <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
                            <h4 class="text-sm font-bold text-blue-800 uppercase mb-3">Payout Information</h4>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <p class="text-xs text-blue-700">Status</p>
                                    <p class="text-sm font-bold
                                        @if($hostReceipt->payout_status === 'completed') text-green-700
                                        @elseif($hostReceipt->payout_status === 'processing') text-blue-700
                                        @elseif($hostReceipt->payout_status === 'failed') text-red-700
                                        @else text-yellow-700
                                        @endif">
                                        {{ ucfirst($hostReceipt->payout_status) }}
                                    </p>
                                </div>
                                @if($hostReceipt->payout_date)
                                    <div>
                                        <p class="text-xs text-blue-700">Payout Date</p>
                                        <p class="text-sm font-semibold text-blue-900">{{ $hostReceipt->payout_date->format('M d, Y h:i A') }}</p>
                                    </div>
                                @endif
                                @if($hostReceipt->payout_reference)
                                    <div class="col-span-2">
                                        <p class="text-xs text-blue-700">Reference Number</p>
                                        <p class="text-sm font-mono font-semibold text-blue-900">{{ $hostReceipt->payout_reference }}</p>
                                    </div>
                                @endif
                                @if($hostReceipt->payout_notes)
                                    <div class="col-span-2">
                                        <p class="text-xs text-blue-700">Notes</p>
                                        <p class="text-sm text-blue-900">{{ $hostReceipt->payout_notes }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="mt-10 pt-6 border-t border-gray-200">
                    <div class="text-center">
                        <p class="text-gray-700 font-medium text-lg mb-2">{{ $footerText }}</p>
                        @if($companyEmail)
                            <p class="text-sm text-gray-600 mb-1">
                                For inquiries, please contact us at
                                <a href="mailto:{{ $companyEmail }}" class="text-green-600 font-medium">{{ $companyEmail }}</a>
                            </p>
                        @endif
                        @if($companyPhone)
                            <p class="text-sm text-gray-600 mb-3">
                                Phone: <span class="font-medium">{{ $companyPhone }}</span>
                            </p>
                        @endif
                        <p class="text-xs text-gray-400 mt-4 italic">This is an automatically generated host receipt. This document serves as proof of earnings and platform deductions.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
