@php
    $companyName = \App\Models\Setting::get('receipt_company_name', \App\Helpers\SeoHelper::siteName());
    $companyAddress = \App\Models\Setting::get('receipt_company_address', '');
    $companyPhone = \App\Models\Setting::get('receipt_company_phone', '');
    $companyEmail = \App\Models\Setting::get('receipt_company_email', '');
    $companyWebsite = \App\Models\Setting::get('receipt_website', url('/'));
    $footerText = \App\Models\Setting::get('receipt_footer_text', 'Thank you for your business!');
    $showLogo = \App\Models\Setting::get('receipt_show_logo', true);
    $siteLogo = \App\Helpers\SeoHelper::logo();

    $days = \Carbon\Carbon::parse($booking->check_in)->diffInDays(\Carbon\Carbon::parse($booking->check_out));
    $hostReceipt = $booking->hostReceipt;
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Host Receipt #{{ $hostReceipt->receipt_number }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 10px; }
            .receipt-container { box-shadow: none !important; max-width: 100%; }
        }
        @page {
            size: A4;
            margin: 0.5cm;
        }
        body { font-size: 13px; }
    </style>
</head>
<body class="bg-gray-50">
    <div class="max-w-3xl mx-auto p-4">
        <!-- Action Buttons -->
        <div class="mb-4 no-print flex gap-2">
            <button onclick="window.print()" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg text-sm font-medium shadow-sm">
                Print Receipt
            </button>
            <a href="{{ route('booking.receipt', $booking->id) }}" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm inline-block font-medium shadow-sm">
                View Guest Receipt
            </a>

            @if(auth()->user()->isAdmin() && $hostReceipt->payout_status !== 'completed')
                <button onclick="openPayoutModal()" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg text-sm font-medium shadow-sm">
                    Mark as Paid
                </button>
            @endif

            <a href="{{ auth()->user()->isAdmin() ? route('admin.bookings') : route('host.bookings') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg text-sm inline-block font-medium shadow-sm">
                Back to Bookings
            </a>
        </div>

        <!-- Payout Modal -->
        <div id="payoutModal" class="hidden fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity z-50 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-gray-800 rounded-lg overflow-hidden shadow-xl transform transition-all max-w-lg w-full">
                <div class="bg-green-600 px-6 py-4">
                    <h3 class="text-lg font-medium text-white">Mark Payout as Completed</h3>
                </div>

                <form action="{{ route('admin.payout.complete', $booking->id) }}" method="POST" class="p-6 space-y-4">
                    @csrf
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payout Amount</label>
                        <input type="text" value="RM {{ number_format($hostReceipt->host_payout, 2) }}" disabled class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-gray-100 dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Payment Reference / Transaction ID <span class="text-red-500">*</span></label>
                        <input type="text" name="payout_reference" required class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100" placeholder="e.g., TXN123456789">
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Bank transfer reference or transaction ID</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Notes (Optional)</label>
                        <textarea name="payout_notes" rows="3" class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100" placeholder="Additional notes about this payout..."></textarea>
                    </div>

                    <div class="flex justify-end space-x-3 pt-4">
                        <button type="button" onclick="closePayoutModal()" class="px-4 py-2 bg-gray-300 hover:bg-gray-400 dark:bg-gray-600 dark:hover:bg-gray-500 text-gray-700 dark:text-gray-200 rounded-md transition">
                            Cancel
                        </button>
                        <button type="submit" class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md transition">
                            Confirm Payment
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <script>
            function openPayoutModal() {
                document.getElementById('payoutModal').classList.remove('hidden');
            }
            function closePayoutModal() {
                document.getElementById('payoutModal').classList.add('hidden');
            }
        </script>

        <!-- Compact Host Receipt -->
        <div class="bg-white shadow-lg rounded-lg overflow-hidden receipt-container">
            <!-- Header -->
            <div class="bg-green-800 text-white px-6 py-4">
                <div class="flex justify-between items-center">
                    <div class="flex items-center gap-3">
                        @if($showLogo && $siteLogo)
                            <img src="{{ $siteLogo }}" alt="{{ $companyName }}" class="h-12 w-auto bg-white rounded p-1">
                        @endif
                        <div>
                            <h1 class="text-lg font-bold">{{ $companyName }}</h1>
                            <p class="text-xs opacity-80">{{ $companyWebsite }}</p>
                        </div>
                    </div>
                    <div class="text-right text-xs">
                        @if($companyAddress)<p class="opacity-90">{{ $companyAddress }}</p>@endif
                        @if($companyPhone)<p class="opacity-90">Tel: {{ $companyPhone }}</p>@endif
                        @if($companyEmail)<p class="opacity-90">{{ $companyEmail }}</p>@endif
                    </div>
                </div>
            </div>

            <div class="px-6 py-4">
                <!-- Title & Invoice -->
                <div class="flex justify-between items-center mb-4 pb-3 border-b-2 border-gray-200">
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">HOST PAYOUT RECEIPT</h2>
                        <p class="text-xs text-gray-600 mt-1">Host Receipt: <span class="font-mono text-green-600">{{ $hostReceipt->receipt_number }}</span></p>
                        <p class="text-xs text-gray-600">Booking #{{ $booking->id }} | Invoice: <span class="font-mono text-indigo-600">{{ $booking->invoice_number }}</span></p>
                    </div>
                    <div class="text-right">
                        <p class="text-xs text-gray-600">Issue Date</p>
                        <p class="text-sm font-semibold">{{ now()->format('M d, Y') }}</p>
                        <span class="inline-block mt-1 px-3 py-1 rounded text-xs font-bold
                            @if($hostReceipt->payout_status === 'completed') bg-green-100 text-green-800
                            @elseif($hostReceipt->payout_status === 'processing') bg-blue-100 text-blue-800
                            @elseif($hostReceipt->payout_status === 'failed') bg-red-100 text-red-800
                            @else bg-yellow-100 text-yellow-800
                            @endif">
                            {{ strtoupper($hostReceipt->payout_status) }}
                        </span>
                    </div>
                </div>

                <!-- Host & Guest Info - Compact Grid -->
                <div class="grid grid-cols-2 gap-4 mb-4 text-xs">
                    <div>
                        <p class="font-bold text-gray-700 uppercase mb-1">Host (Payee)</p>
                        <p class="font-semibold">{{ $booking->listing->host->name }}</p>
                        <p class="text-gray-600">{{ $booking->listing->host->email }}</p>
                        @if($booking->listing->host->phone)<p class="text-gray-600">{{ $booking->listing->host->phone }}</p>@endif
                    </div>
                    <div>
                        <p class="font-bold text-gray-700 uppercase mb-1">Guest</p>
                        <p class="font-semibold">{{ $booking->user->name }}</p>
                        <p class="text-gray-600">{{ $booking->user->email }}</p>
                        <p><span class="text-gray-600">Booked:</span> {{ $booking->created_at->format('M d, Y') }}</p>
                    </div>
                </div>

                <!-- Property Details - Compact -->
                <div class="bg-gray-50 rounded p-3 mb-4">
                    <p class="font-bold text-sm mb-2">{{ $booking->listing->title }}</p>
                    <div class="grid grid-cols-3 gap-3 text-xs">
                        <div><span class="text-gray-600">Type:</span> <span class="font-semibold">{{ $booking->listing->rentalType->name }}</span></div>
                        <div><span class="text-gray-600">Location:</span> <span class="font-semibold">{{ $booking->listing->location->name }}</span></div>
                        <div><span class="text-gray-600">Guests:</span> <span class="font-semibold">{{ $booking->guests }}</span></div>
                        <div><span class="text-gray-600">Check-in:</span> <span class="font-semibold">{{ \Carbon\Carbon::parse($booking->check_in)->format('M d, Y') }}</span></div>
                        <div><span class="text-gray-600">Check-out:</span> <span class="font-semibold">{{ \Carbon\Carbon::parse($booking->check_out)->format('M d, Y') }}</span></div>
                        <div><span class="text-gray-600">Duration:</span> <span class="font-semibold">{{ $days }} {{ $days > 1 ? 'days' : 'day' }}</span></div>
                    </div>
                </div>

                <!-- Earnings Breakdown - Compact Table -->
                <div class="border-t-2 border-gray-200 pt-3">
                    <table class="w-full text-sm">
                        <tbody>
                            <tr class="border-b border-gray-100">
                                <td class="py-1.5 text-gray-700">Base Rental (RM {{ number_format($booking->listing->price_per_day, 2) }} × {{ $days }} {{ $days > 1 ? 'days' : 'day' }})</td>
                                <td class="py-1.5 text-right font-semibold">RM {{ number_format($hostReceipt->base_amount, 2) }}</td>
                            </tr>

                            @if($hostReceipt->addon_amount > 0)
                                <tr class="border-b border-gray-100">
                                    <td class="py-1.5 text-gray-700">Add-ons Revenue</td>
                                    <td class="py-1.5 text-right font-semibold">RM {{ number_format($hostReceipt->addon_amount, 2) }}</td>
                                </tr>
                            @endif

                            @if($hostReceipt->discount_amount > 0)
                                <tr class="border-b border-gray-100 bg-orange-50">
                                    <td class="py-1.5 text-orange-700 font-medium">Discount Applied</td>
                                    <td class="py-1.5 text-right font-semibold text-orange-700">-RM {{ number_format($hostReceipt->discount_amount, 2) }}</td>
                                </tr>
                            @endif

                            <tr class="border-t border-gray-300">
                                <td class="py-1.5 font-semibold text-gray-700">Gross Revenue</td>
                                <td class="py-1.5 text-right font-semibold">RM {{ number_format($hostReceipt->subtotal, 2) }}</td>
                            </tr>

                            <!-- DEDUCTIONS -->
                            <tr class="bg-red-50 border-b border-gray-100">
                                <td class="py-1.5 text-red-700">Platform Fee</td>
                                <td class="py-1.5 text-right font-semibold text-red-700">-RM {{ number_format($hostReceipt->platform_fee, 2) }}</td>
                            </tr>

                            @if($hostReceipt->service_fee > 0)
                                <tr class="bg-red-50 border-b border-gray-100">
                                    <td class="py-1.5 text-red-700">Service Fee</td>
                                    <td class="py-1.5 text-right font-semibold text-red-700">-RM {{ number_format($hostReceipt->service_fee, 2) }}</td>
                                </tr>
                            @endif

                            <tr class="bg-red-50">
                                <td class="py-1.5 font-semibold text-red-800">Total Deductions</td>
                                <td class="py-1.5 text-right font-semibold text-red-800">-RM {{ number_format($hostReceipt->total_deductions, 2) }}</td>
                            </tr>

                            <!-- HOST PAYOUT -->
                            <tr class="border-t-2 border-gray-400 bg-green-50">
                                <td class="py-2 font-bold text-lg">YOUR PAYOUT</td>
                                <td class="py-2 text-right font-bold text-xl text-green-600">RM {{ number_format($hostReceipt->host_payout, 2) }}</td>
                            </tr>
                        </tbody>
                    </table>

                    <!-- Payout Information -->
                    <div class="mt-3 bg-blue-50 border border-blue-200 rounded p-3 text-xs">
                        <p class="font-bold text-blue-800 uppercase mb-2">Payout Information</p>
                        <div class="grid grid-cols-2 gap-2">
                            <div>
                                <span class="text-blue-700">Status:</span>
                                <span class="font-bold
                                    @if($hostReceipt->payout_status === 'completed') text-green-700
                                    @elseif($hostReceipt->payout_status === 'processing') text-blue-700
                                    @elseif($hostReceipt->payout_status === 'failed') text-red-700
                                    @else text-yellow-700
                                    @endif">
                                    {{ ucfirst($hostReceipt->payout_status) }}
                                </span>
                            </div>
                            @if($hostReceipt->payout_date)
                                <div>
                                    <span class="text-blue-700">Date:</span>
                                    <span class="font-semibold">{{ $hostReceipt->payout_date->format('M d, Y') }}</span>
                                </div>
                            @endif
                            @if($hostReceipt->payout_reference)
                                <div class="col-span-2">
                                    <span class="text-blue-700">Reference:</span>
                                    <span class="font-mono font-semibold">{{ $hostReceipt->payout_reference }}</span>
                                </div>
                            @endif
                            @if($hostReceipt->payout_notes)
                                <div class="col-span-2">
                                    <span class="text-blue-700">Notes:</span>
                                    <span>{{ $hostReceipt->payout_notes }}</span>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="bg-gray-50 px-6 py-3 border-t border-gray-200 text-center text-xs text-gray-600">
                <p class="font-medium mb-1">{{ $footerText }}</p>
                @if($companyEmail)
                    <p>Contact: <a href="mailto:{{ $companyEmail }}" class="text-green-600">{{ $companyEmail }}</a>
                    @if($companyPhone) | Tel: {{ $companyPhone }}@endif</p>
                @endif
                <p class="text-gray-400 mt-1 italic">Automatically generated host receipt. Proof of earnings and deductions.</p>
            </div>
        </div>
    </div>
</body>
</html>
