<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Listing;

class SampleListingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $listings = [
            [
                'rental_type_id' => 1, // Car
                'location_id' => 12, // Penang
                'user_id' => 2, // host@example.com
                'title' => 'Luxury Toyota Camry 2023 - Penang Airport Pickup',
                'description' => 'Experience comfort and style with our brand new Toyota Camry 2023. Perfect for business trips or family vacations. Features include leather seats, advanced safety systems, GPS navigation, and excellent fuel economy. Airport pickup/drop-off available. The car is meticulously maintained and cleaned after each rental.',
                'price_per_day' => 180.00,
                'capacity' => 5,
                'available_units' => 2,
                'images' => [
                    'https://images.unsplash.com/photo-1621007947382-bb3c3994e3fb?w=800',
                    'https://images.unsplash.com/photo-1555215695-3004980ad54e?w=800',
                    'https://images.unsplash.com/photo-1552519507-da3b142c6e3d?w=800'
                ],
                'amenities' => [
                    'Air Conditioning',
                    'GPS Navigation',
                    'Bluetooth Audio',
                    'Leather Seats',
                    'Backup Camera',
                    'USB Charging Ports',
                    'Child Seat Available'
                ],
                'is_available' => true,
                'is_featured' => true,
            ],
            [
                'rental_type_id' => 2, // Houseboat
                'location_id' => 6, // Terengganu
                'user_id' => 2,
                'title' => 'Traditional Floating Home - Terengganu River View',
                'description' => 'Unique experience staying on a traditional Malaysian houseboat along the beautiful Terengganu River. This charming floating home offers 2 bedrooms, a fully equipped kitchen, and a spacious deck perfect for sunset viewing. Wake up to the gentle sound of water and enjoy fishing right from your doorstep. Ideal for families or couples seeking a peaceful retreat.',
                'price_per_day' => 350.00,
                'capacity' => 6,
                'available_units' => 1,
                'images' => [
                    'https://images.unsplash.com/photo-1544551763-46a013bb70d5?w=800',
                    'https://images.unsplash.com/photo-1566073771259-6a8506099945?w=800',
                    'https://images.unsplash.com/photo-1582268611958-ebfd161ef9cf?w=800'
                ],
                'amenities' => [
                    'Full Kitchen',
                    '2 Bedrooms',
                    'Private Bathroom',
                    'Fishing Equipment',
                    'BBQ Grill',
                    'Life Jackets',
                    'WiFi',
                    'Solar Power',
                    'Kayak Included'
                ],
                'is_available' => true,
                'is_featured' => true,
            ],
            [
                'rental_type_id' => 3, // Guesthouse
                'location_id' => 10, // Melaka
                'user_id' => 2,
                'title' => 'Heritage Guesthouse - Melaka UNESCO Old Town',
                'description' => 'Step back in time at our beautifully restored heritage guesthouse in the heart of Melaka\'s UNESCO World Heritage Site. Walking distance to Jonker Street, Christ Church, and A Famosa. Features traditional Peranakan architecture with modern amenities. 4 ensuite bedrooms, communal lounge, rooftop terrace with city views. Perfect for cultural explorers and history enthusiasts.',
                'price_per_day' => 280.00,
                'capacity' => 8,
                'available_units' => 1,
                'images' => [
                    'https://images.unsplash.com/photo-1566073771259-6a8506099945?w=800',
                    'https://images.unsplash.com/photo-1520250497591-112f2f40a3f4?w=800',
                    'https://images.unsplash.com/photo-1564501049412-61c2a3083791?w=800'
                ],
                'amenities' => [
                    '4 Ensuite Bedrooms',
                    'Air Conditioning',
                    'Rooftop Terrace',
                    'Common Lounge',
                    'WiFi',
                    'Kitchen Access',
                    'Laundry Facilities',
                    'Bicycle Rental',
                    'Tour Booking Service'
                ],
                'is_available' => true,
                'is_featured' => true,
            ],
            [
                'rental_type_id' => 4, // Boat
                'location_id' => 15, // Sabah
                'user_id' => 2,
                'title' => 'Island Hopping Speed Boat - Sabah Marine Adventures',
                'description' => 'Explore the stunning islands of Sabah with our comfortable 8-seater speedboat! Perfect for island hopping, snorkeling, and diving trips to Tunku Abdul Rahman Marine Park. Includes experienced captain, safety equipment, snorkeling gear, and cooler box. Create unforgettable memories exploring crystal-clear waters and pristine beaches. Full day or half day rentals available.',
                'price_per_day' => 450.00,
                'capacity' => 8,
                'available_units' => 2,
                'images' => [
                    'https://images.unsplash.com/photo-1559827260-dc66d52bef19?w=800',
                    'https://images.unsplash.com/photo-1540946485063-a40da27545f8?w=800',
                    'https://images.unsplash.com/photo-1544551763-46a013bb70d5?w=800'
                ],
                'amenities' => [
                    'Experienced Captain',
                    'Safety Equipment',
                    'Snorkeling Gear',
                    'Life Jackets',
                    'Cooler Box',
                    'Sun Shade',
                    'First Aid Kit',
                    'Bluetooth Speaker',
                    'Fishing Equipment Available'
                ],
                'is_available' => true,
                'is_featured' => true,
            ],
            [
                'rental_type_id' => 1, // Car
                'location_id' => 9, // Johor
                'user_id' => 2,
                'title' => 'Family MPV Honda Odyssey - Johor Bahru to Singapore',
                'description' => 'Spacious and comfortable Honda Odyssey perfect for family trips between Johor Bahru and Singapore. Seats 7 passengers with ample luggage space. Ideal for Legoland trips or shopping excursions. Equipped with child seats, entertainment system, and all modern safety features. Cross-border travel allowed with prior notice. Well-maintained vehicle with comprehensive insurance.',
                'price_per_day' => 220.00,
                'capacity' => 7,
                'available_units' => 3,
                'images' => [
                    'https://images.unsplash.com/photo-1519641471654-76ce0107ad1b?w=800',
                    'https://images.unsplash.com/photo-1570733577333-5f5b7f8d9a4d?w=800',
                    'https://images.unsplash.com/photo-1549317661-bd32c8ce0db2?w=800'
                ],
                'amenities' => [
                    'Air Conditioning',
                    'Entertainment System',
                    'Child Seats Available',
                    'GPS Navigation',
                    'USB Ports',
                    'Bluetooth',
                    'Backup Camera',
                    'Large Boot Space',
                    'Singapore Travel Allowed'
                ],
                'is_available' => true,
                'is_featured' => false,
            ],
        ];

        foreach ($listings as $listing) {
            Listing::create($listing);
        }
    }
}
