<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\RentalType;
use App\Models\Location;
use App\Models\User;
use App\Models\Listing;

class RentalSystemSeeder extends Seeder
{
    public function run(): void
    {
        // Create rental types
        $rentalTypes = [
            ['name' => 'Car', 'slug' => 'car', 'description' => 'Rent various types of cars'],
            ['name' => 'Houseboat', 'slug' => 'houseboat', 'description' => 'Experience living on water'],
            ['name' => 'Guesthouse', 'slug' => 'guesthouse', 'description' => 'Comfortable accommodation'],
            ['name' => 'Boat', 'slug' => 'boat', 'description' => 'Water transportation and leisure'],
        ];

        foreach ($rentalTypes as $type) {
            RentalType::create($type);
        }

        // Create locations
        $locations = [
            ['name' => 'Langkawi', 'slug' => 'langkawi', 'description' => 'Beautiful island', 'is_popular' => true, 'image' => 'https://placehold.co/400x300/0ea5e9/white?text=Langkawi'],
            ['name' => 'Penang', 'slug' => 'penang', 'description' => 'Food paradise', 'is_popular' => true, 'image' => 'https://placehold.co/400x300/8b5cf6/white?text=Penang'],
            ['name' => 'Kuala Lumpur', 'slug' => 'kuala-lumpur', 'description' => 'Capital city', 'is_popular' => true, 'image' => 'https://placehold.co/400x300/10b981/white?text=KL'],
            ['name' => 'Melaka', 'slug' => 'melaka', 'description' => 'Historical city', 'is_popular' => true, 'image' => 'https://placehold.co/400x300/f59e0b/white?text=Melaka'],
            ['name' => 'Johor Bahru', 'slug' => 'johor-bahru', 'description' => 'Southern gateway', 'is_popular' => false, 'image' => 'https://placehold.co/400x300/ef4444/white?text=JB'],
        ];

        foreach ($locations as $location) {
            Location::create($location);
        }

        // Create test accounts with email verified
        $admin = User::create([
            'name' => 'Admin User',
            'email' => 'admin@gengsewa.com',
            'phone' => '+60111111111',
            'password' => bcrypt('password'),
            'role' => 'admin',
            'email_verified_at' => now(),
        ]);

        $host = User::create([
            'name' => 'Demo Host',
            'email' => 'host@example.com',
            'phone' => '+60123456789',
            'password' => bcrypt('password'),
            'role' => 'host',
            'email_verified_at' => now(),
        ]);

        $demoUser = User::create([
            'name' => 'Demo User',
            'email' => 'user@example.com',
            'phone' => '+60199999999',
            'password' => bcrypt('password'),
            'role' => 'user',
            'email_verified_at' => now(),
        ]);

        // Create sample listings (owned by host)
        $listings = [
            [
                'rental_type_id' => 1,
                'location_id' => 1,
                'user_id' => $host->id,
                'title' => 'Toyota Vios 2023',
                'description' => 'Comfortable sedan perfect for family trips',
                'price_per_day' => 120.00,
                'capacity' => 5,
                'is_featured' => true,
                'images' => ['https://placehold.co/800x400/3b82f6/white?text=Toyota+Vios'],
            ],
            [
                'rental_type_id' => 2,
                'location_id' => 1,
                'user_id' => $host->id,
                'title' => 'Luxury Houseboat',
                'description' => 'Experience luxury living on the water with stunning sunset views',
                'price_per_day' => 450.00,
                'capacity' => 6,
                'is_featured' => true,
                'images' => ['https://placehold.co/800x400/14b8a6/white?text=Luxury+Houseboat'],
            ],
            [
                'rental_type_id' => 3,
                'location_id' => 2,
                'user_id' => $host->id,
                'title' => 'Cozy Guesthouse',
                'description' => 'Traditional Malaysian guesthouse near Georgetown',
                'price_per_day' => 180.00,
                'capacity' => 4,
                'is_featured' => true,
                'images' => ['https://placehold.co/800x400/f59e0b/white?text=Cozy+Guesthouse'],
            ],
        ];

        foreach ($listings as $listing) {
            Listing::create($listing);
        }
    }
}
