<?php

namespace Database\Seeders;

use App\Models\PickupLocation;
use Illuminate\Database\Seeder;

class PickupLocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $locations = [
            // Airports
            [
                'name' => 'Kuala Lumpur International Airport (KLIA)',
                'address' => 'KLIA, 64000 Sepang, Selangor',
                'type' => 'airport',
                'latitude' => 2.745578,
                'longitude' => 101.709917,
                'is_active' => true,
            ],
            [
                'name' => 'KLIA2 Terminal',
                'address' => 'KLIA2, 64000 Sepang, Selangor',
                'type' => 'airport',
                'latitude' => 2.738258,
                'longitude' => 101.698992,
                'is_active' => true,
            ],
            [
                'name' => 'Langkawi International Airport',
                'address' => 'Padang Matsirat, 07100 Langkawi, Kedah',
                'type' => 'airport',
                'latitude' => 6.329728,
                'longitude' => 99.728667,
                'is_active' => true,
            ],
            [
                'name' => 'Penang International Airport',
                'address' => 'Lapangan Terbang Antarabangsa Pulau Pinang, 11900 Bayan Lepas, Penang',
                'type' => 'airport',
                'latitude' => 5.297139,
                'longitude' => 100.276864,
                'is_active' => true,
            ],

            // Public Spots - Langkawi
            [
                'name' => 'Kuah Jetty, Langkawi',
                'address' => 'Kuah Jetty, 07000 Langkawi, Kedah',
                'type' => 'public_spot',
                'latitude' => 6.323611,
                'longitude' => 99.841944,
                'is_active' => true,
            ],
            [
                'name' => 'Pantai Cenang, Langkawi',
                'address' => 'Pantai Cenang, 07000 Langkawi, Kedah',
                'type' => 'public_spot',
                'latitude' => 6.289722,
                'longitude' => 99.720556,
                'is_active' => true,
            ],

            // Public Spots - Kuala Lumpur
            [
                'name' => 'KL Sentral Station',
                'address' => 'KL Sentral, 50470 Kuala Lumpur',
                'type' => 'public_spot',
                'latitude' => 3.133611,
                'longitude' => 101.686667,
                'is_active' => true,
            ],
            [
                'name' => 'Pavilion KL Shopping Mall',
                'address' => '168, Jalan Bukit Bintang, 55100 Kuala Lumpur',
                'type' => 'public_spot',
                'latitude' => 3.149394,
                'longitude' => 101.713167,
                'is_active' => true,
            ],
            [
                'name' => 'KLCC - Suria KLCC',
                'address' => 'Suria KLCC, Kuala Lumpur City Centre, 50088 Kuala Lumpur',
                'type' => 'public_spot',
                'latitude' => 3.157778,
                'longitude' => 101.711944,
                'is_active' => true,
            ],

            // Hotels
            [
                'name' => 'The Westin Langkawi Resort & Spa',
                'address' => 'Jalan Pantai Dato Syed Omar, 07000 Langkawi, Kedah',
                'type' => 'hotel',
                'latitude' => 6.320833,
                'longitude' => 99.723889,
                'is_active' => true,
            ],
            [
                'name' => 'Mandarin Oriental Kuala Lumpur',
                'address' => 'Kuala Lumpur City Centre, 50088 Kuala Lumpur',
                'type' => 'hotel',
                'latitude' => 3.154444,
                'longitude' => 101.714444,
                'is_active' => true,
            ],

            // Public Spots - Penang
            [
                'name' => 'Georgetown Ferry Terminal',
                'address' => 'Pengkalan Weld, 10300 George Town, Penang',
                'type' => 'public_spot',
                'latitude' => 5.414444,
                'longitude' => 100.340556,
                'is_active' => true,
            ],
        ];

        foreach ($locations as $location) {
            PickupLocation::create($location);
        }
    }
}
