<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Location;

class MalaysiaLocationsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $locations = [
            // 13 States
            'Johor',
            'Kedah',
            'Kelantan',
            'Malacca',
            'Negeri Sembilan',
            'Pahang',
            'Penang',
            'Perak',
            'Perlis',
            'Sabah',
            'Sarawak',
            'Selangor',
            'Terengganu',

            // Federal Territories
            'Kuala Lumpur',
            'Labuan',
            'Putrajaya',
        ];

        $popular = ['Kuala Lumpur', 'Penang', 'Langkawi', 'Sabah', 'Sarawak'];

        foreach ($locations as $name) {
            Location::create([
                'name' => $name,
                'slug' => \Str::slug($name),
                'description' => "Explore amazing rentals in {$name}, Malaysia",
                'is_popular' => in_array($name, $popular),
            ]);
        }
    }
}
