<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PickupLocation;

class MalaysiaAirportsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $airports = [
            ['name' => 'Kuala Lumpur International Airport (KLIA)', 'address' => 'Sepang, Selangor', 'is_active' => true, 'created_by' => null],
            ['name' => 'Sultan Abdul Aziz Shah Airport (Subang)', 'address' => 'Subang, Selangor', 'is_active' => true, 'created_by' => null],
            ['name' => 'Penang International Airport', 'address' => 'Bayan Lepas, Penang', 'is_active' => true, 'created_by' => null],
            ['name' => 'Kota Kinabalu International Airport', 'address' => 'Kota Kinabalu, Sabah', 'is_active' => true, 'created_by' => null],
            ['name' => 'Kuching International Airport', 'address' => 'Kuching, Sarawak', 'is_active' => true, 'created_by' => null],
            ['name' => 'Langkawi International Airport', 'address' => 'Langkawi, Kedah', 'is_active' => true, 'created_by' => null],
            ['name' => 'Senai International Airport', 'address' => 'Johor Bahru, Johor', 'is_active' => true, 'created_by' => null],
            ['name' => 'Sultan Mahmud Airport', 'address' => 'Kuala Terengganu, Terengganu', 'is_active' => true, 'created_by' => null],
            ['name' => 'Sultan Azlan Shah Airport', 'address' => 'Ipoh, Perak', 'is_active' => true, 'created_by' => null],
            ['name' => 'Melaka International Airport', 'address' => 'Batu Berendam, Malacca', 'is_active' => true, 'created_by' => null],
            ['name' => 'Sultan Ismail Petra Airport', 'address' => 'Kota Bharu, Kelantan', 'is_active' => true, 'created_by' => null],
            ['name' => 'Sultan Abdul Halim Airport', 'address' => 'Alor Setar, Kedah', 'is_active' => true, 'created_by' => null],
            ['name' => 'Labuan Airport', 'address' => 'Labuan, Federal Territory', 'is_active' => true, 'created_by' => null],
            ['name' => 'Tawau Airport', 'address' => 'Tawau, Sabah', 'is_active' => true, 'created_by' => null],
            ['name' => 'Sandakan Airport', 'address' => 'Sandakan, Sabah', 'is_active' => true, 'created_by' => null],
            ['name' => 'Miri Airport', 'address' => 'Miri, Sarawak', 'is_active' => true, 'created_by' => null],
            ['name' => 'Bintulu Airport', 'address' => 'Bintulu, Sarawak', 'is_active' => true, 'created_by' => null],
            ['name' => 'Sibu Airport', 'address' => 'Sibu, Sarawak', 'is_active' => true, 'created_by' => null],
        ];

        foreach ($airports as $airport) {
            PickupLocation::create($airport);
        }
    }
}
