<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RentalType;
use App\Models\Amenity;

class FishingTripSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Fishing Trip rental type
        $rentalType = RentalType::firstOrCreate(
            ['name' => 'Fishing Trip'],
            ['is_active' => true]
        );

        // Create amenities for Fishing Trip
        $amenities = [
            'Fishing Rods & Equipment',
            'Bait & Tackle',
            'Life Jackets',
            'Experienced Guide',
            'Cooler Box',
            'Sun Shade',
            'First Aid Kit',
            'Refreshments Included',
            'Fish Cleaning Service',
            'GPS Navigation',
            'Safety Equipment',
            'Toilet Facilities',
        ];

        $sortOrder = 0;
        foreach ($amenities as $amenityName) {
            Amenity::firstOrCreate(
                [
                    'name' => $amenityName,
                    'rental_type_id' => $rentalType->id,
                ],
                [
                    'is_active' => true,
                    'sort_order' => $sortOrder++,
                ]
            );
        }
    }
}
