<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EmailTemplate;

class EmailTemplateSeeder extends Seeder
{
    public function run(): void
    {
        $templates = [
            [
                'name' => 'welcome',
                'subject' => 'Welcome to {{site_name}}!',
                'body' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8"></head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0;">
        <img src="{{logo_url}}" alt="{{site_name}}" style="max-width: 150px; margin-bottom: 20px;">
        <h1 style="margin: 0;">Welcome to {{site_name}}!</h1>
    </div>
    <div style="background: #fff; padding: 30px; border: 1px solid #e5e7eb;">
        <p>Hello {{user_name}},</p>
        <p>Thank you for joining {{site_name}}! We are excited to have you on board.</p>
        <p>Start exploring our platform and discover amazing rental opportunities.</p>
        <p style="margin-top: 30px;">Best regards,<br><strong>The {{site_name}} Team</strong></p>
    </div>
    <div style="text-align: center; margin-top: 20px; padding-top: 20px; border-top: 2px solid #e5e7eb; color: #6b7280; font-size: 14px;">
        <p>© {{year}} {{site_name}}. All rights reserved.</p>
    </div>
</body>
</html>',
                'enabled' => true,
            ],
            [
                'name' => 'verify_email',
                'subject' => 'Verify Your Email Address',
                'body' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8"></head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0;">
        <h1 style="margin: 0;">Verify Your Email</h1>
    </div>
    <div style="background: #fff; padding: 30px; border: 1px solid #e5e7eb;">
        <p>Hello {{user_name}},</p>
        <p>Please click the button below to verify your email address:</p>
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{verification_url}}" style="display: inline-block; background: #3b82f6; color: white; padding: 12px 30px; text-decoration: none; border-radius: 6px;">Verify Email Address</a>
        </div>
        <p>If you did not create an account, no further action is required.</p>
        <p style="margin-top: 30px;">Best regards,<br><strong>The {{site_name}} Team</strong></p>
    </div>
    <div style="text-align: center; margin-top: 20px; padding-top: 20px; border-top: 2px solid #e5e7eb; color: #6b7280; font-size: 14px;">
        <p>© {{year}} {{site_name}}. All rights reserved.</p>
    </div>
</body>
</html>',
                'enabled' => true,
            ],
            [
                'name' => 'reset_password',
                'subject' => 'Reset Your Password',
                'body' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8"></head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0;">
        <h1 style="margin: 0;">Reset Your Password</h1>
    </div>
    <div style="background: #fff; padding: 30px; border: 1px solid #e5e7eb;">
        <p>Hello {{user_name}},</p>
        <p>You are receiving this email because we received a password reset request for your account.</p>
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{reset_url}}" style="display: inline-block; background: #f59e0b; color: white; padding: 12px 30px; text-decoration: none; border-radius: 6px;">Reset Password</a>
        </div>
        <p>If you did not request a password reset, no further action is required.</p>
        <p style="margin-top: 30px;">Best regards,<br><strong>The {{site_name}} Team</strong></p>
    </div>
    <div style="text-align: center; margin-top: 20px; padding-top: 20px; border-top: 2px solid #e5e7eb; color: #6b7280; font-size: 14px;">
        <p>© {{year}} {{site_name}}. All rights reserved.</p>
    </div>
</body>
</html>',
                'enabled' => true,
            ],
            [
                'name' => 'booking_success',
                'subject' => 'Booking Confirmation - {{listing_title}}',
                'body' => '<!DOCTYPE html>
<html>
<head><meta charset="UTF-8"></head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0;">
        <h1 style="margin: 0;">🎉 Booking Confirmed!</h1>
    </div>
    <div style="background: #fff; padding: 30px; border: 1px solid #e5e7eb;">
        <p>Hello {{customer_name}},</p>
        <p>Your booking has been confirmed! Here are your booking details:</p>

        <div style="background: #f9fafb; padding: 20px; border-radius: 8px; margin: 20px 0;">
            <h2 style="margin-top: 0; color: #111827;">{{listing_title}}</h2>
            <table style="width: 100%; border-collapse: collapse;">
                <tr><td style="padding: 8px 0; border-bottom: 1px solid #e5e7eb;"><strong>Invoice Number:</strong></td><td style="padding: 8px 0; border-bottom: 1px solid #e5e7eb;">{{invoice_number}}</td></tr>
                <tr><td style="padding: 8px 0; border-bottom: 1px solid #e5e7eb;"><strong>Check-in:</strong></td><td style="padding: 8px 0; border-bottom: 1px solid #e5e7eb;">{{check_in}}</td></tr>
                <tr><td style="padding: 8px 0; border-bottom: 1px solid #e5e7eb;"><strong>Check-out:</strong></td><td style="padding: 8px 0; border-bottom: 1px solid #e5e7eb;">{{check_out}}</td></tr>
                <tr><td style="padding: 8px 0; border-bottom: 1px solid #e5e7eb;"><strong>Guests:</strong></td><td style="padding: 8px 0; border-bottom: 1px solid #e5e7eb;">{{guests}}</td></tr>
                <tr><td style="padding: 8px 0;"><strong>Total Amount:</strong></td><td style="padding: 8px 0; color: #10b981; font-size: 18px; font-weight: bold;">RM {{total_price}}</td></tr>
            </table>
        </div>

        <div style="background: #fef3c7; border-left: 4px solid #f59e0b; padding: 15px; border-radius: 4px; margin: 20px 0;">
            <h3 style="margin-top: 0; color: #92400e;">Host Contact Information</h3>
            <p style="margin: 5px 0;"><strong>Name:</strong> {{host_name}}</p>
            <p style="margin: 5px 0;"><strong>Email:</strong> {{host_email}}</p>
            <p style="margin: 5px 0;"><strong>Phone:</strong> {{host_phone}}</p>
        </div>

        <div style="text-align: center; margin: 30px 0;">
            <a href="{{receipt_url}}" style="display: inline-block; background: #3b82f6; color: white; padding: 12px 30px; text-decoration: none; border-radius: 6px;">View Receipt</a>
        </div>

        <p style="margin-top: 30px;">We look forward to hosting you!</p>
        <p>Best regards,<br><strong>The {{site_name}} Team</strong></p>
    </div>
    <div style="text-align: center; margin-top: 20px; padding-top: 20px; border-top: 2px solid #e5e7eb; color: #6b7280; font-size: 14px;">
        <p>© {{year}} {{site_name}}. All rights reserved.</p>
    </div>
</body>
</html>',
                'enabled' => true,
            ],
        ];

        foreach ($templates as $template) {
            EmailTemplate::updateOrCreate(
                ['name' => $template['name']],
                $template
            );
        }
    }
}
