<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Booking;
use Carbon\Carbon;

class BookingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $userIds = [1, 2, 3];
        $listingIds = [5, 9, 6, 7, 8, 11];
        $statuses = ['pending', 'confirmed', 'completed', 'cancelled'];

        // Create 30 sample bookings
        for ($i = 0; $i < 30; $i++) {
            $checkIn = Carbon::now()->addDays(rand(1, 60));
            $checkOut = (clone $checkIn)->addDays(rand(1, 7));

            Booking::create([
                'user_id' => $userIds[array_rand($userIds)],
                'listing_id' => $listingIds[array_rand($listingIds)],
                'check_in' => $checkIn,
                'check_out' => $checkOut,
                'guests' => rand(1, 6),
                'total_price' => rand(50, 1500) + (rand(0, 99) / 100),
                'status' => $statuses[array_rand($statuses)],
                'discount_amount' => rand(0, 100),
                'discount_percentage' => rand(0, 20),
                'platform_fee' => rand(5, 50) + (rand(0, 99) / 100),
            ]);
        }
    }
}
