<?php

namespace Database\Seeders;

use App\Models\BadgeConfig;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BadgeConfigSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $badges = [
            [
                'badge_type' => 'rising_star',
                'name' => 'Rising Star',
                'icon' => '⭐',
                'color' => 'bronze',
                'min_reviews' => 10,
                'min_rating' => 4.0,
                'time_period_months' => 3,
                'is_active' => true,
            ],
            [
                'badge_type' => 'top_rated',
                'name' => 'Top Rated',
                'icon' => '🌟',
                'color' => 'silver',
                'min_reviews' => 20,
                'min_rating' => 4.3,
                'time_period_months' => 4,
                'is_active' => true,
            ],
            [
                'badge_type' => 'local_legend',
                'name' => 'Local Legend',
                'icon' => '🏆',
                'color' => 'gold',
                'min_reviews' => 30,
                'min_rating' => 4.5,
                'time_period_months' => 6,
                'is_active' => true,
            ],
        ];

        foreach ($badges as $badge) {
            BadgeConfig::updateOrCreate(
                ['badge_type' => $badge['badge_type']],
                $badge
            );
        }
    }
}
