<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Amenity;
use App\Models\RentalType;

class AmenitiesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $amenitiesData = [
            'Car' => [
                'Air Conditioning',
                'GPS Navigation',
                'Bluetooth Audio',
                'Leather Seats',
                'Backup Camera',
                'USB Charging Ports',
                'Child Seat Available',
                'Automatic Transmission',
                'Manual Transmission',
                'Sunroof',
                'Cruise Control',
                'Parking Sensors',
            ],
            'Houseboat' => [
                'Full Kitchen',
                'Private Bathroom',
                'Bedrooms',
                'Fishing Equipment',
                'BBQ Grill',
                'Life Jackets',
                'WiFi',
                'Solar Power',
                'Kayak Included',
                'Air Conditioning',
                'Heating',
                'Deck Space',
                'Sound System',
            ],
            'Guesthouse' => [
                'Ensuite Bedrooms',
                'Air Conditioning',
                'WiFi',
                'Kitchen Access',
                'Laundry Facilities',
                'Bicycle Rental',
                'Tour Booking Service',
                'Common Lounge',
                'Rooftop Terrace',
                'Parking',
                'Swimming Pool',
                'Garden',
                'TV',
            ],
            'Boat' => [
                'Experienced Captain',
                'Safety Equipment',
                'Snorkeling Gear',
                'Life Jackets',
                'Cooler Box',
                'Sun Shade',
                'First Aid Kit',
                'Bluetooth Speaker',
                'Fishing Equipment',
                'Diving Equipment',
                'GPS Navigation',
                'Toilet Facilities',
            ],
        ];

        foreach ($amenitiesData as $rentalTypeName => $amenities) {
            $rentalType = RentalType::where('name', $rentalTypeName)->first();

            if ($rentalType) {
                $sortOrder = 0;
                foreach ($amenities as $amenityName) {
                    Amenity::create([
                        'name' => $amenityName,
                        'rental_type_id' => $rentalType->id,
                        'is_active' => true,
                        'sort_order' => $sortOrder++,
                    ]);
                }
            }
        }
    }
}
