<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('badge_configs', function (Blueprint $table) {
            $table->id();
            $table->string('badge_type')->unique(); // rising_star, top_rated, local_legend
            $table->string('name'); // Display name
            $table->string('icon')->default('🏅'); // Icon/emoji
            $table->string('color')->default('gray'); // Color theme
            $table->integer('min_reviews')->default(0); // Minimum number of reviews
            $table->decimal('min_rating', 3, 2)->default(0); // Minimum average rating
            $table->integer('time_period_months')->default(6); // Time period in months
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('badge_configs');
    }
};
