<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->integer('total_reviews_count')->default(0)->after('can_create_custom_locations');
            $table->decimal('average_rating', 3, 2)->default(0)->after('total_reviews_count');
            $table->timestamp('last_badge_check')->nullable()->after('average_rating');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['total_reviews_count', 'average_rating', 'last_badge_check']);
        });
    }
};
