<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Insert URL slug settings for existing pages
        DB::table('settings')->insert([
            ['key' => 'privacy_policy_slug', 'value' => '/privacy-policy', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'terms_conditions_slug', 'value' => '/terms-and-conditions', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'advertise_slug', 'value' => '/advertise', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'about_us_slug', 'value' => '/about-us', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'footer_sponsor_logos', 'value' => json_encode([]), 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove settings
        DB::table('settings')->whereIn('key', [
            'privacy_policy_slug',
            'terms_conditions_slug',
            'advertise_slug',
            'about_us_slug',
            'footer_sponsor_logos',
        ])->delete();
    }
};
