<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('host_receipts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id')->constrained()->cascadeOnDelete();
            $table->string('receipt_number')->unique();

            // Booking amounts
            $table->decimal('base_amount', 10, 2); // Rental base price
            $table->decimal('addon_amount', 10, 2)->default(0);
            $table->decimal('discount_amount', 10, 2)->default(0);
            $table->decimal('subtotal', 10, 2); // Before fees

            // Fee deductions
            $table->decimal('platform_fee', 10, 2)->default(0);
            $table->decimal('service_fee', 10, 2)->default(0); // Additional service fee if any
            $table->decimal('total_deductions', 10, 2)->default(0);

            // Host payout
            $table->decimal('host_payout', 10, 2); // Amount host receives

            // Payout tracking
            $table->enum('payout_status', ['pending', 'processing', 'completed', 'failed'])->default('pending');
            $table->timestamp('payout_date')->nullable();
            $table->string('payout_reference')->nullable(); // Bank transfer reference
            $table->text('payout_notes')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('host_receipts');
    }
};
