<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('email_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // welcome, verify_email, reset_password, booking_success
            $table->string('subject');
            $table->text('body'); // HTML content with placeholders
            $table->boolean('enabled')->default(true);
            $table->timestamps();
        });

        // Insert default templates
        DB::table('email_templates')->insert([
            [
                'name' => 'welcome',
                'subject' => 'Welcome to {{site_name}}!',
                'body' => $this->getWelcomeTemplate(),
                'enabled' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'verify_email',
                'subject' => 'Verify Your Email Address',
                'body' => $this->getVerifyEmailTemplate(),
                'enabled' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'reset_password',
                'subject' => 'Reset Your Password',
                'body' => $this->getResetPasswordTemplate(),
                'enabled' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'booking_success',
                'subject' => 'Booking Confirmation - {{invoice_number}}',
                'body' => $this->getBookingSuccessTemplate(),
                'enabled' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    private function getWelcomeTemplate()
    {
        return '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f4f4f4;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f4f4f4; padding: 20px;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 8px; overflow: hidden;">
                    <!-- Header -->
                    <tr>
                        <td style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 40px 20px; text-align: center;">
                            <img src="{{logo_url}}" alt="{{site_name}}" style="max-width: 150px; height: auto;">
                            <h1 style="color: #ffffff; margin: 20px 0 0 0; font-size: 28px;">Welcome to {{site_name}}!</h1>
                        </td>
                    </tr>

                    <!-- Body -->
                    <tr>
                        <td style="padding: 40px 30px;">
                            <h2 style="color: #333333; margin: 0 0 20px 0;">Hi {{user_name}}!</h2>
                            <p style="color: #666666; line-height: 1.6; margin: 0 0 20px 0;">
                                Thank you for joining {{site_name}}! We\'re excited to have you on board.
                            </p>
                            <p style="color: #666666; line-height: 1.6; margin: 0 0 20px 0;">
                                Start exploring amazing rentals and book your perfect stay today!
                            </p>
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin: 30px 0;">
                                <tr>
                                    <td align="center">
                                        <a href="{{site_url}}" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #ffffff; padding: 15px 40px; text-decoration: none; border-radius: 5px; display: inline-block; font-weight: bold;">Explore Now</a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <!-- Footer -->
                    <tr>
                        <td style="background-color: #f9f9f9; padding: 30px; text-align: center; border-top: 1px solid #eeeeee;">
                            <p style="color: #999999; font-size: 14px; margin: 0 0 10px 0;">
                                {{site_name}} - Your Trusted Rental Platform
                            </p>
                            <p style="color: #999999; font-size: 12px; margin: 0;">
                                © {{year}} {{site_name}}. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>';
    }

    private function getVerifyEmailTemplate()
    {
        return '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f4f4f4;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f4f4f4; padding: 20px;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 8px; overflow: hidden;">
                    <tr>
                        <td style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 40px 20px; text-align: center;">
                            <img src="{{logo_url}}" alt="{{site_name}}" style="max-width: 150px; height: auto;">
                            <h1 style="color: #ffffff; margin: 20px 0 0 0; font-size: 28px;">Verify Your Email</h1>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 40px 30px;">
                            <h2 style="color: #333333; margin: 0 0 20px 0;">Hi {{user_name}}!</h2>
                            <p style="color: #666666; line-height: 1.6; margin: 0 0 20px 0;">
                                Please click the button below to verify your email address and activate your account.
                            </p>
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin: 30px 0;">
                                <tr>
                                    <td align="center">
                                        <a href="{{verification_url}}" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #ffffff; padding: 15px 40px; text-decoration: none; border-radius: 5px; display: inline-block; font-weight: bold;">Verify Email Address</a>
                                    </td>
                                </tr>
                            </table>
                            <p style="color: #999999; font-size: 14px; margin: 20px 0 0 0;">
                                If you did not create an account, no further action is required.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #f9f9f9; padding: 30px; text-align: center; border-top: 1px solid #eeeeee;">
                            <p style="color: #999999; font-size: 12px; margin: 0;">
                                © {{year}} {{site_name}}. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>';
    }

    private function getResetPasswordTemplate()
    {
        return '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f4f4f4;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f4f4f4; padding: 20px;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 8px; overflow: hidden;">
                    <tr>
                        <td style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 40px 20px; text-align: center;">
                            <img src="{{logo_url}}" alt="{{site_name}}" style="max-width: 150px; height: auto;">
                            <h1 style="color: #ffffff; margin: 20px 0 0 0; font-size: 28px;">Reset Your Password</h1>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 40px 30px;">
                            <h2 style="color: #333333; margin: 0 0 20px 0;">Hi {{user_name}}!</h2>
                            <p style="color: #666666; line-height: 1.6; margin: 0 0 20px 0;">
                                You are receiving this email because we received a password reset request for your account.
                            </p>
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin: 30px 0;">
                                <tr>
                                    <td align="center">
                                        <a href="{{reset_url}}" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #ffffff; padding: 15px 40px; text-decoration: none; border-radius: 5px; display: inline-block; font-weight: bold;">Reset Password</a>
                                    </td>
                                </tr>
                            </table>
                            <p style="color: #666666; line-height: 1.6; margin: 20px 0 0 0;">
                                This password reset link will expire in 60 minutes.
                            </p>
                            <p style="color: #999999; font-size: 14px; margin: 20px 0 0 0;">
                                If you did not request a password reset, no further action is required.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #f9f9f9; padding: 30px; text-align: center; border-top: 1px solid #eeeeee;">
                            <p style="color: #999999; font-size: 12px; margin: 0;">
                                © {{year}} {{site_name}}. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>';
    }

    private function getBookingSuccessTemplate()
    {
        return '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f4f4f4;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f4f4f4; padding: 20px;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 8px; overflow: hidden;">
                    <tr>
                        <td style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 40px 20px; text-align: center;">
                            <img src="{{logo_url}}" alt="{{site_name}}" style="max-width: 150px; height: auto;">
                            <h1 style="color: #ffffff; margin: 20px 0 0 0; font-size: 28px;">Booking Confirmed!</h1>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 40px 30px;">
                            <h2 style="color: #333333; margin: 0 0 20px 0;">Hi {{customer_name}}!</h2>
                            <p style="color: #666666; line-height: 1.6; margin: 0 0 20px 0;">
                                Your booking has been confirmed! Here are your booking details:
                            </p>

                            <table width="100%" cellpadding="10" cellspacing="0" style="border: 1px solid #eeeeee; border-radius: 5px; margin: 20px 0;">
                                <tr>
                                    <td style="background-color: #f9f9f9; padding: 15px; border-bottom: 1px solid #eeeeee;">
                                        <strong style="color: #333333;">Booking Details</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 15px;">
                                        <table width="100%" cellpadding="5" cellspacing="0">
                                            <tr>
                                                <td style="color: #666666; width: 40%;">Invoice Number:</td>
                                                <td style="color: #333333; font-weight: bold;">{{invoice_number}}</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #666666;">Listing:</td>
                                                <td style="color: #333333; font-weight: bold;">{{listing_title}}</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #666666;">Check-in:</td>
                                                <td style="color: #333333;">{{check_in}}</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #666666;">Check-out:</td>
                                                <td style="color: #333333;">{{check_out}}</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #666666;">Guests:</td>
                                                <td style="color: #333333;">{{guests}}</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #666666;">Total Amount:</td>
                                                <td style="color: #10b981; font-weight: bold; font-size: 18px;">RM {{total_price}}</td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>

                            <p style="color: #666666; line-height: 1.6; margin: 20px 0;">
                                <strong>Host Contact:</strong><br>
                                {{host_name}}<br>
                                {{host_email}}<br>
                                {{host_phone}}
                            </p>

                            <table width="100%" cellpadding="0" cellspacing="0" style="margin: 30px 0;">
                                <tr>
                                    <td align="center">
                                        <a href="{{receipt_url}}" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #ffffff; padding: 15px 40px; text-decoration: none; border-radius: 5px; display: inline-block; font-weight: bold;">Download Receipt</a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #f9f9f9; padding: 30px; text-align: center; border-top: 1px solid #eeeeee;">
                            <p style="color: #999999; font-size: 14px; margin: 0 0 10px 0;">
                                Thank you for choosing {{site_name}}!
                            </p>
                            <p style="color: #999999; font-size: 12px; margin: 0;">
                                © {{year}} {{site_name}}. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>';
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('email_templates');
    }
};
