<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('outgoing_webhook_configs', function (Blueprint $table) {
            $table->id();
            $table->boolean('enabled')->default(false);
            $table->string('webhook_url')->nullable();
            $table->boolean('payment_success')->default(false);
            $table->boolean('payment_failed')->default(false);
            $table->boolean('booking_created')->default(false);
            $table->boolean('booking_cancelled')->default(false);
            $table->text('secret_key')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('outgoing_webhook_configs');
    }
};
