<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('webhook_logs', function (Blueprint $table) {
            $table->id();
            $table->string('source')->index(); // bayarcash, custom, etc.
            $table->string('event_type')->nullable();
            $table->string('webhook_id')->nullable()->index();
            $table->text('url');
            $table->string('method')->default('POST');
            $table->json('headers')->nullable();
            $table->json('payload');
            $table->json('response')->nullable();
            $table->string('status')->default('pending'); // pending, success, failed
            $table->string('ip_address')->nullable();
            $table->text('error_message')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('webhook_logs');
    }
};
