<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Insert default privacy policy and terms content
        DB::table('settings')->insert([
            [
                'key' => 'privacy_policy_content',
                'value' => '<h1>Privacy Policy</h1><p>Your privacy is important to us. This privacy policy explains how we collect, use, and protect your personal information.</p><h2>Information We Collect</h2><p>We collect information that you provide directly to us when you create an account, make a booking, or contact us.</p><h2>How We Use Your Information</h2><p>We use the information we collect to provide, maintain, and improve our services.</p><h2>Contact Us</h2><p>If you have any questions about this privacy policy, please contact us.</p>',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'terms_conditions_content',
                'value' => '<h1>Terms and Conditions</h1><p>Welcome to our platform. By using our services, you agree to these terms and conditions.</p><h2>Use of Service</h2><p>You agree to use our service only for lawful purposes and in accordance with these terms.</p><h2>User Responsibilities</h2><p>You are responsible for maintaining the confidentiality of your account credentials.</p><h2>Limitation of Liability</h2><p>We are not liable for any indirect, incidental, or consequential damages arising from your use of our services.</p><h2>Changes to Terms</h2><p>We reserve the right to modify these terms at any time.</p>',
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove privacy and terms content
        DB::table('settings')->whereIn('key', [
            'privacy_policy_content',
            'terms_conditions_content',
        ])->delete();
    }
};
