<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Insert default footer settings
        DB::table('settings')->insert([
            ['key' => 'footer_copyright_text', 'value' => '© ' . date('Y') . ' GengSewa. All rights reserved.', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'footer_privacy_url', 'value' => '/privacy-policy', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'footer_terms_url', 'value' => '/terms-and-conditions', 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove footer settings
        DB::table('settings')->whereIn('key', [
            'footer_copyright_text',
            'footer_privacy_url',
            'footer_terms_url',
        ])->delete();
    }
};
