<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('add_ons', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Island Hopping", "Fishing Equipment", "Snorkeling Gear"
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2); // Price for the add-on
            $table->enum('pricing_type', ['per_booking', 'per_day', 'per_person']); // How add-on is priced
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Pivot table for listing add-ons (many-to-many)
        Schema::create('listing_add_on', function (Blueprint $table) {
            $table->id();
            $table->foreignId('listing_id')->constrained()->onDelete('cascade');
            $table->foreignId('add_on_id')->constrained()->onDelete('cascade');
            $table->decimal('custom_price', 10, 2)->nullable(); // Host can override default price
            $table->timestamps();

            $table->unique(['listing_id', 'add_on_id']);
        });

        // Pivot table for booking add-ons (selected add-ons for a booking)
        Schema::create('booking_add_on', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id')->constrained()->onDelete('cascade');
            $table->foreignId('add_on_id')->constrained()->onDelete('cascade');
            $table->integer('quantity')->default(1); // For per_person add-ons
            $table->decimal('price_paid', 10, 2); // Price at time of booking
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_add_on');
        Schema::dropIfExists('listing_add_on');
        Schema::dropIfExists('add_ons');
    }
};
