<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('discount_tiers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('listing_id')->constrained()->onDelete('cascade');
            $table->integer('min_days'); // Minimum days to qualify for discount
            $table->integer('max_days')->nullable(); // Maximum days (null = unlimited)
            $table->enum('discount_type', ['fixed', 'percentage']); // Fixed amount or percentage
            $table->decimal('discount_value', 10, 2); // Discount amount or percentage
            $table->timestamps();

            $table->index('listing_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('discount_tiers');
    }
};
