<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $themeSettings = [
            ['key' => 'logo_display_mode', 'value' => 'both'],
            ['key' => 'theme_mode', 'value' => 'system'],
            ['key' => 'custom_primary_color', 'value' => '#6366f1'],
        ];

        foreach ($themeSettings as $setting) {
            DB::table('settings')->updateOrInsert(
                ['key' => $setting['key']],
                $setting
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('settings')->whereIn('key', [
            'logo_display_mode',
            'theme_mode',
            'custom_primary_color',
        ])->delete();
    }
};
