<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add SEO settings to existing settings table
        $seoSettings = [
            ['key' => 'site_name', 'value' => 'GengSewa', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'site_tagline', 'value' => 'Your Trusted Rental Marketplace', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'seo_title', 'value' => 'GengSewa - Rent Cars, Boats, Houseboats & Guesthouses in Malaysia', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'seo_description', 'value' => 'Discover and book the best rental properties in Malaysia. From cars and boats to houseboats and guesthouses. Easy booking, secure payments, verified hosts.', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'seo_keywords', 'value' => 'car rental malaysia, boat rental, houseboat rental, guesthouse booking, vacation rental, property rental malaysia', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'site_logo', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'site_favicon', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'og_image', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'google_analytics_id', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'google_site_verification', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'facebook_app_id', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'twitter_handle', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
        ];

        foreach ($seoSettings as $setting) {
            DB::table('settings')->updateOrInsert(
                ['key' => $setting['key']],
                $setting
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove SEO settings
        $seoKeys = [
            'site_name',
            'site_tagline',
            'seo_title',
            'seo_description',
            'seo_keywords',
            'site_logo',
            'site_favicon',
            'og_image',
            'google_analytics_id',
            'google_site_verification',
            'facebook_app_id',
            'twitter_handle',
        ];

        DB::table('settings')->whereIn('key', $seoKeys)->delete();
    }
};
