<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->timestamps();
        });

        // Insert default settings
        DB::table('settings')->insert([
            ['key' => 'bayarcash_portal', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'bayarcash_pat', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'bayarcash_secret', 'value' => '', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'platform_fee_type', 'value' => 'percentage', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'platform_fee_fixed', 'value' => '0', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'platform_fee_percentage', 'value' => '0', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'platform_fee_charged_to', 'value' => 'guest', 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
